/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_BINTREE_H
#define INCLUDED_BINTREE_H

#include "typedef.h"

/////////////////////////////////////////////////////////////////////////////
// structure for the node of the binary tree
/////////////////////////////////////////////////////////////////////////////
class zBTNode
{
	friend class zBinTree;

public:
	zBTNode(void *aData = 0): data(aData), left(0), right(0){}

private:
	void    *data;
	zBTNode *left;
	zBTNode *right;
};

/////////////////////////////////////////////////////////////////////////////
// the binary tree class
/////////////////////////////////////////////////////////////////////////////

typedef void (*fpCleanupFunc)(void*);

class zBinTree
{
public:
	enum tree_order { pre, post, in, rev };

	zBinTree(fpCompFunc compare, Boolean shouldPurge = False);
	virtual ~zBinTree();

	Boolean insert(void *p);
	void    remove(void *p);
	void    remove();
	int     size() const { return count; }
	void*   get(){ return current ? current->data : 0; }
	void    update(void *p);
	void*   find(void *arg);
	void    forEach(fpAppFunc app, void *arg = 0, tree_order order = in);
	void*   operator()(){ return get(); }
	void    setCleanup(fpCleanupFunc cf){ cleanup = cf; }
	void    purge();

protected:
	Boolean        purging;
	int            count;
	fpCompFunc     compare;
	fpCleanupFunc  cleanup;
	fpAppFunc      action;
	void          *action_arg;
	zBTNode       *current;
	zBTNode       *parent;
	zBTNode       *root;

	void destroy(zBTNode *root);
	void in_order(zBTNode *root);
	void pre_order(zBTNode *root);
	void post_order(zBTNode *root);
	void rev_order(zBTNode *root);
};

#endif /* INCLUDED_BINTREE_H */