; PHONE.CTL - sample phone control file - by Stefan Xenos
;
;       This file defines how Padlock treats different phone 
;       numbers. You should edit it to reflect your local 
;       calling area.
;

; Define the format for local and long distance phone numbers.
#local_format   (!!!)-???-????  ; Dial last 7 digits for local calls
#ld_format    1-(???)-???-????  ; Dial 1 plus all ten digits for ld calls

; What time of the day should verifications be allowed?
;               Start time      End time
;#local_times    10:00           22:00    ; Only call locally during the day.
;#ld_times       23:00           10:30    ; Only call long distance during the night.
;#times          10:00           22:00    ; Only call anywhere during the day.

; Locked out phone numbers -----------------------------------------

#lockout                        ; The following phone numbers are locked out
#write Scanning locked out phone numbers...

#include PADLOCK\LOCKOUT.CTL    ; Include a file containing a list of locked out #s.

; Local calling area --------------------------------------------

#local                          ; The following numbers are local
#write Scanning local calling area...
#write Area 613...              ; Display message to user

#city Almonte, Ontario
(613) 256*

#city Carleton Place, Ontario
(613) 25[37]*

#city Ottawa, Ontario
(613) 22[34568]*
(613) 23*
(613) 24![0289]*
(613) 274*
(613) 29[0123]*
(613) 310*
(613) 350*
(613) 364*
(613) 52[01369]*
(613) 56*
(613) 58[01]*
(613) 59[345678]*
(613) 66[04]*
(613) 71[89]*
(613) 72*
(613) 73![25]*
(613) 74!0*
(613) 75[0159]*
(613) 76[012359]*
(613) 77!4*
(613) 78!4*
(613) 79[0145789]*
(613) 82[089]*
(613) 84[24]*
(613) 85[012]*
(613) 860*
(613) 920*
(613) 94[134567]*
(613) 95[1234567]*
(613) 99!9*
#endcity

#write Area 819...              ; Display message to user

#city Hull, Quebec
(819) 22[34568]*
(819) 23*
(819) 24![0289]*
(819) 274*
(819) 29[0123]*
(819) 310*
(819) 350*
(819) 364*
(819) 52[01369]*
(819) 56*
(819) 58[01]*
(819) 59[345678]*
(819) 66[04]*
(819) 71[89]*
(819) 72*
(819) 73![25]*
(819) 74!0*
(819) 75[0159]*
(819) 76[012359]*
(819) 77!4*
(819) 78!4*
(819) 79[0145789]*
(819) 82[089]*
(819) 84[24]*
(819) 85[012]*
(819) 860*
(819) 920*
(819) 94[134567]*
(819) 95[1234567]*
(819) 99!9*
#endcity

; Long distance numbers ----------------------------------------------------

#ld                             ; The numbers that follow are long distance.
#city Stittsville
(613) 258*                      ; Stittsville
#endcity

; Miscellaneous numbers ----------------------------------------------------

#ask_local                      ; 613 numbers not already listed may be new
(613) *                         ; local extensions which have not yet been
                                ; added to the phone book. If this is the
                                ; case, ask the user if his/her number is
                                ; local.

(819) *                         ; The same may be true for new 819 numbers,

; Note that an #end directive is no longer required at the end of this file.
