Attribute VB_Name = "Module1"
'/*****************************************************************************
'*                                                                            *
'* Copyright (c) 1996-1997 Funduc Software Inc.   All rights reserved.        *
'*                                                                            *
'* These programs are the sole property of Funduc Software Inc. and contain   *
'* proprietary information.  These routines should not by used by anyone      *
'* except Funduc Software Inc.'s customers in accoordance with terms of a     *
'* license.  To get one, visit us at http://www.funduc.com                    *
'* or E-MAIL: funduc@sprynet.com or 102372.2530@compuserve.com                *
'*                                                                            *
'*****************************************************************************/

'/* Possible values for the nType parameter passed to EncodeFile()
'   and return code from DecodeFile */
Global Const NOT_ENC = 0           '/* Not encoded */
Global Const UUE = 1               '/* UUENCODED file */
Global Const MIME = 2              '/* Base64 encoded (MIME) */
Global Const BINHEX = 3            '/* BinHex (Macintosh) encoding */
Global Const XXE = 4               '/* No prompts, file names passed in are used */

'/* Possible values for the nPrompt parameter to Decode File() */
Global Const PROMPT_ALL = 0        '/* DLL prompts for everything */
Global Const PROMPT_NONE = 1       '/* No prompts, file names passed in are used */
Global Const PROMPT_OVERWRITE = 2  '/* DLL only prompts for overwrites */

'/* How many files are encoded */
#If Win16 Then
Declare Function GetNumFilesToDecode Lib "DECENC16.DLL" (ByVal strInFile As String) As Integer
#Else
Declare Function GetNumFilesToDecode Lib "DECENC32.DLL" (ByVal strInFile As String) As Integer
#End If
'/* 0 relative index into the array of names (see call above) */
#If Win16 Then
Declare Function GetEncodedFile Lib "DECENC16.DLL" (ByVal strOutFile As String, ByVal nIndex As Integer) As Integer
#Else
Declare Function GetEncodedFile Lib "DECENC32.DLL" (ByVal strOutFile As String, ByVal nIndex As Long) As Integer
#End If
'/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
'   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode()
'   and GetEncodedFile in a loop to get the list of files first. The list of files passed
'   (after modification if needed) must then be delimited by the ';' character */
'/* Return code is one of the Encoding types above */
#If Win16 Then
Declare Function DecodeFile Lib "DECENC16.DLL" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Integer) As Integer
#Else
Declare Function DecodeFile Lib "DECENC32.DLL" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Integer) As Integer
#End If
'/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
'   for example */
#If Win16 Then
Declare Function EncodeFile Lib "DECENC16.DLL" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal CodeOption As Integer, ByVal xAppend As Integer) As Integer
#Else
Declare Function EncodeFile Lib "DECENC32.DLL" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal CodeOption As Integer, ByVal xAppend As Integer) As Integer
#End If
'/* call with the name of registered application to write that to the encoded file */
#If Win16 Then
Declare Sub SetEncodingApplication Lib "DECENC16.DLL" (ByVal strInFile As String)
#Else
Declare Sub SetEncodingApplication Lib "DECENC32.DLL" (ByVal strInFile As String)
#End If
'/* Utility functions */
'/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
#If Win16 Then
Declare Function GetUniqueFileName Lib "DECENC16.DLL" (ByVal szFileName As String) As Integer
#Else
Declare Function GetUniqueFileName Lib "DECENC32.DLL" (ByVal szFileName As String) As Integer
#End If
'/* This function will concatenate related files into the first one.  All files must
'   be found in the same directory.
'   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
'   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
'   The name of the last concatenated file is returned in szFileName
'*/
#If Win16 Then
Declare Function ConcatenateRelated Lib "DECENC16.DLL" (ByVal bDeleteOthers As Boolean, ByVal szFileName As String) As Integer
#Else
Declare Function ConcatenateRelated Lib "DECENC32.DLL" (ByVal bDeleteOthers As Boolean, ByVal szFileName As String) As Integer
#End If

'/* This function will split a file into as many smaller files as necessary
'   For example: file.dat of size 100000 will be split into
'   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
'   if 35000 is used for the lFileSize parameter
'   The name of the last split file is returned in szFileName
'*/
#If Win16 Then
Declare Function SplitFile Lib "DECENC16.DLL" (ByVal szFileName As String, ByVal lFileSize As Long) As Integer
#Else
Declare Function SplitFile Lib "DECENC32.DLL" (ByVal szFileName As String, ByVal lFileSize As Long) As Integer
#End If




