//: Multithreading example
#include <windows.h>
#include <process.h>
#include <iostream>
#include "DirWalk.h"

#if !defined(__BORLANDC__)
 unsigned int WINAPI WalkingThread(LPVOID lpvStartingDir);
#else
 void WalkingThread(LPVOID lpvStartingDir);
#endif

CRITICAL_SECTION CriticalSection;

class TheWalk : public DirWalk {
 static int id_;
 int thisid_;
public:
 inline TheWalk(const char* StartingDirectory) : 
           DirWalk(StartingDirectory) { thisid_=id_++; }

protected:
 inline virtual void FoundFile() {
  EnterCriticalSection(&CriticalSection);
  cout << endl << "Thread #" << thisid_ << endl;
  DirWalk::FoundFile();
  cout << endl << FullPathName();
  LeaveCriticalSection(&CriticalSection);
 }
};
int TheWalk::id_ = 0;

int main(int argc,char* argv[]) {
 if(argc!=5) return 1;
 InitializeCriticalSection(&CriticalSection);
 HANDLE ThreadHandles[4];
 for(int i=0;i<4;i++) {

#if defined(_MSC_VER)
  unsigned int ThreadID;
  ThreadHandles[i]=(HANDLE)_beginthreadex(NULL,0,
                               WalkingThread,argv[i+1],0,&ThreadID);
#elif defined(__BORLANDC__)
  unsigned long ThreadID;
  ThreadHandles[i]=(HANDLE)_beginthreadNT(WalkingThread,0,
                                        argv[i+1],NULL,0,&ThreadID);
#else
  unsigned long ThreadID;
  ThreadHandles[i]=CreateThread(NULL,0,WalkingThread,
                                             argv[i+1],0,&ThreadID);
#endif

 }
 WaitForMultipleObjects(4,ThreadHandles,TRUE,INFINITE);
 for(int j=0;j<4;j++) {
  CloseHandle(ThreadHandles[j]);
 }
 DeleteCriticalSection(&CriticalSection);
 return 0;
}

#if !defined(__BORLANDC__)
 unsigned int WINAPI WalkingThread(LPVOID lpvStartingDir) {
#else
 void WalkingThread(LPVOID lpvStartingDir) {
#endif

 TheWalk w((const char*)lpvStartingDir);
 w.Walk();

#if !defined(__BORLANDC__)
 return 0;
#endif

}
