//: FileTime.cpp
#include "FileTime.h"
#include <iomanip>
#include <strstream>
#include <stdexcept>
#include <windows.h>

#if defined(__BORLANDC__)
 using namespace std;
#endif

/**
 * This is where most of the real work of the class is done.
 * NewTime() takes an argument of type FILETIME and then makes the
 * appropriate API calls to turn this into a useful set of data.
 * This data is then stored in the object's member variables. A
 * FILETIME object is returned from various file access functions,
 * but the data it contains is not generally useful, and must be
 * converted.
 **/
void FileTime::NewTime(const FILETIME *pFileTime)
     throw(runtime_error){

    ZeroMemberVars();
 
 FILETIME LocalFileTime;
 BOOL bResult=FileTimeToLocalFileTime(pFileTime,&LocalFileTime);
 if(!bResult) throw runtime_error(
        "Problem in FileTime::NewTime().Couldn't convert file time"
        " to local time");
 
 SYSTEMTIME SystemTime;
 bResult=FileTimeToSystemTime(&LocalFileTime,&SystemTime);
 if(!bResult) throw runtime_error(
        "Problem in FileTime::NewTime().Couldn't convert local time"
        " to system time");

 mYear        = SystemTime.wYear;
 mMonth       = SystemTime.wMonth;
 mDayOfWeek   = SystemTime.wDayOfWeek;
 mDay         = SystemTime.wDay;
 mHour        = SystemTime.wHour;
 mMinute      = SystemTime.wMinute;
 mSecond   = SystemTime.wSecond;
 mMillisecond = SystemTime.wMilliseconds;
}

void FileTime::ZeroMemberVars() throw() {
 mYear=0;
 mMonth=0;
 mDayOfWeek=0;
 mDay=0;
 mHour=0;
 mMinute=0;
 mSecond=0;
 mMillisecond=0;
 mDateSeparator='/';
 mTimeSeparator=':';
 mDateFillCharacter='0';
 mTimeFillCharacter='0';
}

/**
 * These and all the following functions in this module just format
 * a string into memory and return a pointer to that memory. These
 * things might better be done in NewTime(), but that would require
 * separate storage for each string the user might request, and also
 * a formatting penalty for each call to NewTime() even if a user
 * never needed the strings. So, in the spirit of C++, I decided
 * that if you don't use it, you shouldn't pay for it, and all the
 * code related to generating the strings is contained in these
 * functions.
 **/
const char* const FileTime::DateString() throw() {
 ostrstream osDate(mString,MaxLength);
 osDate << setfill(mDateFillCharacter)
   << setw(MonthLength) << mMonth << mDateSeparator
   << setw(DayLength)  << mDay   << mDateSeparator
   << setw(YearLength)  << mYear  << ends;
 return mString;
}

const char* const FileTime::TimeString() throw() {
 ostrstream osTime(mString,MaxLength);
 osTime << setfill(mTimeFillCharacter) 
           << setw(HourLength)       << mHour      << mTimeSeparator
           << setw(MinuteLength)     << mMinute    << mTimeSeparator
           << setw(SecondLength)     << mSecond    << mTimeSeparator
     << setw(MillisecondLength) << mMillisecond << ends;
 return mString;
}

const char* const FileTime::YearString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mDateFillCharacter) << setw(YearLength) << mYear
       << ends;
 return mString;
}

const char* const FileTime::MonthString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mDateFillCharacter) << setw(MonthLength) << mMonth
  << ends;
 return mString;
}

const char* const FileTime::DayOfWeekString() throw() {
 const char TempString[][DayOfWeekLength+1]= {
  "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
  "Friday", "Saturday" };
 ostrstream os(mString,MaxLength);
 os << setw(DayOfWeekLength) << TempString[mDayOfWeek] << ends;
 return mString;
}

const char* const FileTime::DayString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mDateFillCharacter) << setw(DayLength) << mDay <<
  ends;
 return mString;
}

const char* const FileTime::HourString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mTimeFillCharacter) << setw(HourLength) << mHour
       << ends;
 return mString;
}

const char* const FileTime::MinuteString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mTimeFillCharacter) << setw(MinuteLength) <<
          mMinute << ends;
 return mString;
}

const char* const FileTime::SecondString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mTimeFillCharacter) << setw(SecondLength) <<
          mSecond << ends;
 return mString;
}

const char* const FileTime::MillisecondString() throw() {
 ostrstream os(mString,MaxLength);
 os << setfill(mTimeFillCharacter) << setw(MillisecondLength) <<
  mMillisecond << ends;
 return mString;
}
