unit E_cmpEd;

interface
(*******************************************************************
                            E_CmpEd
    Object Inspector/Component Editor.
    Author : David Spies
    Contacts : Work - davidsp@eastsoft.com Home DSPIES@onecom.com  *)
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Buttons, ExtCtrls, ComCtrls, E_Props,
  Consts;

type
  TCompEditForm = class(TForm)
    StringGrid1: TStringGrid;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    ComponentBox: TComboBox;
    EditStr: TEdit;
    ComboEnum: TComboBox;
    SetEdit: TListBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Panel1Resize(Sender: TObject);
    procedure ComponentBoxChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; Col, Row: Longint;
                                    var CanSelect: Boolean);
    procedure StringGrid1DblClick(Sender: TObject);
    procedure StringGrid1Exit(Sender: TObject);
    procedure FixUpOnExit(Sender: TObject);
    procedure EditStrKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    PropList     : TStringList;
    FComponent   : TComponent;
    CurComponent : TComponent;
    CompProp     : TEProperty;
    Procedure ShowCurrentComponent;
    procedure ClearPropList;
    procedure DoLastControl;
    Procedure EGetStrs(Const s : String);
    procedure SetEditBounds(AControl : TWinControl);
  public
    { Public declarations }
    Procedure Execute(AComponent : TComponent;
                      IsModal    : Boolean);
 end;
 Procedure EditAComponent(AComponent : TComponent;
                          ACaption   : String;
                          IsModal    : Boolean);
var
  CompEditForm: TCompEditForm;

implementation

{$R *.DFM}
Uses
     ImageWin,StrEdit;
Type
       ECompEditError   = class(Exception);
Const
       MrArray   : Array[mrNone..MrNo] Of String =
        ('mrNone',
         'mrOk',
         'mrCancel',
         'mrAbort',
         'mrRetry',
         'mrIgnore',
         'mrYes',
         'mrNo');
Function StripAllChr(InStr    : String;
                     StripChr : Char) : String;
Var
  I : Integer;
begin
  I := 1;
  while (I <= Length(InStr)) do
    if InStr[I] = StripChr then
      Delete(InStr, I, 1)
    else
      Inc(I);
  Result := InStr;
end;
procedure TCompEditForm.FormClose(    Sender: TObject;
                                  var Action: TCloseAction);
begin
  ClearPropList; {Clear the property list and free the form}
end;
procedure TCompEditForm.ClearPropList;
Var
    I       : Integer;
begin                   {Clear the Property List}
  If PropList<>Nil then
    For I:=0 to PropList.Count-1 do
    begin
      CompProp:=PropList.Objects[I] As TEProperty;
      CompProp.Free;
    end;
    PropList.Free;
  PropList:=Nil;
end;
procedure TCompEditForm.Panel1Resize(Sender: TObject);
begin
  ComponentBox.Width:=Panel1.Width;
end;
Procedure TCompEditForm.ShowCurrentComponent;
Var
    S          : String;
    ACount     : Integer;
    I          : Integer;
    AComponent : TComponent;
    TInt       : Integer;
               Procedure DelCurrent;
               begin
                 CompProp:=PropList.Objects[I] As TEProperty;
                 CompProp.Free;
                 PropList.Delete(I);
                 Dec(Acount);
               end;
begin
  S :=Copy(ComponentBox.Text,1,Pred(Pos(':',ComponentBox.Text)));
  AComponent:=FComponent;
  If S<>'' then
    For I:=0 to FComponent.ComponentCount-1 do
      If FComponent.Components[I].Name=S then
      begin
        AComponent:=FComponent.Components[I];
        Break;
      end;
  If (AComponent<>Nil) AND (AComponent<>CurComponent) then
  begin
    CurComponent:=AComponent;
    ClearPropList;
    ACount:=E_EnumProperties(CurComponent,PropList);
    I:=0;
    While I<ACount do
    begin
      S:=UpperCase(PropList.Strings[I]);
      If (S='MASTERFIELDS') OR (S='MASTERSOURCE') OR
         (S='SESSIONNAME') OR (S='UPDATEOBJECT') OR
         (S='INDEXFILES') OR (S='E_USEWHO') then
        DelCurrent
      else
        Inc(I);
    end;
    If ACount>0 then
    begin
      StringGrid1.RowCount:=ACount;
      For I:=0 to ACount-1 do
      begin
        StringGrid1.Cells[0,I]:=PropList.Strings[I];
        CompProp:=PropList.Objects[I] As TEProperty;
        If UpperCase(PropList.Strings[I])='MODALRESULT' then
        begin
          TInt:=StrToInt(CompProp.PValue);
          If (TInt<MrNone) OR (TInt>MrNo) then
            TInt:=mrNone;
          CompProp.PValue:=mrArray[TInt];
          CompProp.EType:=PROP_MODALTYPE;
        end;
        StringGrid1.Cells[1,I]:=CompProp.PValue;
      end;
      StringGrid1.Col:=1;
      StringGrid1.Row:=0;
    end
    else
      StringGrid1.RowCount:=0;
  end;
end;
procedure TCompEditForm.ComponentBoxChange(Sender: TObject);
begin
  ShowCurrentComponent;
end;
Procedure TCompEditForm.Execute(AComponent : TComponent;
                                IsModal    : Boolean);
Var
     I : Integer;
              Function AddComponent(AComponent : TComponent) : String;
              begin
                Result:=AComponent.Name+':'+AComponent.ClassName;
              end;
begin
  ComponentBox.Items.Clear;
  FComponent:=AComponent;
  If FComponent.ComponentCount>1 then
    ComponentBox.Items.Add(AddComponent(FComponent))
  else
    ComponentBox.Enabled:=False;
  For I:=0 to FComponent.ComponentCount-1 do
    ComponentBox.Items.Add(AddComponent(FComponent.Components[I]));
  ComponentBox.ItemIndex:=0;
  CurComponent:=Nil;
  ShowCurrentComponent;
  If IsModal then
  begin
    BorderIcons:=BorderIcons-[biMinimize];
    Height:=Height DIV 2;
    ShowModal;
  end
  else
    Show;
end;

procedure TCompEditForm.FormResize(Sender: TObject);
begin
  StringGrid1.DefaultColWidth:=(ClientWidth-20) DIV 2;
  With StringGrid1 do
  begin
    ColWidths[0]:=DefaultColWidth;
    ColWidths[1]:=DefaultColWidth;
  end;
  If (ActiveControl=EditStr) OR (ActiveControl=ComboEnum) OR
     (ActiveControl=SetEdit) then
    SetEditBounds(ActiveControl);
end;
procedure TCompEditForm.DoLastControl;
Var
    CurRow  : Integer;
    PropStr : String;
    S       : String;
    TInt    : Integer;
    Tf      : Extended;
begin
  CurRow:=StringGrid1.Row;
  If CurRow<Proplist.Count then
  begin
    PropStr:=PropList.Strings[CurRow];
    CompProp:=PropList.Objects[CurRow] AS TEProperty;
    If CompProp<>Nil then
    begin
      If CompProp.EType=PROP_STRTYPE then
      begin
        If E_SetStrProp(CurComponent,PropStr,EditStr.Text) then
          CompProp.PValue:=EditStr.Text;
      end
      else If CompProp.EType=PROP_CHARTYPE then
      begin
        S:=StripAllChr(EditStr.Text,#32);
        If S='' then
          TInt:=0
        else If S[1]='#' then
        begin
          Delete(S,1,1);
          TInt:=StrToInt(S);
        end
        else
          TInt:=Ord(S[1]);
        If E_SetIntProp(CurComponent,PropStr,TInt) then
          CompProp.PValue:=EditStr.Text;
      end
      else If CompProp.EType=PROP_BOOLTYPE then
      begin
        If E_SetBoolProp(CurComponent,PropStr,ComboEnum.Text='True') then
          CompProp.PValue:=ComboEnum.Text;
      end
      else If CompProp.EType=PROP_INTTYPE then
      begin
        TInt:=StrToInt(EditStr.Text);
        With CompProp do
          if (TInt < MinVal) or (TInt > MaxVal) then
            raise ECompEditError.CreateResFmt(SOutOfRange, [MinVal,MaxVal]);
        If E_SetIntProp(CurComponent,PropStr,TInt) then
          CompProp.PValue:=EditStr.Text;
      end
      else If CompProp.EType=PROP_REALTYPE then
      begin
        Tf:=StrToFloat(EditStr.Text);
        If E_SetRealProp(CurComponent,PropStr,Tf) then
          CompProp.PValue:=EditStr.Text;
      end
      else If CompProp.EType IN [PROP_ENUMTYPE,PROP_MODALTYPE] then
      begin
        If E_SetIntProp(CurComponent,PropStr,ComboEnum.ItemIndex) then
          CompProp.PValue:=ComboEnum.Text;
      end
      else If CompProp.EType=PROP_SETTYPE then
      begin
        CompProp.PValue:='[';
        For TInt:=0 to SetEdit.Items.Count-1 do
          If SetEdit.Selected[TInt] then
          begin
            if Length(CompProp.PValue) <> 1 then
              CompProp.PValue:=CompProp.PValue+',';
            CompProp.PValue:=CompProp.PValue+SetEdit.Items.Strings[TInt];
          end;
        CompProp.PValue:=CompProp.PValue+']';
        If NOT E_SetSetStrProp(CurComponent,PropStr,CompProp.PValue) then
          CompProp.PValue:=StringGrid1.Cells[1,CurRow];
      end
      else If CompProp.EType=PROP_COLORTYPE then
      begin
        If E_SetIntProp(CurComponent,PropStr,StringToColor(ComboEnum.Text)) then
          CompProp.PValue:=ComboEnum.Text;
      end
      else If CompProp.EType=PROP_CURSORTYPE then
      begin
        If E_SetIntProp(CurComponent,PropStr,StringToCursor(ComboEnum.Text)) then
          CompProp.PValue:=ComboEnum.Text;
      end;
      StringGrid1.Cells[1,CurRow]:=CompProp.PValue;
    end;
  end;
end;
procedure TCompEditForm.StringGrid1SelectCell(Sender        : TObject;
                                              Col           ,
                                              Row           : Longint;
                                              var CanSelect : Boolean);
begin
  If Col=1 then
  begin
    CanSelect:=True;
    If TEProperty(PropList.Objects[Row]).EType=PROP_NOTYPE then
      StatusBar1.SimpleText:='This Property Cannot Be Edited'
    else
      StatusBar1.SimpleText:='Double Click To Edit Property';
  end
  else
    CanSelect:=False;
end;
Procedure TCompEditForm.EGetStrs(Const s : String);
begin
  ComboEnum.Items.Add(S);
end;
procedure TCompEditForm.SetEditBounds(AControl : TWinControl);
Var
    Rect : TRect;
begin
  If AControl<>Nil then With AControl do
  begin
    CompProp:=PropList.Objects[StringGrid1.Row] AS TEProperty;
    Rect := StringGrid1.CellRect(1,StringGrid1.Row);
    If CompProp.EType = PROP_SETTYPE then
    begin
      Left:=0;
      Top:=Rect.Top+StringGrid1.Top+StringGrid1.DefaultRowHeight;
      Height:=StringGrid1.DefaultRowHeight*3;
      Width:=StringGrid1.Width;
    end
    else
    begin
      Left:=Rect.Left+1;
      Top:=Rect.Top+StringGrid1.Top;
      Height:=StringGrid1.DefaultRowHeight;
      Width:=StringGrid1.DefaultColWidth;
    end;
    StatusBar1.SimpleText:='';
    Visible:=True;
    ActiveControl:=AControl;
  end
end;
procedure TCompEditForm.StringGrid1DblClick(Sender: TObject);
Var
    CurRow     : Integer;
    CurEdit    : TWinControl;
    DoIt       : Boolean;
    I          : Integer;
    S          ,
    Ts         : String;
    FontDialog : TFontDialog;
begin
  CurRow:=StringGrid1.Row;
  CurEdit:=Nil;
  CompProp:=PropList.Objects[CurRow] AS TEProperty;
  If CompProp.EType IN [PROP_STRTYPE,PROP_INTTYPE,PROP_REALTYPE,PROP_CHARTYPE] then
  begin
    EditStr.MaxLength:=CompProp.MaxChars;
    EditStr.Text:=CompProp.PValue;
    CurEdit:=EditStr;
  end
  else If CompProp.EType IN [PROP_BOOLTYPE,PROP_ENUMTYPE,PROP_COLORTYPE,PROP_CURSORTYPE,PROP_MODALTYPE] then
  begin
    ComboEnum.Items.Clear;
    DoIt:=True;
    Case CompProp.EType of
      PROP_BOOLTYPE   ,
      PROP_ENUMTYPE   : DoIt:=E_GetEnumList(CompProp,ComboEnum.Items);
      PROP_COLORTYPE  : GetColorValues(EGetStrs);
      PROP_CURSORTYPE : GetCursorValues(EGetStrs);
      PROP_MODALTYPE  : For I:=MrNone to MrNo do
                          ComboEnum.Items.Add(MrArray[I]);
    else
      DoIt:=False;
    end;
    If DoIt then
    begin
      ComboEnum.Text:=CompProp.PValue;
      ComboEnum.ItemIndex:=ComboEnum.Items.IndexOf(CompProp.PValue);
      CurEdit:=ComboEnum;
    end;
  end
  else If CompProp.EType = PROP_SETTYPE then
  begin
    If E_GetEnumList(CompProp,SetEdit.Items) then
    begin
      S:=StripAllChr(StripAllChr(StringGrid1.Cells[1,CurRow],'['),']');
      While S<>'' do
      begin
        I:=Pos(',',S);
        If I=0 then
          I:=Succ(Length(S));
        Ts:=Copy(S,1,Pred(I));
        Delete(S,1,I);
        I:=SetEdit.Items.IndexOf(Ts);
        If I>-1 then
          SetEdit.Selected[I]:=True;
      end;
      CurEdit:=SetEdit;
    end;
  end;
  If CurEdit<>Nil then
    SetEditBounds(CurEdit)
  else If CompProp.EType=PROP_CLASSTYPE then
  begin
    Try
      If CompProp.SubType=PROP_FONTSUB then
      begin
        FontDialog := TFontDialog.Create(Application);
        try
          FontDialog.Font := TFont(CompProp.ClassAddr);
          FontDialog.Options := FontDialog.Options + [fdForceFontExist];
          if FontDialog.Execute then
            If E_SetIntProp(CurComponent,PropList.Strings[CurRow],LongInt(FontDialog.Font)) then
              CompProp.PValue:=FontDialog.Font.Name;
        finally
          FontDialog.Free;
        end;
      end
      else If CompProp.SubType=PROP_ICONSUB then
      begin
        ImageForm.IconsOnly;
        ImageForm.Image1.Picture.Icon.Assign(TIcon(CompProp.ClassAddr));
        If ImageForm.ShowModal=mrOk then
          TIcon(CompProp.ClassAddr).Assign(ImageForm.Image1.Picture.Icon);
      end
      else If CompProp.SubType=PROP_BMPSUB then
      begin
        DoIt:=UpperCase(StringGrid1.Cells[0,CurRow])='GLYPH';
        ImageForm.BmpsOnly(DoIt);
        ImageForm.Image1.Picture.BitMap.Assign(TBitMap(CompProp.ClassAddr));
        If ImageForm.ShowModal=mrOk then
          TBitMap(CompProp.ClassAddr).Assign(ImageForm.Image1.Picture.BitMap);
        If DoIt then
        begin
          For I := 0 To StringGrid1.RowCount-1 do
            If UpperCase(StringGrid1.Cells[0,I])='NUMGLYPHS' then
            begin
              If E_SetIntProp(CurComponent,StringGrid1.Cells[0,I],StrToInt(ImageForm.UpDownEdit.Text)) then
              begin
                With PropList.Objects[I] AS TEProperty do
                begin
                  PValue:=ImageForm.UpdownEdit.Text;
                  StringGrid1.Cells[0,I]:=PValue;
                end;
              end;
              Break;
            end;
        end;
      end
      else If CompProp.SubType=PROP_TSTRSUB then
      begin
        SedForm.StrList.Lines.Assign(TStrings(CompProp.ClassAddr));
        If (SedForm.ShowModal=mrOk) then
          TStrings(CompProp.ClassAddr).Assign(SedForm.StrList.Lines);
      end
      else If Assigned(TComponent(CompProp.ClassAddr)) then
      begin
        E_GetStrProp(CurComponent,'Name',ts);
        If ts<>'' then
          ts:=ts+'.';
        ts:=ts+StringGrid1.Cells[0,CurRow];
        EditAComponent(TComponent(CompProp.ClassAddr),ts,True);
      end;
      StringGrid1.Cells[1,CurRow]:=CompProp.PValue;
    Finally
    end;
  end;
end;

procedure TCompEditForm.StringGrid1Exit(Sender: TObject);
begin
  StatusBar1.SimpleText:='';
end;

procedure TCompEditForm.FixUpOnExit(Sender: TObject);
Var
    S : String;
begin
  If CompProp.EType=PROP_SETTYPE then
    S:=''
  else If NOT E_GetStrProp(TComponent(Sender),'Text',S) then
    S:=StringGrid1.Cells[1,StringGrid1.Row];
  Try
     If (S<>StringGrid1.Cells[1,StringGrid1.Row]) then
        DoLastControl;
  Finally
     E_SetBoolProp(TComponent(Sender),'Visible',False);
  end;
end;

procedure TCompEditForm.EditStrKeyPress(Sender: TObject; var Key: Char);
begin
  If StringGrid1.Row>=PropList.Count then
    Exit;
  CompProp:=PropList.Objects[StringGrid1.Row] AS TEProperty;
  Case CompProp.EType Of
    PROP_CHARTYPE : If Key IN ['0'..'9'] then
                      If Pos('#',EditStr.Text)=0 then
                        Key:=#0;
    PROP_INTTYPE  : If (Key='-') AND (CompProp.MinVal>-1) then
                      Key:=#0
                    else If NOT (Key IN ['-','0'..'9']) then
                      Key:=#0;
    PROP_REALTYPE  : If (Key='.') AND (EditStr.Text='') then
                      Key:=#0
                    else If NOT (Key IN ['-','.','0'..'9']) then
                      Key:=#0;
  end;
end;


Procedure EditAComponent(AComponent : TComponent;
                         ACaption   : String;
                         IsModal    : Boolean);
Var
    AForm : TCompEditForm;
begin
  AForm:=TCompEditForm.Create(Application);
  If ACaption<>'' then
    AForm.Caption:=ACaption;
  AForm.Execute(AComponent,True);
  AForm.Free;
end;
end.
