unit BrCstOrd;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, DBCtrls, StdCtrls, ExtCtrls, Grids, DBGrids, Buttons,
  adbgrid, Mask,  filtcomp, afilter, aDatedit;

type
  TBrCustOrdForm = class(TForm)
    CtrlsPanel: TPanel;
    Navigator: TDBNavigator;
    BtnPanel: TPanel;
    EditBtn: TButton;
    CloseBtn: TButton;
    CustPanel: TPanel;
    OrdersPanel: TPanel;
    Bevel1: TBevel;
    CustGrid: TAutoDBGrid;
    FilterLink1: TFilterLink;
    DateFilter1: TDateFilter;
    DateFilter2: TDateFilter;
    FilterLink2: TFilterLink;
    FilterLink3: TFilterLink;
    ActivateBtn: TSpeedButton;
    OrdersGrid: TAutoDBGrid;
    Label1: TLabel;
    procedure CustGridEnter(Sender: TObject);
    procedure ActivateQuery(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure OrdersGridEnter(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FActiveSource: TDataSource;
    FCustNo: Double;
    FOrderNo: Double;
    function GetCustNo: Double;
    function GetOrderNo: Double;
    procedure SetActiveSource(DataSource: TDataSource);
    procedure SetCustNo(NewCustNo: Double);
    procedure SetOrderNo(NewOrderNo: Double);
    property ActiveSource: TDataSource read FActiveSource write SetActiveSource;
  public
    property CustNo: Double read GetCustNo write SetCustNo;
    property OrderNo: Double read GetOrderNo write SetOrderNo;
  end;

var
  BrCustOrdForm: TBrCustOrdForm;

implementation

uses EdCust, EdOrders, Main, DataMod;

{$R *.DFM}

{ Retrieve from active customer table or query--whichever is active }

function TBrCustOrdForm.GetCustNo: Double;
begin
  Result := MastData.CustMasterSrc.Dataset.Fields[0].AsFloat;
end;

procedure TBrCustOrdForm.SetCustNo(NewCustNo: Double);
begin
  MastData.CustMasterSrc.Dataset := MastData.Cust;
  MastData.Cust.Locate('CustNo', NewCustNo, []);
end;

function TBrCustOrdForm.GetOrderNo: Double;
begin
  Result := MastData.OrdByCustOrderNo.Value;
end;

procedure TBrCustOrdForm.SetOrderNo(NewOrderNo: Double);
begin
  MastData.OrdByCust.Locate('OrderNo', NewOrderNo, []);
end;

procedure TBrCustOrdForm.SetActiveSource(DataSource: TDataSource);
begin
  FActiveSource := DataSource;
  Navigator.DataSource := FActiveSource;
end;

procedure TBrCustOrdForm.CustGridEnter(Sender: TObject);
begin
  ActiveSource := MastData.CustMasterSrc;
  CustGrid.Options := CustGrid.Options + [dgAlwaysShowSelection];
  OrdersGrid.Options := OrdersGrid.Options - [dgAlwaysShowSelection];
end;

procedure TBrCustOrdForm.OrdersGridEnter(Sender: TObject);
begin
  ActiveSource := MastData.OrdByCustSrc;
  OrdersGrid.Options := OrdersGrid.Options + [dgAlwaysShowSelection];
  CustGrid.Options := CustGrid.Options - [dgAlwaysShowSelection];
end;

procedure TBrCustOrdForm.ActivateQuery(Sender: TObject);
begin
  if not ActivateBtn.Down then begin
    MastData.CustMasterSrc.Dataset := MastData.Cust;
    CustGrid.SetSortedOrder(0, gsAsc);
    CustGrid.SetSortedOrder(1, gsAsc);    
  end else
    try
      MastData.CustQuery.Close;
      MastData.CustQuery.Open;
      MastData.CustMasterSrc.Dataset := MastData.CustQuery;
    except
      MastData.CustMasterSrc.Dataset := MastData.Cust;
      ActivateBtn.Down := false;
    end;
end;

procedure TBrCustOrdForm.EditBtnClick(Sender: TObject);
var
  F: TFloatField;
begin
  F := ActiveSource.Dataset.Fields[0] as TFloatField;
  if ActiveSource = MastData.CustMasterSrc then
    EdCustForm.Edit(F.Value)
  else
  begin
    EdOrderForm.Edit(F.Value);
    ActiveSource.Dataset.Refresh;
  end;
end;

procedure TBrCustOrdForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TBrCustOrdForm.FormShow(Sender: TObject);
begin
  MastData.Cust.Open;
  MastData.Cust.First;
end;

end.
