import sun.net.*;
import sun.net.ftp.*;
import java.io.*;

/*
Uses the undocumented sun.* classes to send a file to an ftp host
*/
class SendFileByftpSun extends FtpClient
{
String HostName = "";
String UserName = "";
String Password = "";
String HostDirectory = "";
String HostFileName;
File 	FileToPut;

/*---------------------------------------------------------------
---------------------------------------------------------------*/
SendFileByftpSun( String FToSend, String HName, String UName, String PWord, 
									String HDirectory, String HFName )
	{
   /* Split filespec into directory and file */
   FileToPut = new File( FToSend );

	if( !FileToPut.exists() || !FileToPut.canRead() || !FileToPut.isFile() )
 		{
      System.err.println( "Can't open file for reading " + FileToPut );
      System.exit(-1);
     	}
   /*
   int EndOfDir = FToSend.lastIndexOf( File. separatorChar );
   if( EndOfDir < 0 )
      {
	   FileToPutDirectory = "";
		FileToPutName = FToSend;
    	}
	else
 		{
      if( EndOfDir < FToSend.length()-1 )
      	{
	      FileToPutDirectory = FToSend.substring( 0, EndOfDir );
			FileToPutName = FToSend.substring( EndOfDir+1 );
   		}
     else
        	{
         System.err.println( "Source file is a directory" );
         return;
         }
      System.out.println( "Source directory = " + FileToPutDirectory );
      System.out.println( "Source file = " + FileToPutName );
      }
   */

   HostName = HName;
   UserName = UName;
   Password = PWord;
   HostDirectory = HDirectory;
   if( HFName != null && HFName.length() != 0 )
   	{
      HostFileName = HFName;
      }
   else
      {	/* Destination file name not specified, use source file name */
	   HostFileName = FileToPut.getName();	
    	}

   System.out.print( "Opening host..." );
   try
      {
      openServer( HostName );
      }
   catch( IOException e )
      {
		System.out.println( "Error: Unable to open host: " + HostName );
  		return;
      }
	System.out.println( "Ok: " + HostName );

 	/* login */
//	System.out.println( "Logging into server..." );
   try
      {
      login( UserName, Password );
      }
   catch( IOException e )
      {
		System.out.println( "Error: Unable to login " );
  		return;
      }

   try
      {
		binary();
  		}
   catch( IOException e )
      {
      System.out.println( "Unable to set binary transfer mode" );
      }

	if( HostDirectory != null && HostDirectory.length() > 0 )
 		{
     	/* Change host directory */

//		System.out.println( "Changing directory on host..." );
 	  try
	      {
	      cd( HostDirectory );
	      }
	   catch( IOException e )
	      {
			System.out.println( "Error: Unable to change to remote directory: "  + HostDirectory );
 	 		return;
     		}
      }

/* not needed, file overwrites anyway
	System.out.println( "Deleting remote file..." );
   try
      {
		issueCommand( "DELE " + HostFileName );
      }
   catch( IOException e )
      {
		System.out.println( "Error: Unable to delete remote file: "  + HostFileName );
      }
*/

	/* PUT file */
	System.out.println( "Sending file to host..." );
   try
      {
		TelnetOutputStream out = put( HostFileName );
  		FileInputStream fin= new FileInputStream( FileToPut.getPath() );
		int chr;
		
		/* This could probably be speeded up (currently does a char by char copy) */
  		for( long size = fin.available(); size>0; size-- )
			{
	      chr = fin.read();
      	out.write( (char)chr );	
       	out.flush();
         }
      fin.close();
      out.close();
      }
   catch( IOException e )
      {
		System.out.println( "Error: " + e );
		System.out.println( "Error: Unable to 'put' file onto host " );
      }
	System.out.println( "Closing FTP session" );
	/* Terminate session */
 	try
  		{
	 	closeServer();	
   	}
   catch( IOException e )
      {
		System.out.println( "Error: Unable to close host: " + HostName );
  		return;
      }
   }

/*---------------------------------------------------------------
Test main for 'SendFileByftpSun'.

Uploads a file using FTP, probably extremely useful by itself ;)
---------------------------------------------------------------*/
public static void main( String args[] )
   {
   String HFName = null;
   String HDir = null;

	if( args.length < 4 )
 		{
      System.out.println();
      System.out.println( "Too few parameters" );
      System.out.println();
      System.out.println( "Usage: " );
      System.out.println( "   src_filespec ftphostname username password [remotedirspec] [remotefilename] " );
      System.out.println();
      System.exit(-1);
     	}

	if( args.length > 4 )
 		{                   	/* Optional parameters */
      HDir = args[4];
     	if( args.length > 5 )
	 		{
 	     	HFName = args[5];
  		   }
      }

	SendFileByftpSun trans = new SendFileByftpSun( args[0], args[1], args[2], args[3], HDir, HFName );
   }
}


