/* This is the STATUS demo of SRE-FILTER's server side proceessing

Use STATUS.HTM to invoke this routine.
*/

status:
parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir

if verb=" " then do
   say "This SRE-Filter procedure is not meant to be run in standalone mode "
   exit
end  /* Do */

list=translate(list, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */


/* special request: initialize dircache */
if pos('INIT_DIRCACHE=1',upper(list)) then do
  if wordpos('SUPERUSER',upper(privset))=0 then do
      'header add WWW-Authenticate: Basic Realm=<!DIR Cache>'  /* challenge */
       return sref_response('unauth', "You do not have !DIR cache deletion rights ",tempfile,servername)
  end  /* Do */
 

  call init_dircache
 'FILE ERASE TYPE text/html NAME' tempfile
 return 'Done with STATUS (initialize !dir cache)'

end  /* Do */


 



/* Information will be returned in a temporary file, whose name
is provided in the tempfile variable.
Note that it's a good idea to start your HTML documents with a dtd doctype statement
 */
        call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'

        call lineout tempfile, "<html><head><title>Results from STATUS request</title>"
        call lineout tempfile, "</head><body>"
        call lineout tempfile,' <h2>Results from  Status Request </h2>'

        call lineout tempfile,' <h3>The arguments recieved by STATUS </h3> '

        call lineout tempfile,' <dl> '

        call lineout tempfile,' <dt>  DDIR = <code>' ddir '</code> '
        call lineout tempfile,' <dd>  The "data directory" (where your HTML documents should be) '
        call lineout tempfile,' <dt>  TEMPFILE = <code>' tempfile ' </code> '
        call lineout tempfile,' <dd> The "temporary file" (used to build this response)'

        call lineout tempfile,' <dt>  ACTION = <code>' reqstrg ' </code> '
        call lineout tempfile,' <dd>  The  <b>action</b> portion of the request selector'


        call lineout tempfile,' <dt>  LIST = <code>' list ' </code> '
        call lineout tempfile,' <dd> The <b>parameters</b>: '
        call lineout tempfile, '<br> ... if POST method, from the "body" of the request '
        call lineout tempfile,' <br> ... if GET method ,  from after the "?" in the request selector.  '

        call lineout tempfile,' <dt>  VERB = <code>' VERB ' </code> '
        call lineout tempfile,' <dd>  The HTTP method '

        call lineout tempfile,' <dt>  URI = <code>' URI ' </code> '
        call lineout tempfile,' <dd> The full <b>request string</b> '

        call lineout tempfile,' <dt> USER = <code>' user ' </code> '
        call lineout tempfile,' <dd> USERS ip addrees '

        call lineout tempfile,' <dt>  BASEDIR = <code>' basedir ' </code> '
        call lineout tempfile,' <dd> The "working directory" (where SRE-FILTER and GoServe live) '

        call lineout tempfile,' <dt>  WORKDIR = <code>' workdir ' </code> '
        call lineout tempfile,' <dd>  Temporary working files area (for <em>user-supplied </em> programs ) '

        call lineout tempfile,' <Dt> Your privileges are: '
        call lineout tempfile,' <DD> <code> ' privset ' </code> '
 
        call lineout tempfile,' <Dt> The host nickname '
        call lineout tempfile,' <DD> <code> ' host_nickname ' </code> '

        call lineout tempfile, '<dt> The ~ (home directory) string '
        call lineout tempfile,' <Dd> <code> ' homedir  ' </code>'

         call lineout tempfile,'</dl>'


/* Read the "header" -- and display the results */
       'READ HEADER VAR FOO '
         call lineout tempfile,' <h3> The Request Header </h3> '

        call lineout tempfile,' <dd> <blockquote> <pre>' foo  '</pre> </blockquote>'

        call lineout tempfile,' <h3> Some User &amp; Server Info </h3> '


/* This section demonstrates the use of some GOSERVE functions */
   cname=clientname()
   caddr=extract('CLIENTADDR')
   ssoft=server()
   sname=servername
   saddr=extract('SERVERADDR')
   sport=extract('SERVERPORT')

   call lineout tempfile,' <ul> '
   call lineout tempfile,' <li> Client ip address:  <code>' caddr '</code>'
   call lineout tempfile,' <li> Client name:  <code>' cname '</code>'
   call lineout tempfile,' <li> Server ip address: <code>' saddr '</code>'
   call lineout tempfile,' <li> Server port:  <code>' sport '</code>'

   call lineout tempfile,' <li> Server name:  <code>' sname '</code>'
   call lineout tempfile, ' <li> Server software:  <code>' ssoft '</code>'
  aver=sref_version()
   call lineout tempfile,' <li>  Filter version: <code> ' aver ' </code>'
   call lineout tempfile,' <li> Your privileges are: <tt> ' privset ' </tt>'
   call lineout tempfile,' </ul> '

/* superusers and inhouse users get to see sre-filter's parameters,
if desired (by pressing a link to configure */

  if wordpos('SUPERUSER',privset)=0 then signal getuse
  call lineout tempfile,' <h3> SRE-FILTER settings </h3> '
  call lineout tempfile,' <br>   Do you want to see the  <A href='
  call lineout tempfile,' "/config2?todo=show">current settings of SRE-FILTER'"'s parameters</A>? <br>"


getuse: nop
/* get some "intensity of use " statistics */
 reptime=extract('RESPONSETIME')
 numtrans=extract('TRANSACTIONS')
 whenstart=extract('LASTSTART')
 nclients=extract('CLIENTS')

   call lineout tempfile,' <h3> Use Statistics </h3> '
   call lineout tempfile,' GoServe started: ' whenstart

   call lineout tempfile,'<BR> # of transactions ' numtrans  ', avg. reponsetime = 'reptime ' sec. '

   call lineout tempfile,'<BR> Current # of clients = ' nclients


/* review cache etnries */
foo=strip(get_value('tempdata_dir'),'t','\')
call lineout tempfile,'<h3> Cache status (in ' foo ') </h3> '
dshs=foo||'\_*.DSH'
oo=sysfiletree(dshs,fred,'FO')
call lineout tempfile,' # of files in the <EM>!DIR cache </EM>= ' fred.0
aport=extract('serverport')
cshs=foo||'\_*.'||aport
oo=sysfiletree(cshs,fred,'FO')
call lineout tempfile,'<br> # of files in the <EM>SSI-Cache files </EM> = ' fred.0 '<br>'


/* Use the HOST function -- demonstrates the use of external calls */
 
/* but first "parse" the parameter list, and store in a simple stem variable */
  m=0
  do until list=""
    parse var list opt1 '&' list
    m=m+1
    parse var opt1 optname.m '=' optvalue.m
  end
  optname.0=m

/* see if one of the opts is "getip" */
   chkip=0 ;
   do mm=1 to optname.0
      if translate(optname.mm)='GETIP' then do
         chkip=optvalue.mm
         leave
      end
  end

/* if we found a GETIP, and got it's value, then lookit up */
  if chkip<>0 & chkip<>"" then do
/* Note use of the address cmd xxx to call a OS/2 level command  */
    A=RXQUEUE('S','SESSION')    /* SINCE QUEUE MIGHT BE A THREAD'S QUEUE */
    do queued(); pull .; end                   /* flush */
    address cmd '@host' chkip '| rxqueue'     /* execute the command */
    parse pull hostresult                      /* get result */

    call lineout tempfile,' <h3> Look up address </h3> '

    call lineout tempfile,' <pre> ' hostresult ' </pre>'
  end




/* all done, write final end-of-html elements */
  call lineout tempfile,'<body> </html>'
  call lineout tempfile

     'FILE ERASE TYPE text/html NAME' tempfile
  return 'Done with STATUS'

/* ----------- */
/* get environment value. Typically, look for host-specific
value first, and then look for generic value (if no host given,
skip host-specific lookup )
vname: variable to lookup
hname0: Special instructions:
  hname0=0 -- do not look under host nickname
  hname0=1 -- do not look under default
 */
/* ------------ */
get_value: procedure expose enmadd host_nickname
parse upper arg vname,hname0
if hname0=0 then
        hname=' '
else
    hname=strip(host_nickname)

vname=strip(vname) ;
if hname<>' ' then do
   booger=strip(enmadd||vname||'.'||hname)
   aval=value(booger,,'os2environment')
   if aval<>' ' | hname0=1 Then
        return aval
end
aval=value(enmadd||vname,,'os2environment')
return aval


/* *********** */
/* initialize dir cache */
init_dircache:
  call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
  call lineout tempfile, "<html><head><title>Initialize !DIR Cache</title>"
  call lineout tempfile, "</head><body>"
  call lineout tempfile,' <h2>Initialize !DIR Cache</h2>'
  foo=strip(get_value('tempdata_dir'),'t','\')
  dshs=foo||'\_*.DSH'
  oo=sysfiletree(dshs,fred,'FO')
  do mm=1 to fred.0
     foo2=sysfiledelete(fred.mm)
  end /* do */
  iid=foo||'\_DIRLIST.IDX'
  foo=sysfiledelete(iid)
  call lineout tempfile,  ' # of files <b>deleted</b> from the <EM>!DIR cache </EM> = ' fred.0
/* all done, write final end-of-html elements */
  call lineout tempfile,'<body> </html>'
  call lineout tempfile

  'FILE ERASE TYPE text/html NAME' tempfile
  return 0

