/*SRE_Filter monitor routine (run as a non-transient thread in same process
as goserve */

/* ---------- DO NOT CHANGE BELOW HERE  ----------------*/

if \RxFuncQuery("SockLoadFuncs") then nop
else do
       call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
       call SockLoadFuncs
end
foo=rxfuncquery('UZLoadFuncs')   /* load UNZIP dll */
if foo=1 then do
  call RxFuncAdd 'UZLoadFuncs', 'UNZIPAPI', 'UZLoadFuncs'
  call UZLoadFuncs
end

foo=rxfuncquery('UZLoadFuncs')   /* load UNZIP dll */
if foo=1  then call pmprintf(' Warning: UNZIPAPI.DLL not found ')

parse arg goserve_pid, thesem,servdir,SERVERPORT,envadd,max_semwait,moreargs
if servdir=" " then do
   say " This SRE-Filter daemon is NOT meant to be invoked from an OS/2 prompt!"
  exit
end  /* Do */


signal on error name yipes ; signal on syntax name yipes ;


parse var moreargs loadthreshold ',' backupserverlist ','  ,
     delay_seconds ',' message_scramble ',' record_cache_lines ',' logon_limit ',' ssi_extensions ',' ,
     ssi_cache_size ',' ssi_cache_duration ',' ssi_cache_stamp ',' save_state ',' no_no_record
loadthreshold=strip(loadthreshold) ; backupserverlist=strip(backupserverlist)
delay_seconds=strip(delay_seconds) ; message_scramble=strip(message_scramble)
record_cache_lines=strip(record_cache_lines)
logon_limit=strip(logon_limit)
ssi_extensions=strip(ssi_extensions)
ssi_cache_size=strip(ssi_cache_size)
ssi_cache_duration=strip(ssi_cache_duration)
ssi_cache_stamp=upper(strip(ssi_cache_stamp))
save_state=strip(save_state)
no_no_record=strip(no_no_record)

if datatype(logon_limit)<>'NUM' then logon_limit=0
if datatype(delay_seconds)<>'NUM' then delay_Seconds=9
if datatype(message_scramble)<>'NUM' then message_scramble=12415

/*if goserve_pid=" " | goserve_pid="?" | envadd="" then do
   say " This is used by SRE-Filter to manage ancillary threads. "
   say " It is not meant to be run as a standalone program! "
   exit
end
*/

if max_semwait="" then max_semwait=3000
CALL  load_rxl(0)  /* load macrospace library */
IF result<0  then    do       /* fatal error if not found */
  call pmprintf(' SRE-Filter monitor: ERROR: could not load macrospace library ')
  EXIT
end

doo=dostid()
oo=dospid()||' '||dostid()

activecache.0=0

numeric digits 11

call pmprintf(" SRE-Filter Monitor: Initializing on port "|| serverport || ": " || filter_name)
call pmprintf(" SRE-Filter monitor: Goserve pid ="|| goserve_pid' , monitor thread '||doo)
call pmprintf(" SRE-Filter monitor: Using semaphore "|| thesem)
parse upper version rexxtype .
call pmprintf("SRE-Filter monitor: Using REXX version: " rexxtype)

if record_cache_lines>0 then
   call pmprintf(" SRE-Filter monitor: Record cache file size= "||record_cache_lines)

init_file=servdir||"\INITFILT."||serverport
filedate.initfilt=file_juldate(init_file)
call get_initfilt(0)

call clear_temp(0)


if result<0  then do
  call pmprintf(" SRE-Filter fatal error : No INITFILT file ")
  exit
end

filedate.repstrgs=file_juldate(repstrgs_file)
repsvars.0=0

call chk_repstrgs(0)

filedate.access=file_juldate(access_file)
aa=start_access(0)
filedate.alias=file_juldate(alias_file)
aa=start_alias(0)
filedate.user=file_juldate(user_file)
aa=start_user(0)
filedate.virtual=file_juldate(virtual_file)
aa=start_virtual(0)
aa=start_ssicache(0)

aa=start_postf(0)
aa=eventsem_create(thesem)
if aa<0 then do
 call pmprintf(" SRE-Filter monitor: ERROR: could not create semaphore: "||thesem)
 exit
end
foo=eventsem_post(thesem)       /* let the boys have it */

call pmprintf(' SRE-Filter Monitor: Begin monitoring parameters files ..... ')
nloops=0
geelist="INITFILT REPSTRGS ALIAS ACCESS USER VIRTUAL "
do forever
  nloops=nloops+1

   CALL load_rxl(1)
   IF result<0 then do
      call pmprintf(' leaving after rxl error')
      leave
   end

/* get dates of current files  -- 0 if doesnt exist */
   t1.initfilt=file_juldate(init_file)
   t1.repstrgs=file_juldate(repstrgs_file)
   t1.alias=file_juldate(alias_file)
   t1.access=file_juldate(access_file)
   t1.user=file_juldate(user_file)
   t1.virtual=file_juldate(virtual_file)

/* any of them newer then last stored files */
   redo=0
   do mm=1 to words(geelist)
       oo1=word(geelist,mm)
       if t1.oo1 > filedate.oo1 then do
           redo=1
           filedate.oo1=t1.oo1
        end
   end

   if nloops>150 then do         /* every 30 minutes, reset it */
        nloops=1                  /* just to be safe! */
        redo=1
   end
   foo=value('SREF_REDO',,'os2environment')
   if foo=1 then redo=1
   foo=value('SREF_REDO',0,'os2environment')  /* reset to 0*/

/* one of three ways of being a redo? then reset */
   if redo=1 then do            /* reset all stuff */

      call pmprintf(" SRE-Filter resetting variables ")


      call get_initfilt(filedate.initfilt)
      if result<0 then do
          call pmprintf(' leaving after initfilt error ')
          leave
      end
      call start_access(1)
      call start_alias(1)
      call start_user(1)

      call start_virtual(1)
      call chk_repstrgs(0)


/* store dates of just reset files (initfilt may have changed names */
     filedate.access=file_juldate(access_file)
     filedate.alias=file_juldate(alias_file)
     filedate.user=file_juldate(user_file)
     filedate.virtual=file_juldate(virtual_file)
     filedate.repstrgs=file_juldate(repstrgs_file)
     filedate.initfilt=file_juldate(init_file)
     CALL PMPRINTF(' SRE-Filter Monitor: Success resetting parameters ')
    end

/* always check up on cached files (note that they may have
changed if initfilt was updated */

    n=delay(delay_seconds)

/* get current env variables, perhaps write to pmprintf */
   if display_env=1 then do
        a=rxqueue('s','session')
       call pmprintf(" Current SREF environment variables -----  ")
        do queued(); pull .; end                   /* flush */
        address cmd '@set | rxqueue'     /* execute the command */
        do queued()
           parse pull ares
           iii=min(100,length(ares))
           if abbrev(upper(ares),'SREF_')=1 then
             call pmprintf(left(ares,iii))
        end
       call pmprintf(' --- end of sref environment variables ')
       display_env=0
   end

end  /* forever loop */


exit

yipes:
call pmprintf(" error at " sigl )
exit 'Error in SREFMON'

/* --------- END OF MAIN ---------------------------------------- */

/* ------------------------------------------------- */
/* Routine to check, and load if neccessary,  SREFILTR.RXL into macrospace */
/* ------------------------------------------------- */

load_rxl:
nosref0=1
signal on syntax name nosref
signal on error name nosref

filter_name=sref_version()   /* if not here, then skip to nosref */
nosref0=0
nosref:         /* if skipped here, then load .rxl */
signal off syntax ; signal off error


if nosref0=1  then do
   first_load=1

   parse upper version rexxtype .
   if rexxtype="OBJREXX" then do
        call pmprintf(" SRE-Filter monitor: Loading SREFPRCO.RXL into macrospace ")
        tt=servdir||'\SREFPRCO.RXL'
   end
   else do
       call pmprintf(" SRE-Filter monitor: Loading SREFPRC1.RXL into macrospace ")
       tt=servdir||'\SREFPRC1.RXL'
   end
   aa=macroload(tt)
   if aa=0 then do
      call pmprintf(" SRE-Filter Monitor: ERROR: "|| tt ||" not available! "|| aa)
      RETURN -1
   end
   filter_name=sref_version()
   CALL PMPRINTF(" SRE-Filter Monitor: Success on macrospace library load ")
end

RETURN 1

/* ------------------------------------------------- */
/* get date (fat and julian) of a file */
/* ------------------------------------------------- */

file_juldate:procedure


parse arg get_file , isquiet
if GET_file=" " then return 0

eek=sysfiletree(translate(get_file,'\','/'),'gosh','FT')
if gosh.0=0 then do  /* no file */
   return 0
end
parse var gosh.1  atime .
aa=sref_juldate('F',atime)
return aa

/* ------------------------------------------------- */
/* clear all $*.80 files out of tempdata_Dir */
/* ------------------------------------------------- */
clear_temp:

lookstar=tempdata_dir||'\$*.'||serverport
foo=sysfiletree(lookstar,stuff,'FO')
do mm=1 to stuff.0
   foo=sysfiledelete(stuff.mm)
end /* do */
if stuff.0>0 then
  call pmprintf('SRE-Filter monitor: Deleted ' stuff.0 ' old files from: 'tempdata_dir)
lookstar=tempdata_dir||'\_DIRLIST.IDX'
foo=sysfiledelete(lookstar)

lookstar=tempdata_dir||'\_*.DSH'         /* delete old directory cache files */
foo=sysfiletree(lookstar,stuff,'FO')
do mm=1 to stuff.0
   foo=sysfiledelete(stuff.mm)
end /* do */
if stuff.0>0 then
  call pmprintf('SRE-Filter monitor: Deleted ' stuff.0 ' old directory cache files from: 'tempdata_dir)

lookstar=tempdata_dir||'\_*.TMP'         /* delete old .TMP e files */
foo=sysfiletree(lookstar,stuff,'FO')
do mm=1 to stuff.0
   foo=sysfiledelete(stuff.mm)
end /* do */
if stuff.0>0 then
  call pmprintf('SRE-Filter monitor: Deleted ' stuff.0 ' _*.TMP files from: 'tempdata_dir)
lookstar=strip(tempdata_dir||'\_T*.'||serverport)         /* delete old .TMP e files */
foo=sysfiletree(lookstar,stuff,'FO')
do mm=1 to stuff.0
   foo=sysfiledelete(stuff.mm)
end /* do */
if stuff.0>0 then
  call pmprintf('SRE-Filter monitor: Deleted ' stuff.0 ' _T*.'serverport ' files from: 'tempdata_dir)





return 0



/* ------------------------------------------------- */
/* routine to load initfilt.nnn into macrospace
   return 0= no change , 1= change,return<0=error */
/* ------------------------------------------------- */
get_initfilt:

get_file=init_file
if get_file=" " then
       return 0
oy=stream(get_file,'c','query exists')
if oy=0 then do
   CALL PMPRINTF("SRE-Filter monitor: INITFILT file not found, "|| get_file)
   return -1
end

/* get list of possible host variables */
a=rxqueue('s','session')
do queued(); pull .; end                   /* flush */
nhs=0
address cmd '@set | rxqueue'     /* execute the command */
do queued()
  parse pull ares0
  if abbrev(upper(ares0),'SREF_')=1 then do
      parse upper var ares0 ares '=' .
      ibeam=lastpos('.',ares)
      if ibeam>0 then do
           cat3=substr(ares,ibeam+1)
           if datatype(cat3)<>'NUM' then do
              parse var ares . '_' . '_' ares1 '=' .
              interpret ares1||'=" " '
/*              call pmprintf(' reset: ' ares1)*/
           end          /* got a host entry */
      end  /* got a . ed entry */
   end     /* an sref entry */
end     /* queued */


call default_initfilt           /* default values */

ause=fileread(get_file,'filelines',,'E')
If (ause=0) then  do               /*no such file,*/
      CALL PMPRINTF("SRE-Filter monitor: INITFILT file unusable, "|| get_file)
      return -1
end

/*Allow for gratuitous coding calamity by clumsy users */

mm=0 ; nerrs=0

iat1: nop

/* exit here when entire file read. Before exiting, cleanup and save results */

if mm>=filelines.0 then do
   signal off syntax
   signal off error
   signal off failure
   if nerrs>0 then
        return  -nerrs               /* any error is fatal */
    call initfilt_checkup

    call save_envstuff

/* check on status of counter files (create if necessary ) */
   res1=sref_init_counter(counter_file, upload_log , record_all_file , record_option)
   parse var res1 counter_file  upload_log  record_all_file  record_option
   call value envadd||'COUNTER_FILE',counter_file,'os2environment'
   call value envadd||'UPLOAD_LOG',upload_log,'os2environment'
   call value envadd||'RECORD_OPTION',record_option,'os2environment'
   call value envadd||'RECORD_ALL_FILE',record_all_file,'os2environment'

   call value envadd||'SERVERPORT',serverport,'os2environment'

   call pmprintf(" SRE-Filter monitor: INITFILT file loaded, "||get_file)

   return 1
end

mm=mm+1
signal on syntax name foobar1
signal on error name foobar1
signal on  failure name foobar1
filelines.mm=fix_me(filelines.mm)  /* convert from foo.host.n to foo.n.host */
goo=strip(filelines.mm)
if goo="" | left(goo,1)=";" then
    signal iat1

/* convert PUBLIC_FILES to PUBLC_URLS */
if abbrev(upper(goo),'PUBLIC_FILES')=1 then
   goo='PUBLIC_URLS'||delstr(goo,1,12)

/* convert PUBLIC_URL. to PUBLC_URLS. */
if abbrev(upper(goo),'PUBLIC_URL.')=1 then
   goo='PUBLIC_URLS'||delstr(goo,1,10)

 ok=0
 if abbrev(upper(goo),'SERVDIR')=1 then do
     call pmprintf(' Warning: INITFILT not allowed to change SERVDIR variable ')
     nop /* don't let it be changed! */
 end
 else
    interpret goo

 ok=1
foobar1:
if ok=0 then do
   nerrs=nerrs+1
  call pmprintf(" SRE-Filter monitor: ERROR: in initfilt: "||goo)
end


signal iat1


/* ---------------------------------------------- */
/* Clean up parameters in initfilt */
/* ---------------------------------------------- */
initfilt_checkup:

checklog=STRIP(translate(checklog))
  t1=wordpos(checklog,'NO YES ALWAYS INHOUSE')
  if t1=0 then checklog='NO'

if auto_Name=0 then auto_name=" "
   auto_name=translate(auto_name)


/* include html for backward compataability */
check_alias=is_true(check_alias,'Y YES 1 HTM HTML ')

accept_range=is_true(accept_range,'Y YES 1')
no_include=is_true(no_include,'Y YES 1')
no_interpret_code=is_true(no_interpret_code,'Y YES 1')
no_processing=is_true(no_processing,'Y YES 1')
use_stdout=is_true(use_stdout,'Y YES 1')
do_send_piece=is_true(do_send_piece,'Y YES 1')
add_user_name=is_true(add_user_name,'Y YES 1')
add_resource_name=is_true(add_resource_name,'Y YES 1')

check_add_privs=is_true(check_add_privs,'Y YES 1')

if logon_fail_file=' '  then logon_fail_file=0
if access_fail_file=' ' then access_fail_file=0

DEFAULT=STRIP(DEFAULT)
   if default=' ' then default='INDEX.HTM'

/* check for existnce of varouse directories */
mailbox_dir=translate(mailbox_dir,'\','/')
   mailbox_dir=strip(mailbox_dir,'t','\')
if dosisdir(mailbox_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find mailbox_dir: 'mailbox_dir)
     mailbox_dir=""
end  /* Do */

messbox_dir=translate(messbox_dir,'\','/')
   messbox_dir=strip(messbox_dir,'t','\')
if dosisdir(messbox_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find messbox_dir: 'messbox_dir)
     messbox_dir=""
end  /* Do */

config_dir=translate(config_dir,'\','/')
   config_dir=strip(config_dir,'t','\')
if dosisdir(config_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find config_dir: 'config_dir)
     config_dir=datadir()
end  /* Do */


workdata_dir=translate(workdata_dir,'\','/')
   workdata_dir=strip(workdata_dir,'t','\')
if dosisdir(workdata_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find workdata_dir: 'workdata_dir)
     workdata_dir=servdir
end

tempdata_dir=translate(tempdata_dir,'\','/')
   tempdata_dir=strip(tempdata_dir,'t','\')
if dosisdir(tempdata_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find tempdata_dir: 'tempdata_dir)
     tempdata_dir=datadir()

end

tempfile_dir=translate(tempfile_dir,'\','/')
   tempfile_dir=strip(tempfile_dir,'t','\')
if dosisdir(tempfile_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find tempfile_dir: 'tempfile_dir)
     tempfile_dir=servdir
end

cgi_bin_dir=translate(cgi_bin_dir,'\','/')
   cgi_bin_dir=strip(cgi_bin_dir,'t','\')
   if cgi_bin_dir="" then cgi_bin_dir=0
if dosisdir(cgi_bin_dir)=0 then do
     call pmprintf(' SRE-Filter monitor: Warning, could not find cgi-bin-dir: 'cgi_bin_dir)
     cgi_bin_dir=' '
end  /* Do */


/* chek other stuff */

HOME_DIR=STRIP(HOME_DIR)
inhouse_privs=translate(inhouse_privs)
   if inhouse_privs=0 then inhouse_privs=" "
public_privs=translate(public_privs)
   if public_privs=0 then public_privs=" "

virtual_file=strip(virtual_file)

ALLOW_ACCESS=TRANSLATE(STRIP(ALLOW_ACCESS))
if allow_access="Y" | allow_access=1 then allow_access="YES"

do_Htaccess=is_true(do_htaccess,'Y YES 1')


ssi_cache_on=is_true(ssi_cache_on,'Y YES 1 ')

ssi_shtml_only=is_true(ssi_shtml_only,'Y YES 1')
DNS_CHECK=translate(dns_check)
if upload_log="" then upload_log=0
if datatype(upload_maxsize)<>'NUM' then
    upload_maxsize=50
if datatype(upload_minfree)<>'NUM' then
    upload_minfree=20000

if datatype(ssi_cache_size)<>'NUM' then
   ssi_cache_size=5000

if datatype(ssi_cache_duration)<>'NUM' then ssi_cache_duration=1
if ssi_cache_duration=0 then ssi_cache_duration=1000000 /* infiinte*/

if wordpos(ssi_cache_stamp,'TIME DATE TIMEDATE DATETIME SIZE ALL')=0 then
   ssi_cache_stamp='ALL'


pre_filter=translate(pre_filter)
post_filter=is_true(post_filter,'Y YES 1')

if smtp_gateway=" " then smtp_gateway=0

hit_owner_suppress=is_true(hit_owner_suppress,'Y YES 1')
write_logs=is_true(write_logs,'Y YES 1')

if upper(hit_cache_len)="FILE" then do
   nop
end  /* Do */

else do
  if datatype(hit_cache_len)<>'NUM' then do 
     hit_cache_len=0
  end
  else do
    hit_cache_len=min(hit_cache_len,50)  /* 50 k max */
  end  /* Do */
end

if datatype(hit_cache_DURATION)<>'NUM' then do
     hit_cache_DURATION=15
END
ELSE DO
   HIT_cache_DURATION=MAX(1,HIT_cache_DURATION)
end  /* Do */


if the_realm=0 then do
  if  symbol('inhouse_name')<>"VAR"  then
        the_realm=inhouse_name
  else
       the_realm="OUR WEB SITE"           /* name we call "ourselves" */
end


RECORD_OPTION=TRANSLATE(RECORD_OPTION)
if wordpos(record_option,'YES YES_ALL FILE ')=0 then
     record_option="NO"              /* recording option on?*/

gots=0

hosts.0=0
do m=1 to 100000
   if symbol('hosts.m')<>"VAR" then leave
   if hosts.m=0 then leave
   hosts.0=m
end /* do */


ralphie=cvtails('DELIM_1',dlist)

delims=0
do m=1 to ralphie

   a1=dlist.m
   a2=translate(a1,' ','.')
   if words(a2)=1 then do
        if datatype(a1)='NUM' then do
           tmp1=DELIM_1.a1
           if tmp1='0' then iterate
           delims=max(delims,a1)
        end  /* Do */
    end  /* Do */
   if words(a2)=2 then do
        if datatype(word(a2,1))='NUM' then do
           ahost=word(a2,2)
           tmp1=DELIM_1.a1
           if tmp1='0' then iterate
           if symbol('DELIMS.'||ahost)='VAR' then
                delims.ahost=max(delims.ahost,word(a2,1))
           else
                delims.ahost=word(a2,1)
        end  /* Do */
    end  /* Do */
end



crlf='0d0a'x
FPO=MAKE_HEAD_FOOT()

/* creates HEADERS FOOTERS HEADERS. FOOTERS. HEADLIST. FOOTLIST. NHEADS NFOOTS */

auto_header=upper(auto_header)

/* check for "send in pieces "  --no fix_expire,  no 2nd delimiter
   NOW DONE IN SSI routine
if delims=1 &  fix_expire=0  & do_Send_piece=1 then
   send_piece=1
else
  send_piece=0
*/

suppress_alias=0 ; suppress_virtual=0 ; suppress_access=0
suppress_user=0 ; check_doq=0
if (alias_file=" " | alias_file=0)  then
        suppress_alias=1
if virtual_file=" " | virtual_file=0 then
        suppress_virtual=1
if (user_file=" " | user_file=0 ) then
        suppress_user=1
if access_file=" "| access_file=0  then
        suppress_access=1
/*say suppress_alias suppress_user suppress_access suppress_virtual*/

if (suppress_alias+suppress_user+suppress_access+suppress_virtual)>0 then
   check_doq=1

return 0


/* ------------------------------------------------- */
/* routine to set default initfilt.80  */
/* ------------------------------------------------- */
default_initfilt:

/* variables that can be changed by configure */

display_env=0
checklog='NO'           /* Free entry */
the_realm=0           /* name we call "ourselves" , 0 will be replaced generically*/
home_name=" "              /* The colloquial (not necessrily ip) domain name */
auto_header="NO"        /* no, always, head */
AUTO_NAME=0         /* 0=none, or a list with *.HTM, !CREATE, file.nam */
CHECK_alias="YES"   /* : YES=yes, NO=None, HTML=.HTM (or .HTML)  */
not_found_url='<a href="/"> Visit the home_name home page? </a> '   /* Message that is sent with no such url  */
pre_filter="NO"         /* no  yes first */
post_filter="NO"
noext_type="HTM"  /* NONE DIR HTM or HTML REDIR */
record_option="NO"   /* YES, YES_ALL */
allow_access="YES"  /* access control on file transfers (YES=none) */
default='index.htm'     /* use if default home page selected */
add_privs_prefix='!'
hosts.1=0               /* list of alternatme hosts */
inhouse_privs=" INHOUSE "    /* additional privs for inhouseips and owners */
public_privs=" PUBLIC "    /* additional privs for veryone */
inhouse.1=" (INHOUSE User) "   /* Used with REPLACE:INHOUSE1, etc. */
suPEruser.1="(Super User)"
headers.1=0  /* stuff to put at beginning / end of */
footers.1=0  /* all htm documents. 0= nothing */
OPTION_hit_line=":: still access # "
webmaster=' (no contact available) '
owners   = 'none'  /* Owners are automatically superusers (seperate with spaces) */
inhouse_privs="INHOUSE"
public_privs="PUBLIC"
smtp_gateway=" "    /* smtp_gateway, used by post-filter "e-mail alert" facility */

/* Directories and files */

cgi_bin_dir="\goserv\cgi-bin"                   /* if 0, do not emulate cgi-bin */

messbox_dir="\GOSERV\MESSAGE"                        /* SRE-Filter data */
maibox_dir="\GOSERV\MAIL"
upload_dir="\GOSERV\UPLOAD"
config_dir='\GOSERV\CONFIGS'
tempfile_dir="\gohttp\temp"
tempdata_dir="\goserv\temp"
home_dir="\gohttp\home"
workdata_dir="\GOSERV\DATA";

counter_file="\GOSERV\data\COUNTER.CNT"
record_all_file="\GOSERV\DATA\RECRDALL.CNT"
sendfile_file="\GOSERV\DATA\SENDFILE.CTL"

logon_fail_file=0
access_fail_file=0

htaccess_file=0
do_htaccess=0

access_file="\GOSERV\DATA\ALL_FILE.CTL"
accept_range="NO"
check_add_privs='NO'
use_stdout="YES"
add_user_name='YES'
add_resource_name='NO'
virtual_file="\GOSERV\data\VIRTUAL.IN"
user_file="\GOSERV\data\USERS.IN"
interpret_file="\GOSERV\data\INTERPET.IN"

repstrgs_file="\GOSERV\data\REPSTRGS.IN"
alias_file="\GOSERV\data\ALIASES.IN"
upload_log="\GOSERV\DATA\UPLOAD.LOG"

/* variables not changed by configure */
max_pointdist=50     /* max distance acceptable for a "assign to point" in ncsa map */
ssi_shtml_only='NO'    /* yes no, ssi on .sht or .shtml only */
ssi_cache_on='YES'    /* use ssi-caching (no, yes) */

fix_expire=0    /* set to non zero to redo response headers */
do_send_piece='NO' /* yes to allow "send in pieces",no to disallow */
no_include="NO"   /* yes no , disallow all ssi */
no_processing="NO"   /* if yes, then no server side processing allowed */
no_interpret_code='NO'
delim_1.1='<!--'     /* the left and right side "keyphrase" delimeters */
delim_2.1='-->'      /* can be any string combo */
upload_maxsize=50             /* max size that a uploaded file can be, in k */
upload_minfree=20000        /* minimum free in K, in dowload_dir, AFTER file upload */
postfilter_name="POSTFILT"
prefilter_name="PREFILTR"

interpret_types=' PL=PERL5 '  /* used by CGI-BIN to invoke alternate interpeters */

dir_exclusion='HTACCESS. /PRIVATE *.CNT '
DIR_OPTIONS='  notime auto_describe describe=describe.txt no_recurse_dir  '



check_doq=0
verbose=1

hit_cache_len=0        /* not on (otherwise, # of k) */
hit_cache_duration=15     /* # of minutes */
hit_cache=' '
hit_owner_suppress='YES'
write_logs='YES'


return 0


/* ----------------------------- */
/* save some initfilt varibles to the environment */
/* ----------------------------- */
save_envstuff:

ALIST='CHECKLOG AUTO_HEADER DO_SEND_PIECE VERBOSE DNS_CHECK ALLOW_ACCESS '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end


call value enVadd||'SUPPRESS_ALIAS',suppress_alias,'os2environment'
call value enVadd||'suppress_virtual',suppress_virtual,'os2environment'
call value enVadd||'suppress_access',suppress_access,'os2environment'
call value enVadd||'suppress_user',suppress_user,'os2environment'
call value enVadd||'CHECK_DOQ',CHECK_DOQ,'os2environment'
call value enVadd||'LOADTHRESHOLD',loadthreshold,'os2environment'
call value enVadd||'BACKUPSERVERLIST',backupserverlist,'os2environment'
call value enVadd||'SAVE_STATE',save_state,'os2environment'
call value enVadd||'NO_NO_RECORD',no_no_record,'os2environment'
call value enVadd||'MESSAGE_SCRAMBLE',MESSAGE_SCRAMBLE,'os2environment'
call value enVadd||'SSI_EXTENSIONS',ssi_extensions,'os2environment'


ALIST='AUTO_NAME DEFAULT CHECK_ALIAS NOEXT_TYPE ADD_PRIVS_PREFIX INTERPRET_TYPES DIR_OPTIONS DIR_EXCLUSION '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end

ALIST='PRE_FILTER PREFILTER_NAME POST_FILTER POSTFILTER_NAME  '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end

call value envadd||'HEADERS',headers,'os2environment'
call value envadd||'FOOTERS',footers,'os2environment'

do mm=1 to nheads
   foo=strip(headlist.mm)
   aval0=aheaders.foo
   tty=strip(envadd||'HEADERS.'||foo)
   call value tty,aval0,'os2environment'
end /* do */
do mm=1 to nfoots
   foo=strip(footlist.mm)
   aval0=afooters.foo
   call value envadd||'FOOTERS.'||foo,aval0,'os2environment'
end /* do */

alist='THE_REALM HOME_NAME NOT_FOUND_URL PUBLIC_PRIVS INHOUSE_PRIVS OPTION_HIT_LINE LOGON_FAIL_FILE ACCESS_FAIL_FILE'
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end

alist='WEBMASTER OWNERS SMTP_GATEWAY ACCEPT_RANGE USE_STDOUT ADD_USER_NAME ADD_RESOURCE_NAME '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end


call value envadd||'HOSTS.0',hosts.0,'os2environment'

ALIST='MAX_POINTDIST NO_INCLUDE NO_INTERPRET_CODE NO_PROCESSING FIX_EXPIRE SSI_SHTML_ONLY CHECK_ADD_PRIVS SSI_CACHE_ON '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end

ALIST='UPLOAD_MINFREE UPLOAD_MAXSIZE HOME_DIR HIT_CACHE_LEN HIT_CACHE_DURATION HIT_CACHE WRITE_LOGS HIT_OWNER_SUPPRESS SSI_CACHE_SIZE SSI_CACHE_DURATION SSI_CACHE_STAMP '
do mm=1 to words(alist)
  call save_em(word(alist,mm))
end

call value envadd||'cgi_bin_dir',cgi_bin_dir,'os2environment'

tempfile_dir=upper(strip(tempfile_dir))
call value envadd||'tempfile_dir',tempfile_dir,'os2environment'

tempdata_dir=upper(strip(tempdata_dir))
call value envadd||'tempdata_dir',tempdata_dir,'os2environment'

upload_dir=upper(strip(upload_dir))
call value envadd||'upload_dir',upload_dir,'os2environment'

messbox_dir=upper(strip(messbox_dir))
call value envadd||'messbox_dir',messbox_dir,'os2environment'

config_dir=upper(strip(config_dir))
call value envadd||'config_dir',config_dir,'os2environment'


workdata_dir=upper(strip(workdata_dir))
call value envadd||'workdata_dir',workdata_dir,'os2environment'


mailbox_dir=upper(strip(mailbox_dir))
call value envadd||'mailbox_dir',mailbox_dir,'os2environment'


call value envadd||'SERVDIR',servdir,'os2environment'

call value envadd||'INITFILT_FILE',INIT_file,'os2environment'
call value envadd||'USER_FILE',user_file,'os2environment'
call value envadd||'ACCESS_FILE',access_file,'os2environment'
call value envadd||'VIRTUAL_FILE',virtual_file,'os2environment'
call value envadd||'ALIAS_FILE',alias_file,'os2environment'
call value envadd||'REPSTRGS_FILE',repstrgs_file,'os2environment'

call value envadd||'INTERPRET_FILE',interpret_file,'os2environment'
call value envadd||'SENDFILE_FILE',sendfile_file,'os2environment'

call value envadd||'HTACCESS_FILE',htaccess_file,'os2environment'
call value envadd||'DO_HTACCESS',DO_htaccess,'os2environment'

/* determine # of public_urls (non host specific) -- used by srefquik.80 */
/* and while we are at it, fix 'em up */
aa='public_urls.'
nin=0
do mm=1 to 10000
      moe=aa||mm
      if upper(symbol(moe))<>"VAR" then leave
      interpret 'tt='||moe
      if tt="" | tt=0 then  leave
      nin=nin+1
end
public_urls.0=nin

/*call save_em('public_urls.')*/

/* IP_address,  host_nickname,  default_directory */
call pmprintf('SRE-Filter monitor: looking up '||hosts.0||' HOST IP addresses')
do m=1 to hosts.0
   aah=upper(hosts.m)
   aah=translate(aah,' ',',')
   parse upper var aah  sname  hn  adir
   SNAME=STRIP(SNAME)

   hn=upper(hn)
   adir=translate(strip(adir),'\','/'); adir=strip(adir,'t','\')||'\'

/* create ip number lookup table */
    isnumip=verify(SNAME,'1234567890.')
    if isnumip=0 then         /* is numeric ip */
           astat=sockgethostbyaddr(sname,'stuff.!')
    else
          astat=sockgethostbyname(sname,'stuff.!')

/* create HOST.n and HOSTS_IP.n :
   HOST.N will contain  ip_name , host_nickname, default dir
        where ip_name is the name supplied in the HOSTS. variable,
        OR, if a numeric ip address was supplied, the name associated
            with the numeric  ip address ( a socket call is made)
        BUT, if no name can be found for this IP address, the IP address
             is used
   HOSTS_IP  is a simple lookup table -- it's computed here to avoid
             lengthy socket calls.  The structure should be:
                numeric_ip_address ip_name
             If a name is give, the address is looked up,
             if a numeric address is given, the name is looked up
             If no address can be found for a name, the entry is left
             blank.  Similarly, it a name can not be found for a
            numeric address, the entry is left blank.
            In other words: both have to exist, else a blank entry is used.
*/

/* save basic name and ip */
    if astat=1  then do
           booz=stuff.!addr||' '||upper(stuff.!name)
           if isnumip=0 then
               name1=strip(upper(stuff.!name))
           else
                name1=strip(upper(sname))
    end
    else do
           booz=' '
           name1=sname
   end
   call value envadd||'HOSTS_IP.'||m,booz,'os2environment'
   aah=name1||','||hn||','||adir
   call value envadd||'HOSTS.'||m,aah,'os2environment'
end /* do  HOSTS */

call save_em('inhouseips.')
do m=1 to plist.0            /* fix and save INHOUSEIPS */
  t1=plist.m
  anval=inhouseips.t1
  w1=word(anval,1)   /* look for host nickname */
  if right(w1,2)='//' then do
       geti=2
  end
  else do
     geti=1
  end
  call value envadd||'inhouseips.'||t1,anval,'os2environment'
end

call save_em('unallowedips.')
do m=1 to plist.0            /* fix and save unallowedIPS */
  t1=plist.m
  anval=unallowedips.t1
  w1=word(anval,1)   /* look for host nickname */
  if right(w1,2)='//' then do
       geti=2
  end
  else do
     geti=1
  end
  if verify(word(anval,geti),'1234567890.')<>0 then do  /* convert numeric ip */
      astat=sockgethostbyname(word(anval,geti),'stuff.!')
      if astat=1 then do
           if geti=1 then do
              parse var anval vv anval
              anval=stuff.!addr||' '||anval
            end
            else do
               parse var anval vv1 vv2  anval
               anval=vv1||' '||stuff.!addr||' '||anval
            end  /* Do */
      end  /* Do */
  end
  call value envadd||'unallowedips.'||t1,anval,'os2environment'
end

do m=1 to delims
  if symbol('DELIM_1.'||m)<>'VAR' then iterate
  call value envadd||'DELIM_1.'||m,delim_1.m,'os2environment'
  if symbol('DELIM_2.'||m)<>'VAR' then iterate
  call value envadd||'DELIM_2.'||m,delim_2.m,'os2environment'
end
call value envadd||'DELIMS',delims,'os2environment'

ralphie=cvtails('DELIMS',dlist)
do mm=1 to ralphie
   booboo=dlist.mm
   call value envadd||'DELIMS.'||booboo,delims.booboo,'os2environment'
   do m=1 to delims.booboo
    if symbol('DELIM_1.'||m||'.'||booboo)<>'VAR' then iterate
     call value envadd||'DELIM_1.'||m||'.'||booboo,delim_1.m.booboo,'os2environment'
    if symbol('DELIM_2.'||m||'.'||booboo)<>'VAR' then iterate
     call value envadd||'DELIM_2.'||m||'.'||booboo,delim_2.m.booboo,'os2environment'
   end
end /* do */


/* fix up public_urls */
num_public_Urls=cvtails(PUBLIC_URLS,foo1)
if num_public_urls>0 then do    /* clean em up */
   do mm=1 to num_public_urls
      tl1=foo1.mm
      vl=public_urls.tl1
      if pos('?',vl)>1 then do
          parse var vl vla '?' vlb
          vla=strip(translate(vla,'/','\'))
          if length(vla)>0 then 
              if  abbrev(vla,'/')=1 then vla=substr(vla,2)
          v1=vla||'?'||vlb
      end
      else do
          vl=strip(translate(vl,'/','\'))
          if length(vl)>0 then 
              if  abbrev(vl,'/')=1 then vl=substr(vl,2)
      end  /* Do */
      public_urls.tl1=vl
   end /* do */
end  /* Do */
call save_em('public_urls.')

call save_em('NUM_PUBLIC_URLS')
call pmprintf(' #  of public urls = 'num_public_Urls)

CALL SAVE_EM('SUPERUSER')
CALL SAVE_EM('INHOUSE')

call pmprintf(' SRE-Filter monitor: number of hosts= 'hosts.0 )
return 0


/* ----------------------------------------------------------------------- */
/* --  copy repstrgs file to environment */
/* ----------------------------------------------------------------------- */

chk_repstrgs:
parse arg resetit

if repstrgs_file=" " then
  return 0
oy=stream(repstrgs_file,'c','query exists')
if oy="" then do
   CALL PMPRINTF("SRE-Filter monitor: Replacement strings file not found, "|| get_file)
   return -1
end

/* yep, reinitialize repstrgs file (set semaphore first */
ause=fileread(repstrgs_file,'filelines',,'E')
If (ause=0) then  do               /*no such file,*/
      CALL PMPRINTF("SRE-Filter monitor: Replacement strings file unusable, "|| repstrgs_file)
      return -1
end

crlf='0d0a'x
j=0
/* zap current list of repstrings variables */
do rr=1 to repsvars.0
  call value repsvars.rr,' ','os2environment'
end
repsvars.0=0
do mm=1 to filelines.0
  goo=strip(filelines.mm)
  if goo="" | left(goo,1)=";" then
       iterate

  parse var goo aname avalue
  aname=envadd||upper(aname)
  t1=value(aname,,'os2environment')
  if t1=' ' then do
      t1=avalue
      j=j+1
      repsvars.j=aname
      repsvars.0=j
  end
  else
        t1=t1||crlf||avalue

  call value aname,t1,'os2environment'
end
call pmprintf(' SRE-Filter Monitor: loaded replacements strings: 'j)
return j


/* ----------------------------------------------------------------------- */
/* -- See if a "generic" YES answer. If so, return 1 */
/* ----------------------------------------------------------------------- */
is_true:procedure
parse upper arg ans,anslist
if wordpos(ans,anslist)>0 then
 return 1
else
 return 0



/*=========     Start various threads   ===================== */


/* ------------------------------------------------------------ */
/* start access processor thread */
start_access:
parse arg resetit

if access_file= ' ' | SUPPRESS_ACCESS=1 then
      return 0
oy=stream(access_file,'c','query exists')
if oy="" then do
   CALL PMPRINTF("SRE-Filter monitor: access file not found, "|| access_file)
   access_file=' '
   return -1
end

arxx=servdir||'\acceschk.rxx'
usequeue='SREF_'||serverport||'_ACCESS'
usesem='\SEM32\SREF_'||serverport||'_ACCESS'

if resetit=1 then do            /* already opened --just send a *RESET* */
   a=rxqueue('s',usequeue)
   push '1, 1, 2, *RESET* ' access_file
   return 1
end

/* if here, first time */

a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf(' SRE-Filter monitor: Error creating access semaphore: 'A' 'usesem)
    access_file=' '
    return -1
end
access_tid=rexxthread('f',arxx,access_file,usequeue,USESEM,max_semwait)
if access_tid=0 then do
   call pmprintf(' SRE-Filter monitor: Could not open access thread 'arxx)
    access_file=' '
   return -1
end

return 1

/* ---------------- */
/* start alias processor thread */
start_alias:
parse arg resetit

if alias_file= ' ' | SUPPRESS_ALIAS=1 then
      return 0
oy=stream(alias_file,'c','query exists')

if oy="" then do
   CALL PMPRINTF("SRE-Filter monitor: alias file not found, "|| alias_file)
   alias_file=' '
   return -1
end

arxx=servdir||'\aliaschk.rxx'
usequeue='SREF_'||serverport||'_ALIAS'
usesem='\SEM32\SREF_'||serverport||'_ALIAS'

if resetit=1 then do            /* already opened --just send a *RESET* */
   a=rxqueue('s',usequeue)
   push '1,1,2,*RESET* ' alias_file
   foo=eventsem_post(usesem)
   return 1
end

/* if here, first time */

a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf(' SRE-Filter monitor: Error creating alias semaphore: 'A' 'usesem)
    return 0
end
alias_tid=rexxthread('f',arxx,alias_file,usequeue,USESEM,max_semwait)
if alias_tid=0 then do
   call pmprintf(' SRE-Filter monitor: Could not open alias thread 'arxx)
   return 0
end

return 1



/* ---------------- */
/* start virtual dir processor thread */
start_virtual:
parse arg resetit

IF VIRTUAL_FILE="" | SUPPRESS_VIRTUAL=1 then RETURN 0


dlistx=upload_dir||' '||cgi_bin_dir||'  '||servdir||' '
dlistx=dlistx||translate(datadir(),'\','/')


arxx=servdir||'\virtchk.rxx'
usequeue='SREF_'||serverport||'_VIRTUAL'
usesem='\SEM32\SREF_'||serverport||'_VIRTUAL'

if resetit=1 then do            /* already opened --just send a *RESET* */
   call pmprintf(' resetting virtual file 'virtual_file)
   a=rxqueue('s',usequeue)
   push '1,1,2, *RESET* ' virtual_file
   foo=eventsem_post(usesem)
   return 1
end

if virtual_file= ' ' then
      return 0
oy=stream(virtual_file,'c','query exists')
if oy="" then do
   CALL PMPRINTF("SRE-Filter monitor: virtual file not found, "|| virtual_file)
   virtual_file=' '
   return 0
end



/* if here, first time */

a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf(' SRE-Filter monitor:Error creating virtual semaphore: 'A' 'usesem)
    return 0
end
mm1=max_semwait
virtual_tid=rexxthread('f',arxx,virtual_file||' '||dlistx,usequeue,USESEM,mm1)
if virtual_tid=0 then do
   call pmprintf(' SRE-Filter monitor:Could not open virtual thread 'arxx)
   return 0
end

return 1





/* ---------------- */
/* start virtual dir processor thread */
start_ssicache:
if ssi_cache_size="" then return 0

arxx=servdir||'\ssicache.rxx'
usequeue='SREF_'||serverport||'_SSICACHE'
usesem='\SEM32\SREF_'||serverport||'_SSICACHE'


a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf(' SRE-Filter monitor:Error creating ssi-cache semaphore:'usesem)
    return 0
end
mm1=max_semwait
ssicache_tid=rexxthread('f',arxx,tempdata_dir,usequeue,USESEM,mm1,serverport,ssi_cache_size,ssi_cache_duration,ssi_cache_stamp)
if ssicache_tid=0 then do
   call pmprintf(' SRE-Filter monitor:Could not open ssi-cache thread 'arxx)
   return 0
end

return 1




/* ---------------- */
/* start user check processor thread */
start_user:
parse arg resetit
if user_file= ' ' | SUPPRESS_USER=1 then
      return 0

oy=stream(user_File,'c','query exists')
if oy="" then do
   CALL PMPRINTF("SRE-Filter monitor: userl file not found, "||user_file)
    user_file=' '
   return -1
end

arxx=servdir||'\userchk.rxx'
usequeue='SREF_'||serverport||'_USER'
usesem='\SEM32\SREF_'||serverport||'_USER'

if resetit=1 then do            /* already opened --just send a *RESET* */
   a=rxqueue('s',usequeue)
   push '1,1,2, *RESET* ' user_File
   foo=eventsem_post(usesem)
   return 1
end

/* if here, first time */
a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf(' SRE-Filter monitor:Error creating user semaphore: 'A' 'usesem)
    return 0
end
user_tid=rexxthread('f',arxx,user_file,usequeue,USESEM,max_semwait,logon_limit)
if user_tid=0 then do
   call pmprintf(' SRE-Filter monitor:Could not open user thread 'arxx)
   return 0
end


return 1


/* ---------------- */
/* start postfilter / recordall processor thread */
start_postf:
parse arg resetit

arxx=servdir||'\postfchk.rxx'
usequeue='SREF_'||serverport||'_postf'
usesem='\SEM32\SREF_'||serverport||'_postf'

a=rxqueue('d',usequeue)
a=rxqueue('c',usequeue)
if a<>usequeue then do
  bb=rxqueue('d','a')
  a=rxqueue('s',usequeue)
  do queued()
       pull
  end /* do */
end

a=eventsem_close(usesem)
A=EVENTSEM_CREATE(USESEM)
IF A<>0 then DO
    call pmprintf('SRE-Filter monitor: Error creating postfilter semaphore: 'A' 'usesem)
    return 0
end

mm1=max_semwait*1.5
postf_tid=rexxthread('f',arxx,usequeue,USESEM,mm1,record_cache_lines' 'workdata_dir)
if postf_tid=0 then do
   call pmprintf(' SRE-Filter monitor:Could not open postfilter thread 'arxx)
   return 0
end

return 1



/* ----  */
/* make headers and footers, host specific possibly */
make_head_foot:procedure expose aheaders. afooters. headlist. footlist. ,
        headers footers  nheads nfoots headers. footers.

foo=cvtails('headers.','b')
joe=arraysort('b')
crlf=' '
headers=' ' ; nheads=0 ; HDDONE=0
do mm=1 to b.0
    a1=b.mm
    a2=headers.a1
    if a2=" " then a2=0
    IF A2=0 then HDDONE=1
    if pos('.',a1)=0  then do
       if HDDONE=0 then  headers=headers||a2||crlf
    end  /* Do */
    else do             /* headers.hn */
       parse var a1 aval '.' ahost ; ahost=strip(ahost) ; aval=strip(aval)
       if strip(a2)=0 then do
             headstops.ahost=1
       end  /* Do */
       else do          /* not a stop */
         if aval=1 then  do
             nheads=nheads+1
              headlist.nheads=ahost
              aheaders.ahost=a2||crlf
             headstops.ahost=0
         end
         else do
           if headstops.ahost<>1 then
              aheaders.ahost=aheaders.ahost||a2||crlf
         end
       end              /* headstop */
    end                 /* .hn */
end
foo=cvtails('footers.','b')
joe=arraysort('b')
footers=' ' ; nfoots=0 ; FTDONE=0
do mm=1 to b.0
    a1=b.mm
    a2=footers.a1
    if a2=" " then a2=0
    IF A2=0 then FTDONE=1
    if pos('.',a1)=0  then do
       if FTDONE=0 then footers=footers||a2||crlf
    end  /* Do */
    else do             /* footers.hn */
       parse var a1 aval '.' ahost ; ahost=strip(ahost) ; aval=strip(aval)
       if strip(a2)=0 then do
             footstops.ahost=1
       end  /* Do */
       else do          /* not a stop */
         if aval=1 then  do
             nfoots=nfoots+1
              footlist.nfoots=ahost
              afooters.ahost=a2||crlf
             footstops.ahost=0
         end
         else do
           if footstops.ahost<>1 then
              afooters.ahost=afooters.ahost||a2||crlf
         end
       end              /* footstop */
    end                 /* .hn */
end

return 0


/*----------------------*/
save_em:
parse arg avar ;avar=strip(avar)

drop plist

avar0=strip(avar,'t','.')
avar=avar0||'.'
rr=cvtails(avar,'plist')
do r1=1 to rr
   atail=plist.r1
   interpret 't1='||avar||atail
   call value envadd||avar||atail,t1,'os2environment'
end

/* save the default (non hostname) version */
   if upper(symbol(avar0))="VAR" then do
      interpret 't1='||avar0
      call value envadd||avar0,t1,'os2environment'
   end

return 0


/* --- variable names of convert foo.bar.1 to foo.1.bar */
fix_me:procedure
parse arg a1

if a1=' '  then return a1
a1=strip(a1)
if abbrev(a1,';') then return a1

parse var a1  aname '=' avalue
if pos('.',aname)=0 then return a1

foo=translate(aname,' ','.')
if words(foo)<>3 then return a1

/* if here, array.x.y (3 elements) */
if datatype(word(foo,3))='NUM' & datatype(word(foo,2))<>'NUM' then do  /* rearrange */
   foo2=word(foo,1)||'.'||word(foo,3)||'.'||word(foo,2)||' = '||avalue
   return foo2
end  /* Do */
else do
   return a1
end  /* Do */





