/****************************************************************/
/* generic text file  search utility for SREFILTR package.  Designed to be used
as a directly requested file searcher, or as part of a "searchable index" process
(when used in conjunction with an SRE-Filter alias).


  ---- Invoking DOSEARCH ---

  When called directly, the "request string"    should have the form:
       DOSEARCH?option_1=val_1&option_2=val_2&etc.
   where the file to be searched, the search string, and other options are returned
   in the option_n list.
   In this case, list0=option_1=val_1&option_2=val_2&etc.
   Note that a FILE and a SEARCH option should always be present.

 --------  DOSEARCH options -----

DOSEARCH looks at "paragraphs".  By default, a paragraph is defined as being
all text between blank lines.  Alternatively, one can define paragraphs as single lines,
or as delimited by any arbitrary character sequence (see options section below).

A search string is comprised of "targets" There are two kinds of targets: subwords and phrases.
  Each space delimited entry in the search string is treated as a seperate "subwords".
  Phrases are delimited by ( xx yy zz ); phrases must be matched precisely.

Search algorithims.  There are two modes:
 Simple mode with highlighting.  Two "meta commands" and 4 "target specific"
 instructions are recognized.  
        Meta commands are signified by *& or *\ at the beginning of the search string.
             *&  means "find paragraphs that match ALL targets in the search string"
             *\  means "find paragraphs that match NONE of the targets in the search string"
     If there are no meta commands, the following "target specific" commands are recognized.
          &  means "paragraphs MUST have this target"
          |   means "accept paragraph if it has this target"
              Note that | is the default (assumed if no target specific command entered).
          \ means "paragraph must NOT have this target" 
          % means "accept paragraph if it does NOT have this target"

    Summarizing: to be a "found" paragraph:
      Test 1a) Any | must be present,    or
            1b)   All of the % are missing
            (if no % appears, then 1b is ignored)
      Test 2a) If pass test 1, then
            2b)   None of the \ can be present, and
               All of the & must be present
     If present, all & and | targets will be highlighted

 Logical expression mode without highlighting.
      The user enters a logical expression using the following operators:
          & = AND  ,  | = OR ,    \ = not ,   @ = xor , ( ) to group expressions.
      A sequence of words without any operators is treated as a phrase -- to
      treat each word as a seperate subword, put ( ) around each one.
      Basically, when using this mode, be liberal in your use of ( ).

Options (included in the ALIAS definition, or generated by a form):
       Options are included after the searchstring, seperated by &.  Typically,
they would be placed there by a form, not by an <ISINDEX> response.  Form of the
options is option_name=option_value&option_Nam2=option_value2&...

       DELIM :  The paragraph delimiter.
                   Blank or 0= blank lines   (the DEFAULT)
                   $  = Each line is a paragraph
                   other  = User specified delimiter
       LINE : Maximum number of lines to display in a paragraph. If 0, no lines displayed
              just summary.   Default is display all lines.
       NUM : YES=Display the line or paragraph number, NO=Don't (Default=YES)
       BAR:  YES= Seperate each paragraph/line by a horizontal bar, NO=Don't (Default=YES)
       EXPERT: YES= Use "logical expression mode", NO=Use simple mode (Default=NO)
      HIGHLIGHT: YES= Highlight mathes, NO=DON'T (only if non-expert mode)
       FILE or FILES:  Additional files to search (can include wildcards)
       SEARCH: Use this as the searchlist -- required for FORM based submittal,
                overrides default (first thing after the ? and before the first &) if
                a ISINDEX based submittal)
                Note: SEARCHFOR  STRING NEEDLE TARGET can be used instead of SEARCH
       CASE : If YES, then search is case sensitive (default is no)


Note: a FILE (or FILES) and a SEARCH option should always be present.

*/
/***********************************************************/



parse arg ddir,tempfile,sel,list00,verb,uri,user,basedir, ,
               workdir,privset,enmadd,transaction,verbose, ,
               SERVERNAME,HOST_NICKNAME,HOMEDIR

if verb="" then do
   say " This SRE-Filter procedure is not meant to be run in stand alone mode"
   exit
end  /* Do */



/**** no longer used:
ameth=upper(extract('clientmethod'))
if ameth="GET" then
   parse var uri foo '?' list0
else ***** */

list0=list00

list0=translate(list0, ' ', '+'||'090a0d'x)  /* Whitespace, etc. */

ddir=translate(ddir,'\','/')
ddir=strip(ddir,'t','\')||'\'

macrospace_input=strip(params0)

parse var uri index_htm '?' listuri
index_htm=translate(strip(index_htm,,'/'))

 options=" "
 gotss=0
 searchlist=" "
ifiles=0

 options=list0

para_delim=""
maxdisp=1000000
show_number=1
show_bar=1
expert_mode=0
check_case=0
highlight=1

/* get option */
do until options=""
  parse var options an1 '&' options
  parse var  an1 aname '=' avalue
  aname0=aname ; aname=translate(aname)
  avalue0=avalue ; 
/*  avalue=translate(avalue,' ','+'||'0d0a09'x) */
  avalue0=packur(avalue)
  avalue=translate(avalue0)
  avalue=translate(avalue,' ','"')
  avalue=translate(avalue,' ',"'")


  select
     when pos("DELIM",aname)> 0 then 
         para_delim=avalue0
  
     when pos("LINE",aname)> 0 then
         if datatype(avalue)="NUM" then
              maxdisp=avalue
     when pos("NUM",aname)>0 then
         if left(avalue,1)="N" | avalue=0 then  show_number=0
     when pos("BAR",aname)>0 then
         if left(avalue,1)="N" | avalue=0 then  show_bar=0
     when pos('EXPERT',aname)>0 then
             if left(avalue,1)="Y" | avalue=1 then   expert_mode=1
     when pos('HIGHLIGHT',aname)>0 then do
                if abbrev(avalue,'Y')=1 then highlight=1
                if abbrev(avalu,'N')=1 then highlight=0
     end
     when abbrev(aname,'FILE')=1 then do
             if avalue<>"" then do
                 ifiles=ifiles+1
                 files.ifiles=avalue
             end
     end


     when pos("CASE",aname)>0 then
         if left(avalue,1)="Y" | avalue=1 then  check_case=1

     when wordpos(aname,'SEARCH SEARCHFOR STRING NEEDLE TARGET')>0 then do
               searchlist=avalue0
      end
     otherwise
  end
end

/* note: default para_delim is "blank lines" */

searchlist=translate(searchlist,' ','+'||'000d0a09'x)
searchlist=packur(searchlist)                   /* do it now, to revitalize &'s */
if left(para_delim,1)='"' & right(para_delim,1)='"' then 
    para_delim=strip(para_delim,,'"')
if para_delim="" then para_delim=" "
if para_delim=0 then para_delim=" "
crlf = '0d0a'x


/* ----------------- Section to do a search   -------------- */

/* If here, we have some  stuff in the request string (after a ? )
   (either supplied explicitly, or  as a response to the searchable index created above */

 call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
 CALL LINEOUT TEMPFILE,'<html> <head> <title> Results of search </title>  </head>'
 call lineout tempfile,'<body>'


/* create list of files to search */
files_todo=0
do ido=1 to ifiles

      afilenam=sref_do_virtual(ddir,files.ido,enmadd,1,transaction,HOMEDIR,HOST_NICKNAME)
      if afilenam=0 then iterate               /* error */
      eek=sysfiletree(afilenam,'aflist','F')   /* check for */
      if eek<>0 then iterate            /* error */
      do ido1=1 to aflist.0             /* any matches */
         files_todo=files_todo+1
         file_list.files_todo=word(aflist.ido1,words(aflist.ido1)) /* grab name */
         file_list.files_todo.original=files.ido
      end
end
ith_file=0

if files_todo>0 then
   call lineout tempfile,' <h3> Number of files to search: ' files_todo '</h3> <hr>'

NEXTFILE:               /* JUMP HERE TO READ NEXT FILE  *****************    */

ith_file=ith_File+1
filename=strip(file_list.ith_file)
afilenam=filename
aoriginal=file_list.ith_file.original
goober=filespec('n',filename)

/* read in this target file (filename) into filelines stem variable */
filelines.0=0
getit=0


if filename<>"" then do                 /* check for no filename */
 select
   when para_delim=" " then do
        getit=fileread(afilenam,'filelines',,'e')
   end
   when para_delim="$" then do
        getit=fileread(afilenam,'filelines',,'e')
   end
  otherwise do
       getit=grab_file_lines(afilenam,20,para_delim)
  end
 end
 if VERBOSE>0 then say " DOSEARCH will examine:" afilenam "(# entries= " getit

end             /* filename<>"" */

/* problem ... */
if getit <= 0 then   do             /*fatal error */
    call lineout tempfile,'<h2> No search target </h2> '
    if VERBOSE>0 then say " No such file " filename
    call lineout tempfile,' <p> <strong> Can not find file: <strong> ' filename
    call lineout tempfile,'</body> </html>'
  call lineout tempfile

    return 'FILE  ERASE TYPE text/html NAME ' tempfile
end



/* look for meta flags (they over ride individual  flags*/
matchall=0 ; matchnone=0
if word(searchlist,1)='*&' then do
  matchall=1
  searchlist=delword(searchlist,1,1)
end
else if word(searchlist,1)="*\" then do
  matchnone=1
  searchlist=delword(searchlist,1,1)
end

if searchlist="" then do                /*missing searchlist */
  call lineout tempfile,'<h2> No search list </h2> '
   if VERBOSE>0 then say " No searchlist specified."
   call lineout tempfile,' <p> <strong> No search list specified  <strong> ' 
   call lineout tempfile,'</body> </html>'
  call lineout tempfile

   return 'FILE  ERASE TYPE text/html NAME ' tempfile
end


/* write some else, basic facts .. */
 call lineout tempfile,'<h2> Results of  search  </h2> '
 call lineout tempfile,' File searched: <strong> ' goober ' </strong> '
 if pos('*',aoriginal)>0 | pos('?',aoriginal)>0 then
        call lineout tempfile,' <em> ( ' aoriginal ' ) </em> '
 call lineout tempfile,' <br>Search pattern: <strong> ' searchlist ' </strong> '
 if matchall=1 then call lineout tempfile, '<em> (must match all) </em> '
 if matchnone=1 then call lineout tempfile, '<em> (must match none) </em> '

 call lineout tempfile,' <hr width= 75%>'

/* before extracting phrases, make sure & / ( and ) are spaced out */
searchlist=sref_replacestrg(searchlist,'&',' & ','ALL') ;
searchlist=sref_replacestrg(searchlist,'\',' \ ','ALL') ; 
searchlist=sref_replacestrg(searchlist,'(',' ( ','ALL') ;
searchlist=sref_replacestrg(searchlist,')',' ) ','ALL') ; 
searchlist=sref_replacestrg(searchlist,'|',' | ','ALL') ;

if expert_mode=0 then do                /* fairly search scheme */
    ith=get_searchfor(searchlist,check_case)   /* searchfor. and cond. are exposed */

    dispdetails=1          /* if a NOT or AND exists, set to 0 (since individual details are inaccurate*/
    /* If there are global conditins, overwrite any spurious local conditions */
    do mm=1 to searchfor.0
      select
        when matchall=1 then
           cond.mm='AND'
        when matchnone=1 then
           cond.mm='ORNOT'
        otherwise
      end
      if  cond.mm<>"OR" then dispdetails=0
    end
end
else  do            /* expert mode: user enters syntatically correct search command */
   searchlist=expert_parse(searchlist,'HAYSTACK',check_case)
end



change_crlf=0
select                  /* now, create "paragraphs" */
   when para_delim=" " then do   /* the default-- blank lines as delimiters */
      nthpara=build_paras()    /* filelines. and paras. are exposed */
      if VERBOSE>0 then say " # paragraphs " nthpara
    end
   /* filelines might be lines of the file, or "delimited" blocks
       Note that "user delimited" blocks retain CRLFs. */
    otherwise  do                  /* use each line, or  para_delim literally */
      do mm=1 to filelines.0
          paras.mm.first=mm
          paras.mm.last=mm
      end
      nthpara=filelines.0
      if para_delim<>'$' then change_crlf=1  /* change to <BR> below */
   end
  end

/* Now find 'paragraphs' containing the search patterns */

nmatch=0
if expert_mode=0 then
  do jj=1 to searchfor.0
     allmatch.jj=0
  end

do mm=1 to nthpara

   apara=""
   do mm2=paras.mm.first to paras.mm.last   /* create a paragraph */
      apara=apara||' '||filelines.mm2
   end

/* -------- see if this paragraph is a hit */


     if expert_mode=0 then
         gotems=match_para(apara,checK_case)  /* searchfor. cond. mlist. are exposed */
 
     else do
        haystack=apara
        if check_case<>1 then haystack=translate(haystack)
        signal on syntax name oyvey
        interpret 'gotems='||searchlist
        signal off syntax
     end

     if gotems=0 then do
       iterate       /* get next paragraph */
     end


/* if here, got a match. So write out the paragraph */
     nmatch=nmatch+1         /* summary counter */
     if maxdisp=0 then iterate

     if para_delim<>'$' then
         if show_number=1 then
            call lineout tempfile,'<h6 align=center>Paragraph #  '  mm ' </h6> '
         else
             call lineout tempfile,'<p>'    /* make space in output doc */

      else do
         call lineout tempfile,'<p>'    /* make space in output doc */
     end

     writlin=0
  
     do mm2=paras.mm.first to paras.mm.last  /* output original 'lines' */
                    aline=filelines.mm2         /* that comprise the paragraph */

          IF EXPERT_MODE=0 THEN
             do mm3=1 to searchfor.0    /* we know that pre is weren't present*/
               if mlist.mm3 =0 then iterate
               if HIGHLIGHT=1 then
                  aline=sref_make_block(searchfor.mm3,aline,'<b>','</b>',check_case) /* highlight matches */
            end         /* Note: expert mode does NOT have highlighting */

          if change_crlf=1 then                 /* convert crlf in custom delimited blocks */
              aline= sref_replacestrg(aline,crlf,'<BR>','ALL')
          if para_delim<>'$' then
             call lineout tempfile, aline ' <br>'
          else
             if show_number=1 then call lineout tempfile, '<cite> ' mm2  ' : </cite>  ' aline
             else call lineout tempfile,  aline

          writlin=writlin+1
          if writlin>=maxdisp then leave
     end                     /* output lines of the paragraph */
     if para_delim<>'$' & show_bar=1 then
         call lineout tempfile,' <hr width=10% height=5> '

     /* jump here if matchall=1 and not all matches */
end                    /* do next paragraph */


asummary:
  call lineout tempfile,' <hr width= 75%>'
  call lineout tempfile,' <p> <h3> Summary of results: ' goober ' </h3> '
  call lineout tempfile,'  # "paragraphs" = ' nthpara
  if para_delim=" "  para_delim="$" then do
    call lineout tempfile,' <menu> '
    call lineout tempfile,' <li> # of lines = ' filelines.0
    call lineout tempfile,'</menu> '
  end
  else
    call lineout tempfile,'<br> '

  call lineout tempfile,'  # paragraphs with matches= ' nmatch
  if dispdetails=1 then do
    call lineout tempfile,'<menu> '
    do mm=1 to searchfor.0
       call lineout tempfile,'<li> ' searchfor.mm ' = ' allmatch.mm
    end
    call lineout tempfile,'</menu> '
  end

 if ith_file<files_todo then do                     /* get next file */
      call lineout tempfile,'  <hr> '
      call lineout tempfile,'  <Hr width=5> '
      call lineout tempfile,' <hr> '

      signal nextfile
end

  call lineout tempfile,'</body>'
  call lineout tempfile,'</html>'
  call lineout tempfile

/* check if "fix expire" should be done */
  FIX_EXPIRE = get_value('FIX_EXPIRE')
  itt=chars(tempfile);aa=stream(tempfile,'c','close')
  IF FIX_EXPIRE>0 THEN DO
          FOO=EXPIRE_response(fix_expire,itt)
  end
  return 'FILE  ERASE TYPE text/html NAME ' tempfile

oyvey:                  /* jump here if bad expert mode */
  call lineout tempfile,'<h3> Bad logical search expression </h2> '
   if VERBOSE>0 then  say " Bad  searchlist specified."
   call lineout tempfile,' <p> <strong> A bad logical expression was specified  <strong> '
   call lineout tempfile,'</body> </html>'
  call lineout tempfile

   return 'FILE  ERASE TYPE text/html NAME ' tempfile



/* ----------------------------------------------------------------------- */
/* GET_SEARCHFOR: Create the "search for" list (of things to search for ) */
/* ----------------------------------------------------------------------- */

get_searchfor: procedure expose searchfor.  cond. verbose
parse arg searchlist, check_case

ith=0
if check_case<>1 then searchlist=translate(searchlist)

acondstate='OR'                 /* default state */
mm=0
do until mm=words(searchlist)
   mm=mm+1
   aword=word(searchlist,mm)
   a1a=verify('\&(|%',aword,'m')
   select 
     when a1a=0  then do   
        ith=ith+1
        searchfor.ith=aword
        cond.ith=acondstate
        acondstate='OR'            /* reset to OR */
     end
     when a1a=1 then     /*  Not is an AND NOT */
        acondstate='NOT'
     when a1a=2 then
        acondstate='AND'
     when a1a=4 then            /* included for completeness */
        acondstate='OR'
     when a1a=5 then
        acondstate='ORNOT'
     when a1a=3 then do  /* begin a phrase -- find the first ) to end it */
         ajj=wordpos(')',searchlist,mm)
         if ajj=0 then ajj=words(searchlist)+1
         if ajj>mm+1 then do
            ith=ith+1
            searchfor.ith=' '||subword(searchlist,mm+1,ajj-(mm+1))||' '
            cond.ith=acondstate
         end
         mm=ajj
      end
      otherwise
   end
end
searchfor.0=ith
return ith


/* -------------------------------------------------------- */
/* BUILD_PARAS: Build paragraphs from lines (blank line delimits a paragraph */
/* -------------------------------------------------------- */

build_paras: procedure expose filelines. paras. verbose
  
     apara=0
     nthpara=0
     do mm=1 to filelines.0
       if filelines.mm="" then do
          if apara=1 then do    /* second or more of a series of blank lines */
              paras.nthpara.last=mm-1
             apara=0
          end
        end
        else do
          if apara=0  then do
             nthpara=nthpara+1
             paras.nthpara.first=mm
             apara=1
          end
        end
     end  /* Do filelines.0 */

     if apara=1 then paras.nthpara.last=filelines.0
     return nthpara

/* ------------------------------------------------------------------- */
/* MATCH_PARA: Does this paragraph match the search string(s)  */
/* ------------------------------------------------------------------- */

match_para: procedure expose searchfor. cond. mlist. allmatch. verbose
  parse arg apara , check_case

  apara2=apara
  if check_case<>1 then apara2=translate(apara2)

/* scan for matches in the paragraph */
    gotems=0 ; numors=0

    do nn= 1 to searchfor.0                     /*see how many or conditions there are */
        if cond.nn="OR" then numors=numors+1
        mlist.nn=0
    end
 
    do is=1 to searchfor.0   /*search for targets in this paragraph*/
       joe=pos(searchfor.is,apara2)

       if joe=0 & cond.is="AND" then do    /* failure of an "all matches" */
           gotems=0
           leave
       end
       if joe>0 & cond.is="NOT" then do   /* failure of a "not any of these*/
           gotems=0
           leave
       end
       if joe>0 & cond.is="ORNOT"  then do  /* or not condition failed */
           gotems=0
           leave
       end
 
/* if here, no fatal flaw */
      if (joe>0 ) & (pos('NOT',cond.is)=0) then mlist.is=1

      if  (joe>0 & cond.is="OR") | (joe=0 & cond.is="ORNOT")  then do
              allmatch.is=allmatch.is+1
              gotems=gotems+1
       end
       if (joe>0 & cond.is="AND" & numors=0) then do  /* if no or conditions.. */
              gotems=gotems+1
              allmatch.is=allmatch.is+1
       end
       
     end
     return gotems



/* -------------------------------------------------------------- */
/*  GRAB_FILE_LINES:  Get a file, parse into a "lines" stem variable
.  Read in a file, but first check to see if openable, and if
.  so, open and  read.  After reading, split into logical lines,
.  using the eol character ('0d0a'x  by default), and return
.  each of these lines in the filelines. stem variable.
.  Note: filelines.0 holds # of lines; also, the number of lines
.  is returned (so if 0 returned, failure probably caused by no such file)
.  Usage:
.   filelines.0= 0 ;  nlines=grab_file_lines(afile,30,optional_eol_delimiter)
.   (filelines.1 to filelines.(filelines.0) contain afile)
*/
/* ------------------------------------------------------------- */

grab_file_lines: procedure expose filelines. verbose

parse arg afile, msec, aneol    /* file to get, seconds to wait, eol delimiter */

crlf = '0d0a'x

if aneol="" then aneol=crlf

ause=sref_grab_file(afile,msec)
if ause=0 then                  /* couldn't get it */
  return 0

/* got a file, let's parse it */
if filelines.0<>0 & VERBOSE>0 then say " Warning: overwriting filelines stem variable "
filelines.0=0
i=0
aneol=strip(aneol)
do until ause=""
  i=i+1
  parse var ause filelines.i (aneol) ause
end
filelines.0=i
return filelines.0
 
/********************************************************************************/
/***********************************/
/* Tim Osborne's fancy logical parser */

expert_parse: procedure  expose verbose
 parse  arg mystring , haystack , check_case
  if check_case<>1 then mystring=translate(mystring)

 if haystack="" then haystack="HAYSTACK"

/*
  User enters logical search string

   User can include any level of nested parentheses to
   override normal order of logical statement.  Parentheses
   are not required however.

say 'What are you looking for?'
pull mystring
*/

mystring='('||mystring||')'
mystring=space(mystring)
if pos('(',mystring)=0 & pos('|',mystring)=0 & pos('\',mystring)=0 & pos('&',mystring)=0 & pos('@',mystring)=0 then do
   mystring='('||mystring||')'
   end
else do
   blanks= pos(' (',mystring)>0 | pos('( ',mystring)>0 | pos(' &',mystring) >0 | pos('& ',mystring)>0 |,
           pos(' |',mystring)>0 | pos('| ',mystring)>0 | pos(' @',mystring) >0 | pos('@ ',mystring)>0 |,
           pos(' \',mystring)>0 | pos('\ ',mystring)>0 | pos(' )',mystring) >0 | pos(') ',mystring)>0
   do while blanks > 0
      if pos(' (',mystring) \=0 then mystring=substr(mystring,1,pos(' (',mystring)-1)||'('||substr(mystring,pos(' (',mystring)+2)
      if pos(' )',mystring) \=0 then mystring=substr(mystring,1,pos(' )',mystring)-1)||')'||substr(mystring,pos(' )',mystring)+2)
      if pos(' |',mystring) \=0 then mystring=substr(mystring,1,pos(' |',mystring)-1)||'|'||substr(mystring,pos(' |',mystring)+2)
      if pos(' &',mystring) \=0 then mystring=substr(mystring,1,pos(' &',mystring)-1)||'&'||substr(mystring,pos(' &',mystring)+2)
      if pos(' @',mystring) \=0 then mystring=substr(mystring,1,pos(' @',mystring)-1)||'@'||substr(mystring,pos(' @',mystring)+2)
      if pos(' \',mystring) \=0 then mystring=substr(mystring,1,pos(' \',mystring)-1)||'\'||substr(mystring,pos(' \',mystring)+2)
      if pos('( ',mystring) \=0 then mystring=substr(mystring,1,pos('( ',mystring)-1)||'('||substr(mystring,pos('( ',mystring)+2)
      if pos(') ',mystring) \=0 then mystring=substr(mystring,1,pos(') ',mystring)-1)||')'||substr(mystring,pos(') ',mystring)+2)
      if pos('| ',mystring) \=0 then mystring=substr(mystring,1,pos('| ',mystring)-1)||'|'||substr(mystring,pos('| ',mystring)+2)
      if pos('& ',mystring) \=0 then mystring=substr(mystring,1,pos('& ',mystring)-1)||'&'||substr(mystring,pos('& ',mystring)+2)
      if pos('@ ',mystring) \=0 then mystring=substr(mystring,1,pos('@ ',mystring)-1)||'@'||substr(mystring,pos('@ ',mystring)+2)
      if pos('\ ',mystring) \=0 then mystring=substr(mystring,1,pos('\ ',mystring)-1)||'\'||substr(mystring,pos('\ ',mystring)+2)

           blanks= pos(' (',mystring)>0 | pos('( ',mystring)>0 | pos(' &',mystring) >0 | pos('& ',mystring)>0 |,
              pos(' |',mystring)>0 | pos('| ',mystring)>0 | pos(' @',mystring) >0 | pos('@ ',mystring)>0 |,
              pos(' \',mystring)>0 | pos('\ ',mystring)>0 | pos(' )',mystring) >0 | pos(') ',mystring)>0
    end
end
if lastpos(')',mystring) \= length(mystring) then mystring='('||mystring||')'
mystring=mystring||'*'
pointer=1
notin=1
mychar=substr(mystring,pointer,1)
do until mychar='*'
           if pos(substr(mystring,pointer,1),'()|&@\')=0 & notin then do
              mystring=substr(mystring,1,pointer-1)||'pos('''||substr(mystring,pointer)
              notin=0
              pointer=pointer+4
           end
           else do
              if pos(substr(mystring,pointer,1),'()|&@\')>0 & notin=0 then do
                 mystring=substr(mystring,1,pointer-1)||''',haystack)>0'||substr(mystring,pointer)
                 notin=1
                 pointer=pointer+12
              end
           end
           pointer=pointer+1
           mychar=substr(mystring,pointer,1)
end
mystring=substr(mystring,1,length(mystring)-1)
do while pos('@',mystring)>0
   mystring=insert('&&',mystring,pos('@',mystring))
   mystring=delstr(mystring,pos('@',mystring),1)
end
/*say " mystring: " mystring*/
return mystring


/* ----------- */                                                        
/* get environment value, possibly host specific */                      
/* ------------ */                                                       
get_value: procedure expose enmadd host_nickname                          
parse arg vname,hname0
if hname0=0 then 
        hname=' '
else                                                    
    hname=strip(host_nickname)                          

vname=strip(vname) ;
if hname<>' ' then do
   booger=strip(enmadd||vname||'.'||hname)
   aval=value(booger,,'os2environment')
   if aval<>' ' Then                                                     
        return aval                                                      
end                                                                      
aval=value(enmadd||vname,,'os2environment')                              
return aval   



/* ----------------------------------------------------------------*/
/* Routine to create an "expires" response header from scratch.
Included here to provide support for object rexx.
(the sref_expire macrospace routine could be used instead, but
only if running under classic rexx)
*/

expire_response: procedure
  parse arg aoffset, alength,am1,adrop,message_id
  if am1="" then am1="text/html"
  if alengh="" then alength=0
  if aoffset="" then aoffset=0.04
  if message_id=' ' then do
        message_id=0
        tst=upper(extract('test'))
        if tst='ON' then do
          p1=date('s')
          p2=time('n') ; p2=delstr(p2,3,1); p2=delstr(p2,5,1)
          p3=extract('serverport')
          p4=extract('transaction')
          p5=extract('serveraddr')
          message_id='<'||p1||p2||'.'||p3||'.'||p4||'@'||p5||'>'
        end
  end


  adrop1=' '
   if adrop="" | abbrev(translate(adrop),'Y')=1 then adrop1="NOAUTO"
 
  'RESPONSE HTTP/1.0 200 OK EXPIRE OFFSET'     /* Set HTTP response line */
  'HEADER ' adrop1 ' ADD Server: ' server()
   thisdate=sref_new_gmt()' GMT '
   expdate=sref_new_gmt(aoffset)' GMT'
  'HEADER ADD Date: 'thisdate
   if message_id<>'0' then
        'HEADER ADD Message-ID: ' message_id
  'HEADER ADD Content-Type: ' am1
  'HEADER ADD Content-Length:' alength
  'HEADER ADD Expires:'expdate
  'HEADER ADD Content-Transfer-Encoding: binary '
return 0

