/* DOGET -- get's a resource from an HTTP server                 */
/* ------------------------------------------------------------------- */
/* Call as: DOGET [serveraddress [requeststring]]                   */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */

call load /* load functions if necessary */

say " Issue a GET method request to an HTTP server, and display complete response "
parse arg server request .
if server="" then do 
    mehost=get_hostname()
    say " Please enter server address (ENTER= " mehost ": "
    parse pull server
    if server="" then server=mehost
end  /* Do */
if request="" then  do
  say " Please enter url to GET: "
  parse pull request
end

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")


message='GET /'request' HTTP/1.0'crlf'HOST:'server||crlf

/*Note: uncomment these lines, and changes the "bytes=" ranges,
if you only want a segment(s) of the URL*/
/*
message=message||"Connection:keep-alive"||crlf
message=message||"Range:bytes=0-50,200-400"||crlf
*/
message=message||'Referer:joes_bar'||crlf

message=message||crlf
say message


got=''
rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit; end
rc = SockSend(gosock, message)
say " rc " rc
/* Now wait for the response */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  got=got||response
  /* say '>'rc'>' response */
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

say 'Got' length(got) 'bytes of response:'

findit=crlf||crlf
foo=pos(findit,got)
say foo
t1=substr(got,1,foo)
say t1
say " =--- writing results to doget.lst "
t2=substr(got,foo+length(findit))
tt='doget.lst'
eek=charout(tt,t2,1)
say eek

exit

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return

/* get the hostname (aa.bb.cc) for this machine */
get_hostname: procedure
    do queued(); pull .; end                   /* flush */
    address cmd '@hostname'  '| rxqueue'    
    parse pull hostname                        
    return hostname

