// Class RESTRING: Encapsulates the load/discard
//   logic for a resource String Table entry.

#define INCL_BASE
#include <os2.h>

#include "debug.h"

#include "restring.h"

// #define DEBUG


  // Constructor

ResourceString::ResourceString ( HMODULE Module, ULONG Id ) : StringPointer(0) {

   SavedModule = Module ;
   SavedId = Id ;

   APIRET Status = DosGetResource ( Module, RT_STRING, Id/16+1, &BlockPointer ) ;
   if ( Status ) {
      Log ( "ERROR: Unable to get string resource.  Module %lu, id %lu, code %08lX.",
         SavedModule, SavedId, Status ) ;
      return ;
   } /* endif */

   StringPointer = PSZ(BlockPointer) + sizeof(USHORT) ;

   USHORT Index = (USHORT) ( Id % 16 ) ;
   while ( Index-- ) {
      #ifdef DEBUG
      Log ( "ResourceString: Searching for ID %08X, skipping string '%s' (len %u).", Id, StringPointer+1, *PUCHAR(StringPointer) ) ;
      #endif
      StringPointer += * PUCHAR ( StringPointer ) ;
      StringPointer ++ ;
   } /* endwhile */

   StringPointer ++ ;

   #ifdef DEBUG
   Log ( "ResourceString: Searching for ID %08X, found string '%s' (len %u).", Id, StringPointer, *PUCHAR(StringPointer-1) ) ;
   #endif
}
