/* BackTalk installation. You will need UNZIP.EXE in your path or current */
/* directory.  The installer will use its execution directory files, NOT  */
/* the ones from the directory you were at the prompt.                    */
/*                                        Samuel Audet <guardia@cam.org>  */

/* Load necessary RexxUtil functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' 
call SysLoadFuncs

parse arg parm
parm = strip(parm)

/* Help screen */

if (parm = '' | pos('?',parm) > 0) then do
   say 'Usage:  INSTALL <target directory>'
   say 'ie:  install g:\backtalk'
   exit
end

/* Finding and switching execution directory */

parse source . . sourcename
sourcedir = filespec('D', sourcename)||filespec('P', sourcename)
sourcedir = left(sourcedir, length(sourcedir)-1)
call directory sourcedir

/* Remove trailing backslash */

if lastpos('\',parm) = length(parm) then parm = left(parm,length(parm) - 1)

/* Introduction */

say
Say 'BackTalk 1.3 installer powered by REXX POWER!!'
Say 'This installer uses and includes freeware Info-ZIP UNZIP 5.x'
Say 'You will *NEED* the EMX runtime librairies during the installation.'
Say 'Note: if you have a previous version of BackTalk, please remove the'
say 'program directory and the WPS Folder with the Program Objects.'
say

/* Finding UNZIP.EXE */

if search('UNZIP.EXE','PATH') = 2 then exit

/* Queries */

Call CharOut, 'Install BackTalk in 'parm' ? '
AKey = SysGetKey( 'ECHO' )
If AKey <> 'y' & AKey <> 'Y' Then Exit

/* Making specified directory */

say

rc = SysMkDir(parm)
if rc > 0 then do
  say 'Failed creating' parm
  if rc = 5 then say 'Please remove the existing directory first'
  exit
end

say

Call CharOut, 'Install flip (necessary for MR/2 ICE)? '
AKey = SysGetKey( 'ECHO' )
If AKey = 'y' | AKey = 'Y' Then mr2 = 1

/* define the default install options */

ver = '22'
spch = 'spch-16b.cmd'
pmaud = 0
akey = 1

/* Testing for possible kludge, and let the user try */

do until akey = d2c(27)
   'cls'
   say 'The following options will test your system "capability".'
   say 'The first options are better if working, please try them first.'
   say 'Press ESC when you have made your choice, the latter will reflect'
   say 'the last option you tried.'
   say
   say 'Currently selected option is:' akey
   say '1. Rsynth 2.2 with 16 bit audio'
   say '2. Rsynth 2.2 with 8 bit audio'
   say '3. Rsynth 2.1 with 16 bit audio'
   say '4. Rsynth 2.1 with 8 bit audio'
   say '5. Rsynth 2.1 with chipmunk voice fix'
   say '6. AU sound file dumping'
   say '7. WAV sound file dumping'
   Call CharOut, 'Choice: '
   AKey = SysGetKey( 'ECHO' )
   Select
      when akey = '1' then do
         'unzip rsynth22.zip say.exe'
         'say -b 16 "hello world"'
         'del say.exe'
         ver = '22'
         spch = 'spch-16b.cmd'
         pmaud = 0
         end
      when akey = '2' then do
         'unzip rsynth22.zip say.exe'
         'say "hello world"'
         'del say.exe'
         ver = '22'
         spch = 'spch-8b.cmd'
         pmaud = 0
         end
      when akey = '3' then do
         'unzip rsynth21.zip say.exe'
         'say -b 16 "hello world"'
         'del say.exe'
         ver = '21'
         spch = 'spch-16b.cmd'
         pmaud = 0
         end
      when akey = '4' then do
         'unzip rsynth21.zip say.exe'
         'say "hello world"'
         'del say.exe'
         ver = '21'
         spch = 'spch-8b.cmd'
         pmaud = 0
         end
      when akey = '5' then do
         'unzip rsynth21.zip say.exe'
         'say +C "hello world"'
         'del say.exe'
         ver = '21'
         spch = 'spch-chip.cmd'
         pmaud = 0
         end
      when akey = '6' then do
         'unzip rsynth22.zip say.exe'
         'unzip pmaud11.zip audt.exe'
         'say +Q -o temp.wav "hello world"'
         'audt temp.wav'
         'del say.exe'
         'del audt.exe'
         'del temp.wav'
         ver = '22'
         spch = 'spch-au.cmd'
         pmaud = 1
         end
      when akey = '7' then do
         'unzip rsynth22.zip say.exe'
         'unzip pmaud11.zip audt.exe'
         'say +Q -w temp.wav "hello world"'
         'audt temp.wav'
         'del say.exe'
         'del audt.exe'
         'del temp.wav'
         ver = '22'
         spch = 'spch-wav.cmd'
         pmaud = 1
         end
      otherwise
         if akey <> d2c(27) then akey = 1
   end
end

/* Unzipping, copying, deleting files */

'unzip rsynth'ver' -d 'parm'\RSynth'
'unzip rexx -d 'parm'\REXX'
'unzip uptime -d 'parm'\Uptime'
if pmaud = 1 then 'unzip pmaud11.zip audt.exe -d 'parm'\RSynth'
if mr2 = 1 then 'unzip flip1os2 -d 'parm'\flip'
'copy readme 'parm
'ren' parm'\REXX\'spch 'speechq.cmd'
'copy 'parm'\rexx\speechq.cmd 'parm'\rsynth'
'copy 'parm'\rexx\spkstart.cmd 'parm'\rsynth'
'copy 'parm'\rexx\spkstats.cmd 'parm'\uptime'
'del' parm'\REXX\spch-*'
'del' parm'\REXX\speechq.cmd'
'del' parm'\REXX\spkstart.cmd'
'del' parm'\REXX\spkstats.cmd'

/* Creating WPS Objects */

say

classname='WPFolder'
title='BackTalk'
location='<WP_DESKTOP>'
setup='OBJECTID=<BACK_TALK>;'||,
      'ICONFILE='sourcedir'\backfld.ico;'||,
      'ICONNFILE=1,'sourcedir'\backfldn.ico;'
Call BldObj

classname='WPProgram'
title='Speech Queue'
location='<BACK_TALK>'
setup='OBJECTID=<SPCH_QUEUE>;'||,
      'EXENAME='parm'\rsynth\speechq.cmd;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Stop Speech'
location='<BACK_TALK>'
setup='OBJECTID=<STOP_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_END;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Mute Speech'
location='<BACK_TALK>'
setup='OBJECTID=<MUTE_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_MUTE;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Unmute Speech'
location='<BACK_TALK>'
setup='OBJECTID=<UNMUTE_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_UNMUTE;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Discard Messages'
location='<BACK_TALK>'
setup='OBJECTID=<DISCARD_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_DISCARD;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Say Queued'
location='<BACK_TALK>'
setup='OBJECTID=<QUEUED_SPCH>;'||,
      'EXENAME='parm'\rexx\spchcmd.cmd;'||,
      'PARAMETERS=COMMAND_NUMQUEUED;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Say Something'
location='<BACK_TALK>'
setup='OBJECTID=<SPEECH>;'||,
      'EXENAME='parm'\rexx\spchsnd.cmd;'||,
      'PARAMETERS=[Enter text to say:];'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='System Stats'
location='<BACK_TALK>'
setup='OBJECTID=<SYS_SPCH>;'||,
      'EXENAME='parm'\uptime\spkstats.cmd;'||,
      'PARAMETERS=COMMAND_END;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

classname='WPProgram'
title='Speaking Clock'
location='<BACK_TALK>'
setup='OBJECTID=<CLOCK_SPCH>;'||,
      'EXENAME='parm'\rexx\spkclock.cmd;'||,
      'MINIMIZED=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj

a = 'PARAMETERS=-t1 [countdown time (minutes):]'
b = '-l1 [laps time(seconds):] -m1 [speaking message:]'
c = '-t2 [time left to fall in urgent mode(minutes):]'
d = '-l2 [laps time in urgent mode (seconds):] -m2 [message in urgent mode:]'
e = '-m3 [alert message when timer has stopped:];'
classname='WPProgram'
title='Speaking Timer'
location='<BACK_TALK>'
setup='OBJECTID=<TIMER_SPCH>;'||,
      'EXENAME='parm'\rexx\spktimer.cmd;'||,
      'MINIMIZED=YES;'||,
      a b c d e||,
      'CCVIEW=YES;'||,
      'ICONFILE='sourcedir'\speech.ico;'
Call BldObj
 
say 'Creating Shadow: README'
if SysCreateShadow(parm'\README','<BACK_TALK>') = 0 then
   say 'Error: Object not created.'

Exit

/* Build Object */

BldObj:
   say 'Creating Object: 'title
   result = SysCreateObject(classname, title, location, setup, 'R')
   If result > 1 Then say 'Error: Object not created. Return code='result
Return

/* Search 'filename' in 'path' and give error msg and error level */

Search:
   parse arg filename, path
   found = 0
   if SysSearchPath(path,filename) = '' then do
      say filename' not found.'
      found = 2
   end
return found
