/* AdeptREXX */

Arg Line

Call AdeptInitREXX

/*

  Mini Gopher Document Retriever for Adept, by Robert Stephens.
  This program will retrieve a document from a gopher server on
  the Internet.

  Adapted/Updated to act as an interactive gopher client By Paul Meyer.

  v1.00 - Prettied it up a little
          Added exit on no server bit

  v0.90 - Supports transferring of binary files.

  v0.50 - Fixed a bug where I forgot to add a crlf on the end of some dirs :>
        - Fixed a bug in the ReceiveText sub... forgot to change one var :>

  v0.10 - Supports Text, Dirs, Searches and Telnet links.

  This requires RxSock.DLL.

  You may need to edit the DownloadDir variable below.

*/

If RxFuncQuery("SockLoadFuncs") Then Do
  rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
  rc = SockLoadFuncs()
End

Call AdeptLocation line, "AdeptGopher!"
Call AdeptSayGen line, "AdeptGopher!"

Counter      = 1
lastsite     = 0
Tab          = D2C(9)
Lf           = D2C(10)
CrLf         = D2C(13) || Lf
ScreenLength = AdeptGetVar(Line,46)
DownloadDir  = '\Adept\Temp'

Call AdeptCls Line

GopherAddr = InputBox(" Enter Gopher Site to Connect To: ",70)
if GopherAddr == '' then exit

Call AdeptCls Line
Call OutputData('[44m[K[1;33;44mAdeptGopher! Gopher Client for Adept.            By Paul Meyer & Robert Stephens')
Call OutputData('\r[7m[KPlease wait, connecting socket...')

Call LoopUser
Exit



/*Ĵ ReceiveDir */
ReceiveDir:

  Call Load

  Call AdeptCls Line
  Call OutputData('[44m[K[1;33;44mAdeptGopher! Gopher Client for Adept.            By Paul Meyer & Robert Stephens')
  Call OutputData('\r[7m[K[0m\r\n')

  Call CreateDirStem

  counter = 0

  Do b = 1 To a
    Rawdata = data.b.title
    Do 500 /* Incase something goes wrong, we wont get stuck in an endless loop */
      rc = Pos(Lf,Rawdata)
      If rc = 0 then do
            if(counter=ScreenLength-5)then
                do
                  Call AdeptMore line
                  counter = 0
                end
        Call AdeptPrint line, "{FG" "{F9. {F8"RawDataCrLf"[0m"
                counter = counter + 1
        Leave
      End
      Call OutputData(Left(RawData,rc - 2) || '\r\n')
      RawData = DbrLeft(RawData,rc)
    End
  End

Return
/**/



/*Ĵ ReceiveText */
Receivetext:

  Call Load

  Call AdeptCls Line
  Call OutputData('[44m[K[1;33;44mAdeptGopher! Gopher Client for Adept.            By Paul Meyer & Robert Stephens')
  Call OutputData('\r[7m[K[0m\r\n')

  Do b = 1 To a
    RawDataBlock = RawData.b
    Do 200 /* Incase something goes wrong, we wont get stuck in an endless loop */
      rc = Pos(Lf,RawDataBlock)
      If rc = 0 Then Do /* no linefeed in data */
        Call AdeptPrint Line, RawDataBlock
        Leave
      End
      Call OutputData(Left(RawDataBlock,rc - 2) || '\r\n')
      RawDataBlock = DbrLeft(RawDataBlock,rc)
    End
  End

return
/**/



/*Ĵ Load */
Load:

  len = 1

  Call AdeptSleep Line, 250
  Call AdeptPrint Line, '  Bytes Read: [s'

  a = 0
  ByteCount = 0
  Do While Len \= 0
    a = a + 1
    Len = SockRecv(s,'RawData.' || a,512,0)
    ByteCount = ByteCount + Len
    If Len < 0 Then Do
      Call MsgBox "Error Connecting Socket To Remote System", " Error (errno="||errno||") "
      Exit
    End
    If Len > 255 Then Call AdeptPrint Line, '[u'  ByteCount
    Call AdeptSleep Line, 32
  End

  Call AdeptPrint Line, '\r\n\r\n[0m'

return
/**/



/*Ĵ CreateDirStem */
CreateDirStem:

  lastcrlf = 0
  longdata=""

  do c = 1 to a
    longdata = longdata||rawdata.c
  end

  a = 0

  do while (lastcrlf\=LASTPOS(crlf,longdata)) & (szline.a\='.')
    a = a+1
    lastcrlf = POS(crlf,longdata,1)
    lastcrlf = lastcrlf-1
    if(lastcrlf<0)then lastcrlf = 0

    szline.a = LEFT(longdata,lastcrlf)
    longdata = DbrLeft(longdata,POS(crlf,longdata,1)+1)
  end

  do c = 1 to a
    pv = translate(szline.c,'',D2C(9))
    parse var pv data.c.title '' data.c.dir '' data.c.server '' data.c.port '' GopherPlus
    data.c.id    = LEFT(data.c.title,1)
    data.c.title = Dbrleft(data.c.title,1)
        if(data.c.id==1)then
          data.c.title = data.c.title||"..."
  end

  a = a-1

return
/**/



/*Ĵ OutputData */
OutputData:

  Parse Arg Output

  Call AdeptPrint Line, Output
  Counter = Counter + 1
  If Counter = ScreenLength - 1 Then Do
    Call AdeptPrint Line, '[1;37m-Press any Key-[0m'
    Key = AdeptWaitKey(Line)
    If Key = '-2' Then Exit /* CD Drop */
    Call AdeptPrint Line, '\r'
    If D2C(Key) = 'q' Then Exit /* q for quick exit ... */
    Counter = 0
  end

return
/**/



/*Ĵ Connect */
connect:

  Parse Arg srv,prt,direct

  if(Pos(Lf,direct)=0)then
    direct = direct||CrLf

  Call AdeptCls Line
  Call OutputData('[44m[K[1;33;44mAdeptGopher! Gopher Client for Adept.            By Paul Meyer & Robert Stephens')
  Call OutputData('\r[7m[K[0m\r\n')

  s = SockSocket('AF_INET','SOCK_STREAM','0') /* Create a Socket */

  gopher.!family = 'AF_INET'
  gopher.!port   = prt
  gopher.!name   = srv

  rc = SockGetHostByName(gopher.!name,"gopher.!")
  rc = SockConnect(s,"gopher.!")
  If rc < 0 Then Do
    Call MsgBox "Error Connecting Socket To Remote System", " Error (errno="||errno||") "
    Exit
  End
  Call AdeptCurPos line,1,0
  Call AdeptPrint Line, '[7m[KConnection Opened with '  Srv  ' on Port '  gopher.!port  '.'
  rc = SockSend(s,Direct,0)

return
/**/



/*Ĵ AGDrawBox */
/* Usage:
     Call AGDrawBox width, height
*/
AGDrawBox:

  Arg width, height

  Left  = 40-TRUNC(width/2)
  Right = 40+TRUNC(width/2)
  Top   = TRUNC(ScreenLength/2-height/2)

  Call AdeptCurPos line, Top, Left
  Call Adeptprint line,""

  do width-2
    Call AdeptPrint line,""
  end

  Call AdeptPrint line,""

  do i = 1 to height
    Call AdeptCurPos line, top+i, left
    Call AdeptPrint line,""
    do width-2
      Call AdeptPrint line," "
    end
    Call AdeptPrint line,""
  end

  Call AdeptCurPos line, Top+height, Left
  Call Adeptprint line,""

  do width-2
    Call AdeptPrint line,""
  end

  Call AdeptPrint line,""

return
/**/



/*Ĵ MsgBox */
/* Usage:
     Call MsgBox "Text inside box", "Title"
*/
MsgBox:

  Parse Arg Output,Title

  TitleLength = LENGTH(Title)
  OutputLength = LENGTH(Output)

  i=0

  if(OutputLength>75)then
  do
    do while Length(Output)>1
      i=i+1

      ls = lastpos(' ',Output,76)
      if(ls==0) then
        OutputLength = 76
      else
        OutputLength = ls

      Out.i = Left(Output, OutputLength)
      if(Length(Output)>75)then
        Output = DbrLeft(Output, OutputLength)
      else
        Output = DbrLeft(Output, Length(Output))
    end
    OutputLength=76
  end
  else
  do
        i=1
    Out.i = Output
  end

  numlines = i

  if TitleLength>OutputLength then
  do
    TitleLength = OutputLength
    Title = Left(Title, TitleLength)
  end

  Call AGDrawBox Outputlength+4, 3+i

  Left = (40-TRUNC(Outputlength/2))
  Top = (TRUNC(ScreenLength/2)-TRUNC(i/2))
  Right = (40+TRUNC(OutputLength/2))

  Call AdeptCurPos line, Top, (40-TRUNC(Titlelength/2))
  Call AdeptPrint line,"{FG"Title

  do a = 1 to numlines
    Call AdeptCurPos line, Top+1+a, (40-TRUNC(Outputlength/2))
    Call AdeptPrint line,Out.a
  end

  Call AdeptCurpos line, 0,0
  Call AdeptWaitKey line

return
/**/



/*Ĵ InputBox */
/* Usage:
     value = InputBox("Title", MaxLength)
*/
InputBox:

  Parse Arg Title,MaxLength

  TitleLength = LENGTH(Title)
  Top = (TRUNC(ScreenLength/2)-3)

  /* Draw the Box */
  Call AGDrawBox MaxLength+4, 4

  /* Output the Title */
  Call AdeptCurPos line, Top, (40-TRUNC(Titlelength/2))
  Call AdeptPrint line,Title

  /* Read the input */
  Call AdeptCurPos line, Top+2, (40-TRUNC(MaxLength/2))
  szrc = AdeptInput(line, 1, MaxLength, STRT_ALL, STRF_EDIT+STRF_NOHELP, "", "", "", "")

return szrc
/**/



/*Ĵ HandleSearch */
HandleSearch:

  SearchString = InputBox(" Enter Search Details: ")
  call connect data.key.server, data.key.port, data.key.dir||Tab||SearchString||CrLf
  call receivedir

return
/**/



/*Ĵ HandleTelnet */
HandleTelnet:

  rc = AdeptRawOpenSocket(ISTELNETCLIENT, data.key.server, data.key.port, 'TelnetPortHandle')

  if((port<>0) & (rc=0))then
  do
    rc = AdeptRawComLink(line, TelnetPortHandle)
        rc = AdeptRawClose(TelnetPortHandle)
  end
  else
  do
        Call MsgBox "Error: Could not connect to host.", " Error (rc="||rc||") "
  end

return
/**/



/*Ĵ LoopUser */
HandleBinary:

  lastbackslash = LASTPOS('/',Data.key.Dir)
  OutputFile = Dbrleft(Data.key.dir,lastbackslash)

  Outputfile = DownloadDir||'\'||Outputfile

  Call Load

  Do b = 1 To a
    Call Charout OutputFile, RawData.b
  end

  Call AdeptMenuType line,86,OutputFile

return
/**/



/*Ĵ LoopUser */
LoopUser:

  history.0.server = GopherAddr
  history.0.port   = 70
  history.0.dir    = CrLf

  Call Connect GopherAddr, 70, CrLf
  Call ReceiveDir

  do forever
    Call AdeptCurPos line, 20,50
    call AdeptPrint line,"{FGChoose (? for Help){F9: {F8"

    key = AdeptInput(line, 1, 3, STRT_ALL, STRF_EDIT+STRF_NOHELP, "", "", "", "")
    If Key = '-2' Then Exit /* CD Drop */
    If Key = 'q'  Then Exit /* q for quick exit ... */
        If Key = '?'  Then
        do
          Call MsgBox "q - Quit ; < or p - Last Menu ; ? - Help", " Ultra-Quick Help "
          Iterate
        end
        If (Key = '<')|(Key = 'p')|(Key = 'P') Then
        do
          lastsite = lastsite - 1
          if(lastsite<0)then lastsite = 0
      Call Connect history.lastsite.server, history.lastsite.port, history.lastsite.dir
      Call ReceiveDir
          iterate
        end

        SELECT
          WHEN data.key.id==0 THEN /* Text */
      do
        Call Connect data.key.server, data.key.port, data.key.dir||CrLf
        Call ReceiveText
        Call AdeptHitReturn
        Call Connect history.lastsite.server, history.lastsite.port, history.lastsite.dir
        Call ReceiveDir
      end
          WHEN data.key.id==1 THEN /* Dir  */
      do

        lastsite = lastsite + 1

        history.lastsite.server = data.key.server
        history.lastsite.port   = data.key.port
        history.lastsite.dir    = data.key.dir

        Call Connect data.key.server, data.key.port, data.key.dir||CrLf
        Call ReceiveDir

          end
          WHEN data.key.id==5 THEN /* Binary */
          do
        Call Connect data.key.server, data.key.port, data.key.dir||CrLf
            Call HandleBinary
          end
          WHEN data.key.id==7 THEN /* Search */
          do
        Call Connect data.key.server, data.key.port, data.key.dir||CrLf
            Call HandleSearch
          end
          WHEN data.key.id==8 THEN /* Telnet */
          do
            Call HandleTelnet
        Call Connect history.lastsite.server, history.lastsite.port, history.lastsite.dir
        Call ReceiveDir
          end
          WHEN data.key.id==9 THEN /* Binary */
          do
        Call Connect data.key.server, data.key.port, data.key.dir||CrLf
            Call HandleBinary
          end
          OTHERWISE
          do
            Call MsgBox "Error: Selection Not Supported.", " Error "
        Call Connect history.lastsite.server, history.lastsite.port, history.lastsite.dir
        Call ReceiveDir
          end
        end
  end

return
/**/

