unit Demo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, EnhTwain, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    scanner: TEnhTwain;                        
    ScrollBox1: TScrollBox;
    image: TImage;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Interactive: TCheckBox;
    setup: TPanel;
    Label1: TLabel;
    PixelType: TComboBox;
    Label2: TLabel;
    BDReduction: TComboBox;
    Label3: TLabel;
    BitDepth: TComboBox;
    Label4: TLabel;
    resolution: TComboBox;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure scannerCapture(Sender: TObject);
    procedure InteractiveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure scannerLayout(sender: TObject; layout: PDCImageLayout);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    CapaChecked:boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
scanner.SelectSource;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
case PixelType.ItemIndex of
  0 : scanner.PixelType:=ptDefault;
  1 : scanner.PixelType:=ptBW;
  2 : scanner.PixelType:=ptGray;
  3 : scanner.PixelType:=ptRGB;
  4 : scanner.PixelType:=ptPalette;
  end;  { case }
case BDReduction.ItemIndex of
  0 : scanner.BDReduction:=bdrDefault;
  1 : scanner.BDReduction:=bdrThreshold;
  2 : scanner.BDReduction:=bdrHalftone;
  3 : scanner.BDReduction:=bdrDiffusion;
  end;  { case }
case BitDepth.ItemIndex of
  0 : scanner.BitDepth:=bdDefault;
  1 : scanner.BitDepth:=bd1;
  2 : scanner.BitDepth:=bd2;
  3 : scanner.BitDepth:=bd4;
  4 : scanner.BitDepth:=bd8;
  5 : scanner.BitDepth:=bd10;
  6 : scanner.BitDepth:=bd12;
  end;  { case }
case resolution.ItemIndex of
   0 : scanner.XRes:=0;
   1 : scanner.XRes:=25;
   2 : scanner.XRes:=50;
   3 : scanner.XRes:=75;
   4 : scanner.XRes:=100;
   5 : scanner.XRes:=150;
   6 : scanner.XRes:=200;
   7 : scanner.XRes:=300;
   8 : scanner.XRes:=400;
   9 : scanner.XRes:=500;
  10 : scanner.XRes:=600;
  end;  { case }
case resolution.ItemIndex of
   0 : scanner.YRes:=0;
   1 : scanner.YRes:=25;
   2 : scanner.YRes:=50;
   3 : scanner.YRes:=75;
   4 : scanner.YRes:=100;
   5 : scanner.YRes:=150;
   6 : scanner.YRes:=200;
   7 : scanner.YRes:=300;
   8 : scanner.YRes:=400;
   9 : scanner.YRes:=500;
  10 : scanner.YRes:=600;
  end;  { case }
scanner.acquire(interactive.checked);
end;

procedure TForm1.scannerCapture(Sender: TObject);
begin
image.picture.assign(scanner.picture);
end;

procedure TForm1.InteractiveClick(Sender: TObject);
begin
setup.visible:=not interactive.checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
CapaChecked:=false;
PixelType.ItemIndex  :=0;
BDReduction.ItemIndex:=0;
BitDepth.ItemIndex   :=0;
resolution.ItemIndex :=2;
end;

procedure TForm1.scannerLayout(sender: TObject; layout: PDCImageLayout);
begin
Layout^.frame.right .whole:=Layout^.frame.right .whole;
Layout^.frame.right .frac :=0;
Layout^.frame.bottom.whole:=Layout^.frame.bottom.whole div 3;
Layout^.frame.bottom.frac :=0;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
if not CapaChecked then
  begin
  if scanner.BitDepth   =bdNotSupported  then BitDepth   .enabled:=false;
  if scanner.BDReduction=bdrNotSupported then BDReduction.enabled:=false;
  if scanner.PixelType  =ptNotSupported  then PixelType  .enabled:=false;
  CapaChecked:=true;
  end;  { if }
end;

end.
