#include <windows.h>
#include <windowsx.h>

static WNDPROC  oldListProc;

LRESULT CALLBACK _export DragListProc(HWND hwnd,
            UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static int  anchorIndex;
    LRESULT     lResult;

    lResult = CallWindowProc((FARPROC) oldListProc, hwnd,
                    uMsg, wParam, lParam);

    switch(uMsg) {
        case WM_LBUTTONDOWN:
            if (GetCapture() == hwnd)
                anchorIndex = ListBox_GetCurSel(hwnd);
            else
                anchorIndex = -1;
            break;
        case WM_LBUTTONUP:
            if (anchorIndex >= 0) {
                MoveSelection(hwnd, anchorIndex);
                anchorIndex = -1;
            }
            break;
        case WM_MOUSEMOVE:
        case 0x0118:            /* undocumented: WM_SYSTIMER */
            if (anchorIndex >= 0 && GetCapture() == hwnd)
                anchorIndex = MoveSelection(hwnd, anchorIndex);
            break;
    }

    return(lResult);
}


/*
**  MoveSelection()
**  Compares the current selection with the anchor selection.  If
**  different, moves the anchor selection to the new position.
*/
static int MoveSelection(HWND hwnd, int anchorIndex)
{
    DWORD   itemData;
    char    copyString[255];
    int newIndex;

    newIndex = ListBox_GetCurSel(hwnd);
    if (newIndex >= 0 && newIndex != anchorIndex) {
        SetWindowRedraw(hwnd, FALSE);
        (void)ListBox_GetText(hwnd, anchorIndex, copyString);
        itemData = ListBox_GetItemData(hwnd, anchorIndex);
        (void)ListBox_DeleteString(hwnd, anchorIndex);

        (void)ListBox_InsertString(hwnd, newIndex, copyString);
        (void)ListBox_SetItemData(hwnd, newIndex, itemData);
        (void)ListBox_SetCurSel(hwnd, newIndex);
        SetWindowRedraw(hwnd, TRUE);
    } else
        newIndex = anchorIndex;

    return(newIndex);
}

