// MFC version
class CDCBuffer : public CDC
{
private:
    CDC        *m_pSrcDC;
    CBitmap    m_bmp, *m_pOldBmp;
    CRect    m_rectSrc;

public:
    CDCBuffer(CDC *pSrcDC, CRect rect)
    {
        m_pSrcDC = pSrcDC;
        m_rectSrc = rect;
        CreateCompatibleDC(m_pSrcDC);
        m_bmp.CreateCompatibleBitmap(m_pSrcDC, m_rectSrc.Width(),
                                        m_rectSrc.Height());
        m_pOldBmp = SelectObject(&m_bmp); 
    }

    ~CDCBuffer()
    {
        m_pSrcDC->BitBlt(m_rectSrc.left, m_rectSrc.top, 
                    m_rectSrc.Width(), m_rectSrc.Height(), 
                    this, 0, 0, SRCCOPY);
        SelectObject(m_pOldBmp);
    }
};


