// CDCBuffer - header file

// non-MFC version
class CHDCBuffer
{
    HDC        m_hDC, m_hSrcDC;
    HBITMAP m_hBmp, m_hOld;
    RECT    m_rect;

public:
    CHDCBuffer(HDC hSrcDC, RECT rect)
    {
        m_hSrcDC = hSrcDC;
        m_rect = rect;
        m_hDC = ::CreateCompatibleDC(m_hSrcDC);
        m_hBmp = ::CreateCompatibleBitmap(m_hSrcDC,
                            m_rect.right - m_rect.left,
                            m_rect.bottom - m_rect.top);
        m_hOld = (HBITMAP)::SelectObject(m_hDC, m_hBmp);
    }

    ~CHDCBuffer()
    {
        ::BitBlt(m_hSrcDC, m_rect.left, m_rect.top, 
                    m_rect.right - m_rect.left, 
                    m_rect.bottom - m_rect.top, 
                    m_hDC, 0, 0, SRCCOPY);
        ::SelectObject(m_hDC, m_hOld);
        DeleteObject(m_hBmp);
        DeleteDC(m_hDC);
    }

    operator HDC () {return m_hDC;}
};


