// note - make sure the multi-threaded library option
// is on in your compiler's IDE settings

#include <windows.h>
#include <process.h>
#include <stdio.h>

HANDLE beginthread_handle(
#ifdef __BORLANDC__
   void _USERENTRY (*start_address)(void *),
#else
   unsigned (__stdcall *start_address)(void *),
#endif
   unsigned stack_size,
   void *arglist )
{
   DWORD id;
   HANDLE h1 = (HANDLE)
#ifdef __BORLANDC__
        _beginthreadNT(start_address,stack_size,
                arglist,NULL,CREATE_SUSPENDED,&id);
#else
        // for Visual C++ and compatibles
        _beginthreadex(NULL,stack_size,start_address,
               arglist,CREATE_SUSPENDED,&id);
#endif
   HANDLE h2 = INVALID_HANDLE_VALUE;
   if( h1 != INVALID_HANDLE_VALUE ) {
      DuplicateHandle(GetCurrentProcess(),h1,
          GetCurrentProcess(),&h2,0,FALSE,
          DUPLICATE_SAME_ACCESS);
      ResumeThread(h1);
   }
   return h2;
}

#ifdef __BORLANDC__
void thread( void *arg )
#else
unsigned __stdcall thread( void * arg )
#endif
{
   printf("new thread called\n");
#ifndef __BORLANDC__
   return 0;
#endif
}

int main(void)
{
   HANDLE h = beginthread_handle(thread,4096,NULL);
   if(h!=INVALID_HANDLE_VALUE) {
       printf("waiting on new thread\n");
       WaitForSingleObject(h,INFINITE);
       printf("new thread is signaled\n");
       CloseHandle(h);
   }
   return 0;
}
