// This program demonstrates a virtual destructor
// problem in Borland C+ 5.01.  When I create an
// object of class base, I see the normal sequence
// of constructors.  The base class ctor is called
// first, followed by the derived class ctor. Likewise,
// when I call the destructur, the derived class is
// destroyed first, then the base class.  This is true
// even if the pointer is a pointer to the base class,
// because the destructor is a virtual destructor.
//
// Unfortunately, when I destroy an array of objects
// of type derived, the derived class destructor doesn't
// get called.  This seems bad, and in fact, Visual C++
// and other C++ compilers seem to know they need to
// call the virtual destructor, which in turn calls
// the derived class dtor.
//

#include <iostream.h>

class base
{
public:
    base ()              { cout << "base() called...  "; }
    virtual ~base ()     { cout << "~base() called\n"; }
};

class derived : public base
{
public:
    derived () : base ()     { cout << "derived() called\n"; }
    virtual ~derived ()     { cout << "~derived() called...  "; }
};

void main ()
{
    cout << "\nConstructing object...\n";
    derived *c = new derived;
    base *g = c;

    cout << "\nDestroying object...\n";
    delete g;

    cout << "\nConstructing vector...\n";
    derived *b = new derived[ 3 ];
    base *f = b;

    cout << "\nDestroying vector...\n";
    delete[] f;

}
