#include <windows.h>
#include <stdio.h>
#include "security.h"

VOID DumpAccessToken(HANDLE AccessToken)
{
    PVOID Info;
    ULONG size=1024, i;
    Dbg("________Dumping Access Token________\n"); 

    Info = malloc(size);
    if (Info == NULL) {
        return;
    }

    Dbg("_User SID_\n");
    // requires TOKEN_QUERY access
    if (GetTokenInformation(AccessToken, TokenUser,
                                    Info, size, &size)) {
        PTOKEN_USER User = (PTOKEN_USER)Info;
        DumpSid(User->User.Sid, User->User.Attributes);
    } else {
        ULONG status = GetLastError();
        // you would examine the error cause here!
    }
    Dbg("_Groups SIDs_\n");
    size = 1024;       // requires TOKEN_QUERY access
    if (GetTokenInformation(AccessToken, TokenGroups,
                                    Info, size, &size)) {
        PTOKEN_GROUPS Groups = (PTOKEN_GROUPS)Info;
        for (i = 0; i < Groups->GroupCount; i++) {
            DumpSid(Groups->Groups[i].Sid,
                        Groups->Groups[i].Attributes);
        }
    }
    Dbg("_Privileges_\n");
    size = 1024;        // requires TOKEN_QUERY access
    if (GetTokenInformation(AccessToken, TokenPrivileges,
                                    Info, size, &size)) {
        PTOKEN_PRIVILEGES Priv = (PTOKEN_PRIVILEGES)Info;
        for (i = 0; i < Priv->PrivilegeCount; i++) {
            DumpPrivilege(&Priv->Privileges[i].Luid, 
                          Priv->Privileges[i].Attributes);
        }
    }
    free(Info);

} // DumpAccessToken

VOID DumpSid(PSID Sid, DWORD Attributes)
{
    SID_NAME_USE Use;
    char szAccount[MAX_PATH], szDomain[MAX_PATH];
    ULONG size1 = MAX_PATH, size2 = MAX_PATH;

    if (LookupAccountSid(NULL, Sid, szAccount, &size1,
                                szDomain, &size2, &Use)) {        
        Dbg1("   Account = %s\n", szAccount);
        Dbg1("   Domain = %s\n", szDomain);

        if ((Attributes&SE_GROUP_MANDATORY) == SE_GROUP_MANDATORY) {
            Dbg("   Attribute: SE_GROUP_MANDATORY\n");
        }
        if ((Attributes & SE_GROUP_ENABLED_BY_DEFAULT)
                            == SE_GROUP_ENABLED_BY_DEFAULT) {
            Dbg("   Attribute: SE_GROUP_ENABLED_BY_DEFAULT\n");
        }
        if ((Attributes & SE_GROUP_ENABLED) == SE_GROUP_ENABLED) {
            Dbg("   Attribute: SE_GROUP_ENABLED\n");
        }
        if ((Attributes & SE_GROUP_OWNER) == SE_GROUP_OWNER) { 
            Dbg("   Attribute: SE_GROUP_OWNER\n");
        }
        if ((Attributes & SE_GROUP_LOGON_ID) == SE_GROUP_LOGON_ID) {
            Dbg("   Attribute: SE_GROUP_LOGON_ID\n");
        }

    } else {
        if (GetLastError() == ERROR_NONE_MAPPED) {
            Dbg("   No mapping between account name and SID IDs\n");
        } else {
            Dbg("   LookupAccountSid returned an error\n");
        }
    }
        
} // DumpSid

VOID DumpPrivilege(PLUID Luid, DWORD Attribute)
{
    char szPrivilege[MAX_PATH];
    ULONG size = MAX_PATH;
    if (LookupPrivilegeName(NULL, Luid, szPrivilege, &size)) {
        Dbg1("   Privilege: %s", szPrivilege);
        if (Attribute == 0) {
            Dbg(" (Disabled)\n");
        } else if (Attribute == SE_PRIVILEGE_ENABLED_BY_DEFAULT) {
            Dbg(" (Enabled by default)\n");
        } else if (Attribute == SE_PRIVILEGE_ENABLED) {
            Dbg(" (Enabled)\n");
        } else if (Attribute == SE_PRIVILEGE_USED_FOR_ACCESS) {
            Dbg(" (Used for Access)\n");
        } else {
            Dbg("(Undocumented)\n");
        }
    }
} // DumpPrivilege

BOOL IsUserInGroup(LPTSTR lpGroupName)
{
    HANDLE token;
    BOOL b, bFound = FALSE;
    PSID sid = NULL;
    PTOKEN_GROUPS groups;
    DWORD sidSize = 0, size = 128, i;
    SID_NAME_USE sidNameUse;
    char szDomain[128];

    if (OpenProcessToken(GetCurrentProcess(),TOKEN_QUERY,&token)) {

        b = LookupAccountName(NULL, lpGroupName, sid, &sidSize,
                              szDomain, &size, &sidNameUse);

        if (!b && GetLastError() == ERROR_INSUFFICIENT_BUFFER) {
            sid = malloc(sidSize);
            if (LookupAccountName(NULL, lpGroupName, sid, &sidSize,
                                  szDomain, &size, &sidNameUse)) {
                // retrieve group membership info for this user
                size = 0;
                b = GetTokenInformation(token, TokenGroups, NULL,
                                        0, &size);

                if (!b && GetLastError()
                                == ERROR_INSUFFICIENT_BUFFER) {
                    groups = malloc(size);
                    if (GetTokenInformation(token, TokenGroups,
                                groups, size, &size)) {
                        // compare specified group with each group
                        // that the current user is a member of
                        for (i = 0; i < groups->GroupCount; i++) {
                            if(EqualSid(groups->Groups[i].Sid,sid)){
                                bFound = TRUE;
                                break;
                            }
                        }
                    }
                    if (groups) free(groups);
                }
            }
            if (sid) free(sid);
        }
        if (token) CloseHandle(token);
    }
    return bFound;

} // IsUserInGroup

DWORD EnablePrivilege(PTSTR PrivilegeName, BOOL Enable)
{
    HANDLE token;
    DWORD status;
    TOKEN_PRIVILEGES privilege;
    LUID luid;

    if (OpenProcessToken(GetCurrentProcess(),
                         TOKEN_ADJUST_PRIVILEGES, &token)) {

        if (LookupPrivilegeValue(NULL, PrivilegeName, &luid)) {
            privilege.PrivilegeCount = 1;
            privilege.Privileges[0].Luid = luid;
            if (Enable) {
                privilege.Privileges[0].Attributes =
                                        SE_PRIVILEGE_ENABLED;
            } else {
                privilege.Privileges[0].Attributes = 0;
            }

            SetLastError(ERROR_SUCCESS);
            AdjustTokenPrivileges(token, FALSE, &privilege,
                                0, NULL, NULL);
            status = GetLastError(); 
        }
        CloseHandle(token);
    }

    return status;

} // SetPrivilege

