// Base class for iterators
template<class T>
class Iterator
{
public:
    virtual BOOL Done() const=0;
    virtual void Start()=0;
    virtual void Next()=0;
    virtual T Item()=0;
    virtual ~Iterator() {};
};

// CArray iterator object
template<class TYPE, class ARG_TYPE>
class ArrayIterator : public Iterator<TYPE>
{
private:
    typedef CArray<TYPE,ARG_TYPE> Array;
    Array &m_Array;
    int m_NextItem;
public:
    ArrayIterator(Array &Ar) : m_Array(Ar) {m_NextItem=0;}
    void Start()        {m_NextItem=0;}
    BOOL Done() const    {return m_Array.GetSize()==m_NextItem;}
    void Next()            {m_NextItem++;}
    TYPE Item()            {return m_Array[m_NextItem];}
};

// CList iterator object
template<class TYPE, class ARG_TYPE>
class ListIterator : public Iterator<TYPE>
{
private:
    typedef CList<TYPE,ARG_TYPE> DataSet;
    DataSet &m_Data;
    POSITION pos;
public:
    ListIterator(DataSet &Ar) : m_Data(Ar) {pos=NULL;}
    void Start()        {pos=m_Data.GetHeadPosition();}
    BOOL Done() const        {return pos==NULL;}
    void Next()            {m_Data.GetNext(pos);}
    TYPE Item()            {return m_Data.GetAt(pos);}
};

// CMap iterator object
template<class KEY, class ARG_KEY, class VALUE, class ARG_VALUE>
class MapIterator : public Iterator<VALUE>
{
private:
    typedef CMap<KEY,ARG_KEY,VALUE,ARG_VALUE> DataSet;
    DataSet &m_Data;
    POSITION pos;
public:
    MapIterator(DataSet &Data) : m_Data(Data) {pos=NULL;}
    void Start()        {pos=m_Data.GetStartPosition();}
    BOOL Done() const        {return pos==NULL;}
    void Next()
        {
        KEY Key; VALUE Value;m_Data.GetNextAssoc(pos,Key,Value);
        }
    VALUE Item()        {POSITION temp=pos;KEY Key; VALUE
Value;m_Data.GetNextAssoc(temp,Key,Value); return Value;}
};

// Iterator creation functions
template<class TYPE, class ARG_TYPE>
ArrayIterator<TYPE,ARG_TYPE> *
CreateIterator(CArray<TYPE,ARG_TYPE> &Array)
{
    return new ArrayIterator<TYPE,ARG_TYPE>(Array);
}

template<class TYPE, class ARG_TYPE>
ListIterator<TYPE,ARG_TYPE> *
CreateIterator(CList<TYPE,ARG_TYPE> &List)
{
    return new ListIterator<TYPE,ARG_TYPE>(List);
}

template<class KEY, class ARG_KEY, class VALUE, class ARG_VALUE>
MapIterator<KEY,ARG_KEY,VALUE,ARG_VALUE>
*CreateIterator(CMap<KEY,ARG_KEY,VALUE,ARG_VALUE> &Map)
{
    return new MapIterator<KEY,ARG_KEY,VALUE,ARG_VALUE>(Map);
}

