Option Explicit

Private Const DayBias# = 109205#
'
' Bias for VB Dates -
' Derived from Abs(CDbl(#01-01-1601#)), the offset between
' Day Zero for VB dates and Day Zero for Win32 dates

Private Const mSPerDay# = 86400000#
'
' Milliseconds per day -
' Derived from 60 * 60 * 24 * 10000000 / 10000,
' which is the number of seconds per day times the number
' of 100 nanosecond ticks per second, and adjusted
' by the natural .0001 scaling of Currency variables.

Private Declare Function FileTimeToLocalFileTime Lib "kernel32" _
   (FT As Currency, LFT As Currency) As Boolean

Private Declare Function LocalFileTimeToFileTime Lib "kernel32" _
   (LFT As Currency, FT As Currency) As Boolean

Public Function DateFromFILETIME(UTCTime As Currency) As Date
   '
   ' Converts a 64-bit Win32 FILETIME, stored in
   '  and scaled by a Currency variable, into a VB
   '  Date variable.

   Dim LocalTime As Currency

   ' First convert the UTC FILETIME to a locally-biased time.
   ' If this function fails (returns False), raise an error.
   '
   If FileTimeToLocalFileTime(UTCTime, LocalTime) Then
   '
   ' Divide the result by the number of milliseconds in
   '  one day (it's already scaled by 1:10000 because it's
   '  stored in a scaled integer as a Currency variable).
   ' This gives the number of whole days, plus a fraction,
   '  since Jan 1, 1601.  Then subtract the number of days
   '  between that date and VB's base date of Dec 30, 1899.

      DateFromFILETIME = CDate((LocalTime / mSPerDay) - DayBias)
   Else
      Err.Raise 5  'Invalid Procedure Call
   End If

End Function 'DateFromFILETIME


Public Function DateToFILETIME(Adate As Double) As Currency
   '
   ' Converts a VB date (coerced to Double by this call)
   '  into a 64-bit Win32 FILETIME, using a Currency
   '  variable to hold and scale the 64-bit integer

   Dim UTCTime As Currency, LocalTime As Currency

   ' Add to the VB date, the number of days between VB's
   '  base date of Dec 30, 1899 and the Win32 base date
   '  of Jan 1, 1601.  Multiply the result by the number of
   '  milliseconds per day and store the result in a Currency
   '  variable.  Currency is scaled by 1:10000, so when Win32
   '  uses the FILETIME, it effectively multiplies it by that.
   '
   LocalTime = CCur((Adate + DayBias) * mSPerDay)

   ' Next convert the locally-biased FILETIME into UTC.
   ' If this API call fails (returns False), raise an error.
   '
   If LocalFileTimeToFileTime(LocalTime, UTCTime) Then
      DateToFILETIME = UTCTime
   Else
      Err.Raise 5  'Invalid Procedure Call
   End If

End Function 'DateToFILETIME
