/* the file is to contain some system-specific code */
#include "sysup.h"
#include "modern.h"
#include <errno.h>
#include <stdio.h>
#ifdef MSDOS
#	include <dos.h>
#	include <string.h>
#endif
#ifndef __TURBOC__
#	include <sys/types.h>
#endif
#include <sys/stat.h>
#include "define.h"

#ifdef UNIX
#	ifndef RMKDIR
int bincall(name, args)
char *name, *args;
{
   extern int fork(), execl(), wait();
   int i; register k;
   char b[24];

   if (fork() == 0) {
      (void)execl(strcat(strcpy(b, "/bin/"),     name), name, args, 0);
      (void)execl(strcat(strcpy(b, "/usr/bin/"), name), name, args, 0);
      k = -1;
   } else {
      (void)wait(&i); k = i>>8;
   }
   return k;
}
#	endif
#endif

#ifdef MSDOS
int mapumode(umode) /* UNIX file mode to DOS attributes */
{
   register mask = 0;
   if (0 == (umode & 00222)) mask |= FA_RDONLY;
   if (0 == (umode & 00555)) mask |= FA_HIDDEN;
   if (0 != (umode & 07000)) mask |= FA_SYSTEM;
   return mask;
}

int mapdattr(int dattr) /* DOS file attributes to UNIX mode */
{
   register mode = dattr & FA_LABEL ? S_IFLNK :
                   dattr & FA_DIREC ? S_IFDIR : S_IFREG;
   if (0 != (dattr & FA_SYSTEM)) mode |= 02000;
   if (0 == (dattr & FA_HIDDEN)) mode |= 00444;
   if (0 == (dattr & FA_RDONLY)) mode |= 00222;
   return mode;
}

static long ftime2unix(register unsigned short *dt)
{
   struct date d; struct time t;
   d.da_year = (dt[1] >> 9) + 1980;
   d.da_mon  = (dt[1] >> 5) & 15;
   d.da_day  =  dt[1] & 31;
   t.ti_hour =  dt[0] >> 11;
   t.ti_min  = (dt[0] >> 5) & 63;
   t.ti_sec  = (dt[0] & 31) << 1;
   t.ti_hund = 0;
   return dostounix(&d, &t);
}

void fcb2stat(struct stat *s, unsigned char *ufcbP)
{
   s->st_dev = *ufcbP;
   s->st_ino = *(short*)(ufcbP+27);
   s->st_mode = mapdattr(*(ufcbP+12));
   s->st_nlink = 1;
   s->st_uid = s->st_gid = 0;
   s->st_rdev = 0;
   s->st_size = *(long*)(ufcbP + 29);
   s->st_atime = s->st_mtime = s->st_ctime =
      ftime2unix((unsigned short*)(ufcbP + 23));
}

int _acces(char *path, int amode)
{
   register attr = lchmod(path, 0, 0);
   if (attr == -1) return -1;
   return (amode & ~7) ||
      ((amode & 3) && (attr & (FA_HIDDEN+FA_LABEL))) ||
      ((amode & 2) && (attr & (FA_SYSTEM+FA_RDONLY))) ?
         (errno=EACCES, -1) : 0;
}

int pwd(register char *dest)
{
   *dest++ = 'A' + dosgetdisk();
   *dest++ = ':';
   *dest++ = '\\';
   return lgetcurdir(0, dest);
}

int cwd(char *path)
{
   register k = hasdrive(path);
   register char *p = path;
   register char c = '\0';
   if (k) {
      if (dossetdisk(k-1)) return (errno=ENODEV, -1);
      if ('\0' == *(p += 2)) return 0;
   }
   if ((k = strlen(p)-1) > 0 && (*(p += k) == '\\' || *p == '/')) {
      c = *p; *p = '\0';
   }
   k = chdir(path);
   if (c) *p = c;
   return k;
}

int hasdrive(register char *path)
{
   register c = LC(path[0]);
   return c<'a' || c>'z' || path[1]!=':' ? 0 : c-('a'-1);
}

int fnoffset(char *path)
/* Calculate an offset to last filename element */
{
   register k;
   register char *p = hasdrive(path) ? path+2 : path;
   for (k=strlen(p); k && p[k-1]!='\\' && p[k-1]!='/';) --k;
   return (int)(p-path) + k;
}

int isarchive(s, p)
register struct stat *s; register char *p;
{
   /* The algorithm below is not perfect: cluster numbers sometimes are
    * not available (network, HPFS, NTFS) and name comparison gives no
    * guarantee (remember substed drives).
    * Some day we might want to redefine stat structure and use
    * 64-bit drive and file IDs.
    */
   if (!isfile || sa.st_dev != s->st_dev) return FALSE;
   /* Newly created archive have no any cluster, comparison useless */
   if ((sa.st_ino ==  0 && s->st_ino != -1) ||
       (sa.st_ino == -1 && s->st_ino == -1)) {
      /* no real values for both archive and tested file */
      if (archname) {
         register i = fnoffset(archname);
         if (!stricmp(archname+i, p+fnoffset(p))) {
            /* file names are the same, compare drive:directory */
            char tmp[PATHSIZE];
            /* files are stored from current dir */
            if (0 == pwd(tmp)) return !strnicmp(archname, tmp, i-1);
         }
      }
      /* if comparison fails consider the files different */
      return FALSE;
   }
   return sa.st_ino == s->st_ino;
}
#endif

long mtime(path)
char *path;
{
#ifdef MSDOS
   extern long dostounix();
   unsigned long mtm = lgetmtime(path);
   if (mtm != -1L) return ftime2unix((unsigned short*)&mtm);
#else
   struct stat st;
   if (!stat(path, &st)) return st.st_mtime;
#endif
   return -1L; /* error */
}
