#ifndef Q2_SELECT
/* QIC-02 commnad subset */
#define Q2_SELECT       0x01    /* select the drive */
#define Q2_REWIND       0x21    /* rewind tape */
#define Q2_ERASE        0x22    /* erase tape */
#define Q2_RETENSION    0x24	/* wind tape back and forth */
#define Q2_QIC11        0x26    /* select QIC-11 format */
#define Q2_QIC24        0x27    /* select QIC-24 format */
#define Q2_QIC120       0x28    /* select QIC-120 format */
#define Q2_QIC150       0x29    /* select QIC-150 format */
#define Q2_WRDATA       0x40    /* write data */
#define Q2_WRMARK       0x60    /* write file mark */
#define Q2_RDDATA       0x80    /* read data */
#define Q2_FORWARD      0x81	/* forward space block */
#define Q2_REVERSE      0x81	/* backward space block */
#define Q2_RDMARK       0xA0    /* seek forward for data mark */
#define Q2_EOD          0xA3    /* optional: seek end of data */
#define Q2_RDSTAT       0xC0    /* read status */

/* Error/status bits */
#define Q2_ERRFLAG 0x80 /* if present shows that info in byte is valid */
#define Q2_ERRMASK 0x7f

#define Q2E_POR  0x0001 /* power-on/reset occured */
#define Q2E_ERM  0x0002 /* end of recorded media */
#define Q2E_BUS  0x0004 /* bus parity error */
#define Q2E_BOM  0x0008 /* beginning of media */
#define Q2E_MBD  0x0010 /* marginal block detected */
#define Q2E_NDT  0x0020 /* no data detected */
#define Q2E_ILL  0x0040 /* illegal command */
#define Q2E_DEAD 0x0080 /* cannot get status from controller */
#define Q2E_FIL  0x0100 /* file mark detected */
#define Q2E_BNL  0x0200 /* block not located */
#define Q2E_UDA  0x0400 /* unrecoverable data error */
#define Q2E_EOM  0x0800 /* end of media */
#define Q2E_WRP  0x1000 /* write protected */
#define Q2E_DFF  0x2000 /* device fault */
#define Q2E_CNI  0x4000 /* cartridge not in place */
#define Q2E_BUSY 0x8000 /* device is not ready */

#define Q2E_HARD 0xE6E6 /* hard errors */
#define Q2E_STOP 0xE0C4 /* fatal errors */

extern char **qic02_errlist;
extern int  qic02_nerr;

#define CTE_DEAD   8
#define CTE_BUSY   16
#define CTE_CLOSED 17
#define CTE_OPENED 18
#define CTE_FAULT (-1)

#ifndef BYTE
#	define BYTE unsigned char
#endif
#ifndef WORD
#	define WORD unsigned short
#endif

struct qic02_byte_status {
   BYTE status_hi, status_lo;
   BYTE error_cnt_hi, error_cnt_lo;
   BYTE underrun_cnt_hi, underrun_cnt_lo;
};

struct qic02_word_status {
   WORD status, error_cnt, underrun_cnt;
};

struct init_data {
   WORD base_address, dma_number, irq_number;
};

#define UNUSED (WORD)~0
#endif
