/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "file.h"

#define _VERSION "v1.0"

void
main(int argc, char *argv[])
{
	char  buf[255];
	char  files[255][80];
	char  orig[80];
	int   nCount = 0, which;
	FILE *fp;

	fprintf(stderr, "torque %s Copyright (c) 1996-1997 Branislav L. Slantchev [%s]\n\n",
		_VERSION, __DATE__);

	randomize();
	if( 1 < argc && 0 != (fp = fopen(argv[1], "r")) )
	{
		fgets(buf, sizeof(buf), fp);
		while( !feof(fp) )
		{
			char *p = strrchr(buf, '\n');
			if( p ) *p = '\0';

			if( '-' == buf[0] )
			{
				if( 0 < nCount )
				{ // already have stuff
					which = rand() % nCount;
					if( file_exist(files[which]) )
					{
						file_copy(orig, files[which]);
						printf("torque: %s => %s\n", files[which], orig);
					}
					else printf("torque: '%s' does not exist\n", files[which]);
				}
				strcpy(orig, &buf[1]);
				nCount = 0;
			}
			else strcpy(files[nCount++], buf);
			fgets(buf, sizeof(buf), fp);
		}
		fclose(fp);
	}
	else
	{
		puts("torque: must specify 'switch' file name");
	}
}
