/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include <ctype.h>
#include <string.h>
#include <conio.h>
#include "profile.h"
#include "utils.h"
#include "str.h"
#include "file.h"

#define _VERSION "v1.0"

void
main( int argc, char *argv[] )
{
	zProfile cfg;
	char     buf[1024];

	fprintf(stderr, "mkdist %s Copyright (c) 1997 Branislav L. Slantchev [%s]\n\n",
		_VERSION, __DATE__);

	if( 4 != argc ) fail("Usage: mkdist [Zip|Arj|Rar|Lha] archive listfile\n");

	cfg.Assign(argv[0], ".cfg");
	if( !cfg.Open() ) fail("Unable to read config file\n");

	switch( tolower(argv[1][0]) )
	{
		case 'z':
			strcpy(buf, cfg.ReadString(0, "ZIP"));
			break;
		case 'r':
			strcpy(buf, cfg.ReadString(0, "RAR"));
			break;
		case 'a':
			strcpy(buf, cfg.ReadString(0, "ARJ"));
			break;
		case 'l':
			strcpy(buf, cfg.ReadString(0, "LHA"));
			break;
		default:
			fail("Unknown archiver mode '%s'\n", argv[1]);
	}
	cfg.Close();

	strsrep(buf, "%ARCHIVE%", argv[2]);
	strsrep(buf, "%LIST%", argv[3]);

	if( !file_exist(argv[3]) )
	{
		fail("Response file '%s' does not exist\n", argv[3]);
	}

	if( file_exist(argv[2]) )
	{
		char tmp[80];

		file_chext(tmp, argv[2], ".BAK");
		printf("Warning: file '%s' exists, renamed to '%s'\n", argv[2], tmp);
		file_rename(argv[2], tmp);
	}

	clrscr();
	textcolor(14);
	cprintf("Spawning: %s\n\n", buf);
	system(buf);
}
