/*
 * This file is part of Utiliteez v1.00.R1
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but without any warranty; without even the implied warranty of
 * merchantability or fitness for a particular purpose. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <direct.h>
#include "file.h"
#include "utils.h"

	int
main(int argc, char **argv)
{
	char  path[81];
    char *token, *progname;
    FILE *fp;

	progname = file_name(strlwr(*argv));
    if( 1 == argc ) fail( "usage: %s keyword <data file>", progname);
    token = argv[1];

    if( 3 == argc ) strcpy(path, argv[2]);
    else strcpy(path, strcat(file_dirspec(*argv), "godir.dat"));

    if( NULL == (fp = fopen(path, "r")) )
		fail( "%s: couldn't find data file '%s'", progname, path );

	for( ;; )
	{
		char  buf[255];
		char *p;

		fgets( buf, sizeof(buf), fp );
		if( feof(fp) ) fail("%s: unable to find '%s'", progname, token);

		if( '#' == buf[0] || NULL == (p = strtok(buf, " \t")) ) continue;

		if( 0 == stricmp(p, token) )
		{
			if( NULL == (p = strtok(NULL, " \t\n")) )
				fail("%s: path not defined for '%s'", progname, token);
			if( 0 != _chdrive(toupper(*p) - '@') )
				fail("%s: drive not ready - '%s:'", progname, *p);
			if( -1 == file_chdir(p) )
				fail("%s: invalid path '%s'", progname, p);
			break;
		}
	}

	fclose(fp);
	return 0;
}
