/*
 * FidoNet(tm) Address Parsing Class (full support for 5D format)
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/
#include "fidoaddr.h"
#include <iostream.h>

ostream&
operator<<(ostream &os, const fido_address &fido)
{
	char buf[512];

	os << fido.merge5d(buf);
	return os;
}

void
main()
{
	char buf[512];

	// several different constructors
	fido_address a1;
	fido_address a2(1, 383, 47, 2);
	fido_address a3(1, 383, 47, 2, "fidonet.org");
	fido_address a4(a3);
	fido_address a5("1:383/47.2@fidonet.org");

	// check all constructors
	cout << "expected                  result" << endl;
	cout << "0:0/0.0                   " << a1 << endl;
	cout << "1:383/47.2                " << a2 << endl;
	cout << "1:383/47.2@fidonet.org    " << a3 << endl;
	cout << "1:383/47.2@fidonet.org    " << a4 << endl;
	cout << "1:383/47.2@fidonet.org    " << a5 << endl;

	// assignment operator
	a1 = a2;
	cout << "1:383/47.2                " << a1 << endl;
	a1 = a1;
	cout << "1:383/47.2                " << a1 << endl;
	a1 = a5;
	cout << "1:383/47.2@fidonet.org    " << a1 << endl;

	// different merging, with a full 5D address
	cout << "1:383/47.2@fidonet.org    " << a1.merge(buf) << endl;
	cout << "383/47                    " << a1.merge2d(buf) << endl;
	cout << "1:383/47                  " << a1.merge3d(buf) << endl;
	cout << "1:383/47.2                " << a1.merge4d(buf) << endl;

	// different address parsing
	a1.split("1:383/47.2@fidonet.org");
	cout << "1:383/47.2@fidonet.org    " << a1 << endl;

	a1.split("1:383/47@fidonet.org");
	cout << "1:383/47.0@fidonet.org    " << a1 << endl;

	a1.split("383/47.2@fidonet.org");
	cout << "0:383/47.2@fidonet.org    " << a1 << endl;

	a1.split("383/47@fidonet.org");
	cout << "0:383/47.0@fidonet.org    " << a1 << endl;

	a1.split("1:383/47.2");
	cout << "1:383/47.2                " << a1 << endl;

	a1.split("1:383/47");
	cout << "1:383/47.0                " << a1 << endl;

	a1.split("383/47.2");
	cout << "0:383/47.2                " << a1 << endl;

	a1.split("383/47");
	cout << "0:383/47.0                " << a1 << endl;

	a1.split("47.2");
	cout << "0:0/47.2                  " << a1 << endl;

	a1.split("47");
	cout << "0:0/47.0                  " << a1 << endl;
}
