/*
 * FidoNet(tm) Address Parsing Class (full support for 5D format)
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_FIDOADDR_H
#define INCLUDED_FIDOADDR_H

class fido_address
{
private:
	int  m_zone;
	int  m_net;
	int  m_node;
	int  m_point;
	char m_domain[255];

public:
	// CONSTRUCTORS
	fido_address();
	fido_address(int zone, int node, int net, int point);
	fido_address(int zone, int node, int net, int point, const char *domain);
	fido_address(const fido_address &addr);
	fido_address(const char *ascii_address);

	// MANIPULATORS
	void  set_zone(int zone);
	void  set_net(int net);
	void  set_node(int node);
	void  set_point(int point);
	void  set_domain(const char *domain);

	void  split(const char *address);

	fido_address& operator=(const fido_address& addr);

	// ACCESSORS
	int   zone() const;
	int   net() const;
	int   node() const;
	int   point() const;
	char* domain(char *buf) const;

	char* merge(char *buf) const;
	char* merge2d(char *buf) const;
	char* merge3d(char *buf) const;
	char* merge4d(char *buf) const;
	char* merge5d(char *buf) const;
};

// inline access functions
inline int
fido_address::zone() const
{
	return m_zone;
}

inline int
fido_address::net() const
{
	return m_net;
}

inline int
fido_address::node() const
{
	return m_node;
}

inline int
fido_address::point() const
{
	return m_point;
}

inline void
fido_address::set_zone(int zone)
{
	m_zone = zone;
}

inline void
fido_address::set_net(int net)
{
	m_net = net;
}

inline void
fido_address::set_node(int node)
{
	m_node = node;
}

inline void
fido_address::set_point(int point)
{
	m_point = point;
}

#endif /* INCLUDED_FIDOADDR_H */
