unit Self_pgm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus,
  wsc, ExtCtrls, StdCtrls;
const
  MaxRow = 15;
  MaxCol = 65;
type
  TSelf = class(TForm)
    MainMenu: TMainMenu;
    menuPort: TMenuItem;
    Test: TMenuItem;
    menuCOM1: TMenuItem;
    menuCOM2: TMenuItem;
    menuCOM3: TMenuItem;
    menuCOM4: TMenuItem;
    Instructions: TMenuItem;
    menuInstruct: TMenuItem;
    menuExit: TMenuItem;
    procedure IncrCol;
    procedure IncrRow;
    procedure DisplayChar(TheChar : Char);
    procedure DisplayString(Text : String);
    procedure DisplayLine(Text : String);
    procedure FormCreate(Sender: TObject);
    procedure menuCOM1Click(Sender: TObject);
    procedure menuCOM2Click(Sender: TObject);
    procedure menuCOM3Click(Sender: TObject);
    procedure menuCOM4Click(Sender: TObject);
    procedure KeyPress(Sender: TObject; var Key: Char);
    procedure InstructionsClick(Sender: TObject);
    procedure TestClick(Sender: TObject);
    procedure menuExitClick(Sender: TObject);
  
  private
    { Private declarations }
    LastChar : Char;
    Row : Integer;
    Col : Integer;
    RowBase : Integer;
    CharWidth : Integer;
    CharHeight : Integer;
    Port : Integer;
    Baud : Integer;
    Parity : Integer;
    DataBits : Integer;
    StopBits : Integer;
    ScreenBuffer : array [0..MaxRow] of string;
    BlankLine : string;
    TestText : string;
  public
    { Public declarations }
  end ;

var
  Self: TSelf;

implementation

{$R *.DFM}

procedure TSelf.IncrRow;
var
  I : Integer;
begin
  Col := 0;
  Inc(Row);
  if Row > MaxRow then
    begin
      (* scroll ScreenBuffer *)
       for I := 0 to MaxRow-1 do
          ScreenBuffer[I] := ScreenBuffer[I+1];
       ScreenBuffer[MaxRow] := '';
       (* re-display *)
       for I := 0 to MaxRow-1 do
         begin
           Canvas.TextOut(0,(I*CharHeight),ScreenBuffer[I]+BlankLine);
         end;
       (* position on last line *)
       Row := MaxRow;
       Canvas.TextOut(0,MaxRow*CharHeight,BlankLine);
       Canvas.MoveTo(0,MaxRow*CharHeight)
    end
end;

procedure TSelf.IncrCol;
begin
  Inc(Col);
  if Col > MaxCol then
    begin
      IncrRow;
    end;
end;

procedure TSelf.DisplayChar(TheChar : Char);
var
   TheString : String;
begin
   if TheChar <> Chr(10) then
     begin
       if TheChar = Chr(13) then
         begin
          IncrRow;
         end
       else
         begin
           ScreenBuffer[Row] := ScreenBuffer[Row] + TheChar;
           Canvas.TextOut((Col*CharWidth),(Row*CharHeight),''+TheChar);
           IncrCol;
         end;
     end;
end;

procedure TSelf.DisplayString(Text : String);
var
  I   : Integer;
  Len : Integer;
  S:String;
begin
  Len := Length(Text);
  if Len > 0 then
    for I := 1 to Len do
       begin
         DisplayChar(Text[I])
       end;
end;

procedure TSelf.DisplayLine(Text : String);
begin
  DisplayString(Text);
  DisplayChar(chr(13))
end;

procedure TSelf.FormCreate(Sender: TObject);
var
  I    : Integer;
  Code : Integer;
begin
  (* initialize canvas *)
  RowBase := 0;
  CharWidth := Canvas.TextWidth('A');
  CharHeight := Canvas.TextHeight('A');
  for I := 0 to MaxRow do ScreenBuffer[I] := '';
  BlankLine := '';
  for I := 0 to MaxCol do BlankLine := BlankLine + ' ';
  (* initialize parameters *)
  Port := COM1;
  Baud := Baud19200;
  Parity := NoParity;
  DataBits := WordLength8;
  StopBits := OneStopBit;
  Self.Caption := 'Selftest: COM' + Chr($31+Port);
  menuCOM1.Checked := true;
  TestText := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
end;

procedure TSelf.menuCOM1Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($31+Port);
  menuCOM1.Checked := true;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM1
end;

procedure TSelf.menuCOM2Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($32+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := true;
  menuCOM3.Checked := false;
  menuCOM4.Checked := false;
  Port := COM2
end;

procedure TSelf.menuCOM3Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($33+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := true;
  menuCOM4.Checked := false;
  Port := COM3
end;

procedure TSelf.menuCOM4Click(Sender: TObject);
begin
  Self.Caption := 'Selftest: COM' + Chr($34+Port);
  menuCOM1.Checked := false;
  menuCOM2.Checked := false;
  menuCOM3.Checked := false;
  menuCOM4.Checked := true;
  Port := COM4
end;


procedure TSelf.KeyPress(Sender: TObject; var Key: Char);
var
  Code : Integer;
begin
  Code := SioPutc(Port,Key);
end;

procedure TSelf.InstructionsClick(Sender: TObject);
begin
   DisplayLine('SELFTEST tests a single port for functionality.');
   DisplayLine('The port must terminate with a loopback adapter.');
   DisplayLine('See LOOPBACK.DOC for more information.')
end;

procedure TSelf.TestClick(Sender: TObject);
var
  Code : Integer;
  I, N : Integer;
  Loop : Integer;
  Size : Integer;
  Ch   : Char;
  Hr,Mn,ms : Word;
  Sec1,Sec2: Word;
  MaxRxQue : Integer;
  MaxTxQue : Integer;
begin
  (* initialize WSC *)
  Code := SioReset(Port,1024,1024);
  if Code < 0 then
    begin
      DisplayString(Format('Error %d: Cannot reset port',[Code]));
      exit
    end;
  (* update menu settings *)
  Code := SioBaud(Port,Baud);
  Code := SioParms(Port, Parity, StopBits);
  Code := SioDTR(Port,'S');
  Code := SioRTS(Port,'S');
  Code := SioFlow(Port,'N');
  (* display the test string *)
  Size := Length(TestText);
  DisplayString('Test string "');
  DisplayString(TestText);
  DisplayLine('"');
  (* send TestText 16 times *)
  DisplayString('  Sending: ');
  for Loop := 1 to 16 do
    begin
      DisplayString(Format('%d ',[Loop]));
      (* send test string *)
      for I := 1 to Size do Code := SioPutc(Port,TestText[i]);
    end;
  MaxRxQue := SioRxQue(Port);
  MaxTxQue := SioTxQue(Port);
  DisplayLine(' ');
  (* receive echo *)
  DisplayString('Receiving: ');
  for Loop := 1 to 16 do
    begin
      DisplayString(Format('%d ',[Loop]));
      (* get response *)
      for N := 1 to Size do
        begin
          (* expect character Ch *)
          Ch := TestText[N];
          DecodeTime(Time,Hr,Mn,Sec1,ms);
          (* get next incoming character *)
          repeat
            (* fetch serial character *)
            Code := SioGetc(Port);
            if Code >= 0 then
              begin
                (* is it the character expected? *)
                if Ch <> char(code) then
                  begin
                    DisplayLine(Format('Expected %c not %c',[Ch,chr(Code)]));
                    Code := SioDone(Port);
                    Application.Terminate
                  end
              end
            (* no incoming character *)
            else DecodeTime(Time,Hr,Mn,Sec2,ms);
          until (Code>0) or (Sec2 = (Sec1 + 2) mod 60);
          (* did we time out? *)
          if Code < 0 then
            begin
              DisplayLine('Timed out waiting for serial input');
              Code := SioDone(Port);
              Application.Terminate
            end
        end
    end;
  DisplayLine(' ');
  DisplayLine(Format('RX queue size = %d',[MaxRxQue]));
  DisplayLine(Format('TX queue size = %d',[MaxTxQue]));
  SioRxClear(Port);
  (* close down *)
  DisplayLine('Shutting down COM port');
  Code := SioDone(Port)
end;

procedure TSelf.menuExitClick(Sender: TObject);
var
  Code : Integer;
begin
  Code := SioDone(Port);
  Application.Terminate;
end;

end.
