Unit RegCodeU;

Interface

Uses Messages,
     SysUtils,
     Graphics,
     Forms,
     Dialogs,
     StdCtrls,
     Buttons,
     RegCodeT, Controls, Classes;

Type
  TForm1         =
    Class(TForm)
      CodeBox    :  TEdit;
      NameBox    :  TEdit;
      GenCodeBox :  TEdit;
      FileNameBox:  TEdit;
      Label1     :  TLabel;
      Label2     :  TLabel;
      Label3     :  TLabel;
      Label4     :  TLabel;
      Label5     :  TLabel;
      BitBtn1    :  TBitBtn;
      BitBtn2    :  TBitBtn;
      UseFileKey :  TCheckBox;
      Procedure BitBtn1Click(Sender:TObject);
      Procedure BitBtn2Click(Sender:TObject);
      Procedure UseFileKeyClick(Sender:TObject);
    End;

Var
  Form1          :  TForm1;

Function WriteCode(Name,Code:String) : Boolean;

Implementation

{$R REGCODEU.DFM}

Procedure TForm1.BitBtn1Click(Sender:TObject);
Var
  MakeFileKey    :  Boolean;
Begin
  If (Length(NameBox.Text) = 0) Or (Length(GenCodeBox.Text) = 0) Then
    Begin
      ShowMessage('You must enter a Name and a Generation code.');
      Exit;
    End;
  If (UseFileKey.Checked <> False) Then
    Begin
      If FileExists(FileNameBox.Text) Then
        DeleteFile(FileNameBox.Text);
      MakeFileKey:=CreateFileKey(FileNameBox.Text,NameBox.Text,GenCodeBox.Text);
      If MakeFileKey = True Then
        CodeBox.Text:='KeyFile Created'
      Else
        CodeBox.Text:='FAILURE!';
    End
  Else
    CodeBox.Text:=CreateUserKey(NameBox.Text,GenCodeBox.Text);
  If WriteCode(NameBox.Text,CodeBox.Text) <> True Then
    ShowMessage('Error! Could not write to the log file (RCUSER.DAT)');
End;

Procedure TForm1.BitBtn2Click(Sender: TObject);
Begin
  Close;
End;

Procedure TForm1.UseFileKeyClick(Sender: TObject);
Begin
  If UseFileKey.Checked <> False Then
    Begin
      FileNameBox.Enabled:=True;
      FileNameBox.Color:=ClWindow;
    End
  Else
    Begin
      FileNameBox.Enabled:=False;
      FileNameBox.Color:=ClInactiveBorder;
    End;
End;

Function WriteCode(Name,Code:String) : Boolean;
Var
  S              :  String;
  P              :  Pointer;
  X              :  Byte;
  Fh1            :  File;
Begin
  WriteCode:=False;
  AssignFile(Fh1,'RCUSER.TXT');
  If FileExists('RCUSER.TXT') Then
    Reset(Fh1,1)
  Else
    ReWrite(Fh1,1);
  Seek(Fh1,FileSize(Fh1));
  S:=DateToStr(Date);
  For X:=1 To 5 Do
    S:=S+' ';
  S:=TimeToStr(Time);
  For X:=1 To 5 Do
    S:=S+' ';
  S:=S+Name;
  For X:=1 To 5 Do
    S:=S+' ';
  S:=S+Code;
  P:=Pointer(S);
  BlockWrite(Fh1,P^,Length(S));
  Close(Fh1);
  WriteCode:=True;
  ShowMessage('Code created, and stored to the log file. (RCUSER.TXT)');
End;

End.