{$A+,B-,C-,D+,E-,F-,G+,H+,I+,J+,K-,L+,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}
{$APPTYPE GUI}
unit Test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB, StdCtrls, qiField, qiQuery, qiFormat, qiFilter, qiLookup,
  qiOrder, qiFldsEd, qiTblsEd, qiJnsEd, ExtCtrls, Buttons, qiClrsEd, 
  qiSelect, qiGroup, MemoDlg, qiArchiv, qiWdw, qiFrBldr;

type
  TTestForm = class(TForm)
    LookupValueEdit: TEdit;
    Orders: TTable;
    LookupFieldEdit: TEdit;
    SQLMemo: TMemo;
    UserMemo: TMemo;
    Label2: TLabel;
    Label3: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Customers: TTable;
    CustomersCustNo: TFloatField;
    CustomersCompany: TStringField;
    CustomersAddr1: TStringField;
    CustomersAddr2: TStringField;
    CustomersCity: TStringField;
    CustomersState: TStringField;
    CustomersZip: TStringField;
    CustomersCountry: TStringField;
    CustomersPhone: TStringField;
    CustomersFAX: TStringField;
    CustomersTaxRate: TFloatField;
    CustomersContact: TStringField;
    CustomersLastInvoiceDate: TDateTimeField;
    ExecuteBtn: TButton;
    OrdersOrderNo: TFloatField;
    OrdersCustNo: TFloatField;
    OrdersSaleDate: TDateTimeField;
    OrdersShipDate: TDateTimeField;
    OrdersEmpNo: TIntegerField;
    OrdersShipToContact: TStringField;
    OrdersShipToAddr1: TStringField;
    OrdersShipToAddr2: TStringField;
    OrdersShipToCity: TStringField;
    OrdersShipToState: TStringField;
    OrdersShipToZip: TStringField;
    OrdersShipToCountry: TStringField;
    OrdersShipToPhone: TStringField;
    OrdersShipVIA: TStringField;
    OrdersPO: TStringField;
    OrdersTerms: TStringField;
    OrdersPaymentMethod: TStringField;
    OrdersItemsTotal: TCurrencyField;
    OrdersTaxRate: TFloatField;
    OrdersFreight: TCurrencyField;
    OrdersAmountPaid: TCurrencyField;
    TablesBtn: TButton;
    FieldsBtn: TButton;
    ColorsBtn: TButton;
    FilterBtn: TButton;
    SortBtn: TButton;
    LookupBtn: TButton;
    SelectBtn: TButton;
    GroupBtn: TButton;
    EditBtn: TButton;
    JoinsBtn: TButton;
    BuildBtn: TButton;
    LoadBtn: TButton;
    StoreBtn: TButton;
    CloseBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FilterBtnClick(Sender: TObject);
    procedure LookupBtnClick(Sender: TObject);
    procedure SortBtnClick(Sender: TObject);
    procedure FieldsBtnClick(Sender: TObject);
    procedure ColorsBtnClick(Sender: TObject);
    procedure TablesBtnClick(Sender: TObject);
    procedure SelectBtnClick(Sender: TObject);
    procedure ExecuteBtnClick(Sender: TObject);
    procedure GroupBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure JoinsBtnClick(Sender: TObject);
    procedure LoadBtnClick(Sender: TObject);
    procedure StoreBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure BuildBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDblClick(Sender: TObject);
  private
    FieldInfo: TFieldInfo;
    QueryInfo: TQueryInfo;
    Formatter: TQIFormatter;
    SelectDlg: TQISelectDialog;
    FilterDlg: TQIFilterDialog;
    LookupDlg: TQILookupDialog;
    SortDlg:   TQIOrderDialog;
    GroupDlg:  TQIGroupDialog;
    EditDlg:   TMemoDialog;
    QueryWdw:  TQIQueryWindow;
    Archiver:  TQIArchiver;
    FilterBldr: TQIFilterBuilder;
    procedure QueryInfoChange(Sender: TObject);
  end;

var
  TestForm: TTestForm;

implementation

{$R *.DFM}

procedure TTestForm.FormCreate(Sender: TObject);
begin
  FieldInfo := TFieldInfo.Create(Self);
  with FieldInfo do begin
    DatabaseName := 'DBDEMOS';
    Tables.AddFromTable(Customers);
    Tables.AddFromTable(Orders);
    with Fields do begin
      AddFromField(CustomersCustNo).UserName := 'Customer#';
      AddFromField(CustomersCompany);
      AddFromField(CustomersAddr1).UserName := 'Address';
      AddFromField(CustomersCity);
      AddFromField(OrdersOrderNo).UserName := 'Order#';
      AddFromField(OrdersCustNo).FieldUsage := [];     {only incl for join}
      AddFromField(OrdersAmountPaid);
      AddFrom('Commission', '', 'ORDERS.AmountPaid * 0.125',
        Tables.ByTableRef(Orders), ftCurrency,
        [fuSelect, fuCalc, fuFilter, fuGroup, fuOrder, fuLookup], nil);
      AddFromField(OrdersPaymentMethod);
      AddFromField(OrdersSaleDate);
    end;
    Joins.AddFrom(Fields[0], Fields[5], qoEquals);
  end;
  QueryInfo := TQueryInfo.Create(Self);
  QueryInfo.FieldInfo := FieldInfo;
  QueryInfo.OnChange := QueryInfoChange;
  Formatter := TQIFormatter.Create(Self);
  Formatter.QueryInfo := Self.QueryInfo;
  SelectDlg := TQISelectDialog.Create(Self);
  SelectDlg.QueryInfo := Self.QueryInfo;
  SelectDlg.OnGrouping := GroupBtnClick;
  SelectDlg.Aggregates.Ave := False;
  FilterDlg := TQIFilterDialog.Create(Self);
  FilterDlg.QueryInfo := Self.QueryInfo;
  FilterDlg.OnOrdering := SortBtnClick;
  LookupDlg := TQILookupDialog.Create(Self);
  LookupDlg.QueryInfo := Self.QueryInfo;
  SortDlg := TQIOrderDialog.Create(Self);
  SortDlg.QueryInfo := QueryInfo;
{ SortDlg.AscArrowColor := clBlue;}
  GroupDlg := TQIGroupDialog.Create(Self);
  GroupDlg.QueryInfo := QueryInfo;
  EditDlg := TMemoDialog.Create(Self);
  EditDlg.Caption := 'SQL Script Editor';
  QueryWdw := TQIQueryWindow.Create(Self);
  with QueryWdw do begin
    QueryInfo := Self.QueryInfo;
    RequestLive := False;
{   OnSelect := SelectBtnClick;
    OnFilter := FilterBtnClick;
    OnOrder  := SortBtnClick;
    OnEdit := EditBtnClick;
    OnLoad := EditBtnClick;
    OnSave := EditBtnClick;
    OnLookup := EditBtnClick;
    OnFindNext := EditBtnClick;
    OnPrint := EditBtnClick;
    OnReport := EditBtnClick;}
  end;
  Archiver := TQIArchiver.Create(Self);
  with Archiver do begin
    QueryInfo := Self.QueryInfo;
    KeepOpen := True;
    Browse := False;
    StoreFields := True;
  end;
  FilterBldr := TQIFilterBuilder.Create(Self);
  FilterBldr.QueryInfo := Self.QueryInfo;
  FilterBldr.OnOrdering := SortBtnClick;
  QueryInfoChange(nil);
end;

{Note that the following three procedures invoke what are really
 design time only property editors - eg. EditFields invokes the Fields
 property editor. A runtime editor itself should call ChangeNotify if
 the edit is applied, passing the list that was edited. See ChangeNotify
 in qiField.hlp & qiQuery.hlp}

procedure TTestForm.FieldsBtnClick(Sender: TObject);
begin
  if EditFields(FieldInfo) then
    FieldInfo.ChangeNotify(FieldInfo.Fields);
end;

procedure TTestForm.TablesBtnClick(Sender: TObject);
begin
  if EditTables(FieldInfo) then
    FieldInfo.ChangeNotify(FieldInfo.Tables);
end;

procedure TTestForm.JoinsBtnClick(Sender: TObject);
begin
  if EditJoins(FieldInfo) then
    FieldInfo.ChangeNotify(FieldInfo.Joins);
end;

procedure TTestForm.SelectBtnClick(Sender: TObject);
begin
  SelectDlg.Execute;
end;

procedure TTestForm.FilterBtnClick(Sender: TObject);
begin
  FilterDlg.Execute;
end;

procedure TTestForm.SortBtnClick(Sender: TObject);
begin
  SortDlg.Execute;
end;

procedure TTestForm.GroupBtnClick(Sender: TObject);
begin
  GroupDlg.Execute;
end;

procedure TTestForm.EditBtnClick(Sender: TObject);
begin
  EditDlg.Execute(SQLMemo.Lines);
end;

procedure TTestForm.LookupBtnClick(Sender: TObject);
begin
  if LookupDlg.Execute then
    with QueryInfo.Lookup do begin
      LookupValueEdit.Text := Value;
      LookupFieldEdit.Text := Field.SQLName;
    end;
end;

procedure TTestForm.LoadBtnClick(Sender: TObject);
begin
  Archiver.Load;
end;

procedure TTestForm.StoreBtnClick(Sender: TObject);
begin
  Archiver.Store('', UserMemo.Lines);
end;

procedure TTestForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TTestForm.BuildBtnClick(Sender: TObject);
begin
  FilterBldr.Execute;
end;

procedure TTestForm.ColorsBtnClick(Sender: TObject);
begin
  FilterColorsForm := TFilterColorsForm.Create(Self);
  with FilterColorsForm do
  try
    Colors := FilterBldr.Colors;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TTestForm.ExecuteBtnClick(Sender: TObject);
begin
  with QueryWdw do begin
    SQLScript.Assign(SQLMemo.Lines);
{   DisplayScript.Assign(UserMemo.Lines);}
    Show;
    ExecuteQuery;
  end;
end;

procedure TTestForm.QueryInfoChange(Sender: TObject);
begin
  Formatter.BuildSQLQuery(SQLMemo.Lines);
  Formatter.BuildUserQuery(UserMemo.Lines);
end;

procedure TTestForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Formatter.Free;
  SelectDlg.Free;
  FilterDlg.Free;
  LookupDlg.Free;
  SortDlg.Free;
  GroupDlg.Free;
  EditDlg.Free;
  QueryWdw.Free;
  Archiver.Free;
  FilterBldr.Free;
  QueryInfo.Free;
  FieldInfo.Free;
end;

procedure TTestForm.FormDblClick(Sender: TObject);
begin
  QueryWdw.GetFormImage;
end;

end.
