unit Page2_1;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PGDsgFrm, StdCtrls, PGSubCls, ExtCtrls;

type
  TFormPage2_1 = class(TForm)
    CaptionBar: TPGCaptionBar;
    CaptionBarLabel: TPGCaptionBarGlyph;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Image1: TImage;
    HeightComboBox: TComboBox;
    GroupBox2: TGroupBox;
    TileComboBox: TComboBox;
    Label2: TLabel;
    Image2: TImage;
    Button1: TButton;
    Label7: TLabel;
    Panel4: TPanel;
    Image3: TImage;
    TransparentColorButton: TPanel;
    Label3: TLabel;
    ActiveColorButton: TPanel;
    Label4: TLabel;
    InactiveColorButton: TPanel;
    ColorDialog: TColorDialog;
    PGCaptionBarSystemButton1: TPGCaptionBarSystemButton;
    Label5: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    procedure HeightComboBoxChange(Sender: TObject);
    procedure TileComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TransparentColorButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ActiveColorButtonClick(Sender: TObject);
    procedure InactiveColorButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormPage2_1: TFormPage2_1;

implementation

uses Main;

{$R *.DFM}

procedure TFormPage2_1.HeightComboBoxChange(Sender: TObject);
begin
  CaptionBar.Height := HeightComboBox.ItemIndex + 10;
end;

procedure TFormPage2_1.TileComboBoxChange(Sender: TObject);
  procedure LoadTile(BmpFile: string; C1,C2,C3,C4: TColor; AHeight: Integer);
  begin
    { Load the graphic that corresponds to the newly selected tile. }
    BmpFile := PGFullFilename(BmpFile);
    CaptionBar.BeginUpdate;
    CaptionBar.Picture.LoadFromFile(BmpFile);

    { Make the graphic display nicely be setting it's color's }
    CaptionBar.TransparentColor := C1;
    CaptionBar.ActiveColor := C2;
    CaptionBar.InactiveColor := C3;
    CaptionBar.Height := AHeight;
    CaptionBarLabel.Font.Color := C4;
    CaptionBar.EndUpdate;
    CaptionBar.Refresh;

    { Reflect the changes to the caption bar component in the dialog. }
    HeightComboBox.ItemIndex := CaptionBar.Height - 10;
    TransparentColorButton.Color := C1;
    ActiveColorButton.Color := C2;
    InactiveColorButton.Color := C3;
  end;
begin
(*
Red Maze
Blue Gradient
Black Saturn
Green Mesh
Blue Night
Red Ripples
Bricks
Blue Pool
*)
  case TileComboBox.ItemIndex of
    0: LoadTile('TILE1.BMP', clRed, clRed, clBlack, clWhite, 28);
    1: LoadTile('TILE2.BMP', clGray, clBlue, clGray, clWhite, 28);
    2: LoadTile('TILE3.BMP', clPurple, clPurple, clGray, clWhite, 28);
    3: LoadTile('TILE4.BMP', clBlue, clGreen, clGray, clWhite, 28);
    4: LoadTile('TILE5.BMP', clGray, clBlack, clGray, clWhite, 28);
    5: LoadTile('TILE6.BMP', clBlack, clRed, clBlack, clWhite, 28);
    6: LoadTile('TILE7.BMP', clBlack, clBlack, clGray, clWhite, 28);
    7: LoadTile('TILE8.BMP', clBlue, clBlue, clBlack, clWhite, 28);
  else
    LoadTile('TILE' + IntToStr(TileComboBox.ItemIndex + 1) + '.BMP', clBlack, clBlack, clGray, clWhite, 28);
  end;
end;

procedure TFormPage2_1.FormCreate(Sender: TObject);
begin
  TileComboBox.ItemIndex := 0;
  TileComboBoxChange(Self);
end;

procedure TFormPage2_1.TransparentColorButtonClick(Sender: TObject);
begin
  ColorDialog.Color := TransparentColorButton.Color;
  if not ColorDialog.Execute then
    exit;

  TransparentColorButton.Color := ColorDialog.Color;
  CaptionBar.TransparentColor := ColorDialog.Color;
end;

procedure TFormPage2_1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormPage2_1.ActiveColorButtonClick(Sender: TObject);
begin
  ColorDialog.Color := ActiveColorButton.Color;
  if not ColorDialog.Execute then
    exit;

  ActiveColorButton.Color := ColorDialog.Color;
  CaptionBar.ActiveColor := ColorDialog.Color;
end;

procedure TFormPage2_1.InactiveColorButtonClick(Sender: TObject);
begin
  ColorDialog.Color := InactiveColorButton.Color;
  if not ColorDialog.Execute then
    exit;

  InactiveColorButton.Color := ColorDialog.Color;
  CaptionBar.InactiveColor := ColorDialog.Color;
end;

end.
