unit PGDsgReg;

interface

uses DsgnIntf,

{$IFDEF VER80}
  LibMain, LibIntf,
{$ENDIF}

WinProcs;


procedure Register;


implementation

uses PGDsgFrm, PGDsgFm1, Classes, Controls, Dialogs, SysUtils, Forms;

{$IFDEF VER80}
  {$R PGDSG16.DCR}
{$ELSE}
  {$R PGDSG32.DCR}
{$ENDIF}


type
  { TPGCaptionBarEditorBase }
  TPGCaptionBarEditorBase = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    procedure SelectComponentAtDesignTime(AComponent: TComponent);
    procedure CreateCaptionBarAtDesignTime;
  end;

  { TPGCaptionBarComponentEditor }
  TPGCaptionBarComponentEditor = class(TPGCaptionBarEditorBase);

  { TPGCaptionBarEditor }
  TPGCaptionBarEditor = class(TPGCaptionBarEditorBase)
  private
    procedure Edit; override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure ConfirmDeleteOfCaptionBar;
    procedure ConfirmSetLargeHeight;
    procedure ConfirmSetLargerWidth;
    procedure NotifyAutosizeButtons;
    procedure NotifyTransparentColorProblem;
  end;

  TPGDesignerFormOptionsPropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

function ModifyCaptionBarOptions(CapBar: TPGCaptionBar):Boolean;
  procedure CheckOption(AnOption: TPGCaptionBarOption; IncludeOption: Boolean);
  begin
    Result := Result or ((AnOption in CapBar.Options) <> IncludeOption);
    if IncludeOption then
      CapBar.Options := CapBar.Options + [AnOption]
    else
      CapBar.Options := CapBar.Options - [AnOption]
  end;
var
  AForm: TCaptionBarOptionsForm;
begin
  { Assume that no modifications will be made. }
  Result := false;
  AForm := nil;

  try
    AForm := TCaptionBarOptionsForm.Create(Application);
    AForm.ButtonsSameWidthCheck.Checked := (cboButtonsSameWidth in CapBar.Options);
    AForm.ButtonsSameHeightCheck.Checked := (cboButtonsSameHeight in CapBar.Options);
    AForm.ButtonsAutosizeCheck.Checked := (cboButtonsAutosize in CapBar.Options);
    AForm.ActiveAtDesignTimeCheck.Checked := (cboDesignTimeActive in CapBar.Options);
    AForm.DesignTimeEnhancementsCheck.Checked := (cboDesignTimeEnhancements in CapBar.Options);
    AForm.ShowDesignTimeTipsCheck.Checked := (cboDesignTimeTips in CapBar.Options);
    AForm.AutosizeCaptionBarCheck.Checked := (cboCaptionBarAutosize in CapBar.Options);

    AForm.ShowModal;
    if AForm.ModalResult = mrOk then
      begin
      CheckOption(cboButtonsSameWidth, AForm.ButtonsSameWidthCheck.Checked);
      CheckOption(cboButtonsSameHeight, AForm.ButtonsSameHeightCheck.Checked);
      CheckOption(cboButtonsAutosize, AForm.ButtonsAutosizeCheck.Checked);
      CheckOption(cboDesignTimeActive, AForm.ActiveAtDesignTimeCheck.Checked);
      CheckOption(cboDesignTimeEnhancements, AForm.DesignTimeEnhancementsCheck.Checked);
      CheckOption(cboDesignTimeTips, AForm.ShowDesignTimeTipsCheck.Checked);
      CheckOption(cboCaptionBarAutosize, AForm.AutosizeCaptionBarCheck.Checked);
      end;
  finally
    AForm.Free;
  end;
end;

{ TPGCaptionBarComponentEditorBase }
procedure TPGCaptionBarEditorBase.ExecuteVerb(Index: Integer);
begin
  case Index of
    dta_SelectComponentAtDesignTime: SelectComponentAtDesignTime(Component);
    dta_CreateCaptionBarAtDesignTime: CreateCaptionBarAtDesignTime;
  else
    inherited ExecuteVerb(Index);
  end;
end;

procedure TPGCaptionBarEditorBase.SelectComponentAtDesignTime(AComponent: TComponent);
begin
  {$IFDEF VER80}
  try
    CompLib.GetActiveForm.SetSelection(AComponent.Name);
  except
    ;
  end;
  {$ENDIF}
end;

procedure TPGCaptionBarEditorBase.CreateCaptionBarAtDesignTime;
{$IFDEF VER80}
var
  AForm: TLibForm;
  ACompClass: TICompClass;
  ACompClassCount: Integer;
  i: Integer;
begin
  AForm := TLibForm(CompLib.GetActiveForm);
  ACompClassCount := Complib.GetCompClassCount - 1;
  for i := ACompClassCount downto 0 do
    begin
    ACompClass := CompLib.GetCompClass(i);
    if ACompClass.GetClassName = 'TPGCaptionBar' then
      begin
      AForm.CreateComponent(ACompClass);
      break;
      end;
    end;
end;
{$ELSE}
begin
end;
{$ENDIF}

procedure TPGCaptionBarEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: if ModifyCaptionBarOptions(TPGCaptionBar(Component)) then
        Designer.Modified;
    dta_ConfirmDeleteOfCaptionBar: ConfirmDeleteOfCaptionBar;
    dta_ConfirmSetLargeHeight: ConfirmSetLargeHeight;
    dta_ConfirmSetLargerWidth: ConfirmSetLargerWidth;
    dta_NotifyAutosizingButtons: NotifyAutosizeButtons;
    dta_NotifyTransparentColorProblem: NotifyTransparentColorProblem;
  else
    inherited ExecuteVerb(Index);
  end;
end;

procedure TPGCaptionBarEditor.Edit;
begin
  if ModifyCaptionBarOptions(TPGCaptionBar(Component)) then
    Designer.Modified;
end;

procedure TPGCaptionBarEditor.ConfirmDeleteOfCaptionBar;
const
  MsgStr: string = 'This will also delete ALL Caption Bar components !!!';
begin
  PGDesignTimeActionOk := (MessageDlg(MsgStr, mtConfirmation, mbOkCancel, 0) = mrOk);
end;

procedure TPGCaptionBarEditor.NotifyTransparentColorProblem;
var
  MsgStr: string;
begin
  MsgStr := 'The Font color and TransparentColor of this' + #10;
  MsgStr := MsgStr + 'component are the same.' + #10#10;
  MsgStr := MsgStr + 'This may make your caption invisible, since it' + #10;
  MsgStr := MsgStr + 'is being displayed in the TransparentColor.' + #10#10;
  MsgStr := MsgStr + 'You should change one of these properties to fix' + #10;
  MsgStr := MsgStr + 'this problem and allow your caption to be seen.' + #10;
  PGDesignTimeActionOk := (MessageDlg(MsgStr, mtInformation, [mbOk], 0) = mrOk);
end;

procedure TPGCaptionBarEditor.NotifyAutosizeButtons;
var
  MsgStr: string;
begin
  MsgStr := 'The Caption Bar is currently autosizing all' + #10;
  MsgStr := MsgStr + 'caption bar buttons.' + #10#10;
  MsgStr := MsgStr + 'Would you like to turn this option off' + #10;
  MsgStr := MsgStr + 'and set this buttons height ?' + #10;
  PGDesignTimeActionOk := (MessageDlg(MsgStr, mtConfirmation, [mbYes,mbNo], 0) = mrYes);
end;

procedure TPGCaptionBarEditor.ConfirmSetLargeHeight;
const
  MsgStr: string = 'Are you sure you want to set this large of a height ???';
begin
  PGDesignTimeActionOk := (MessageDlg(MsgStr, mtConfirmation, mbOkCancel, 0) = mrOk);
end;

procedure TPGCaptionBarEditor.ConfirmSetLargerWidth;
var
  MsgStr: string;
begin
  MsgStr := 'The width of the form will have to be' + #10;
  MsgStr := MsgStr + 'increased to create this component.' + #10#10;
  MsgStr := MsgStr + 'Do you want to continue ?' + #10;
  PGDesignTimeActionOk := (MessageDlg(MsgStr, mtConfirmation, mbOkCancel, 0) = mrOk);
end;

function TPGCaptionBarEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := '&Designer ...';
    1: Result := '-';
    2: Result := 'DesignerForms 1.0';
    3: Result := 'Copyright 1996 The Programmers' + #39 + ' Guild';
  end;
end;

function TPGCaptionBarEditor.GetVerbCount: Integer;
begin
  Result := 4;
end;


function TPGDesignerFormOptionsPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paReadOnly];
end;

function TPGDesignerFormOptionsPropertyEditor.GetValue: string;
begin
  Result := '(Click here)';
end;

procedure TPGDesignerFormOptionsPropertyEditor.Edit;
begin
  ModifyCaptionBarOptions(TPGCaptionBar(GetComponent(0)));
end;


procedure Register;
begin
  RegisterComponents('Guild', [TPGCaptionBar, TPGCaptionBarButton, TPGCaptionBarGlyph,
                               TPGCaptionBarSystemButton, TPGCaptionBarRollupButton, TPGCaptionBarOnTopButton]);
  RegisterComponentEditor(TPGCaptionBar, TPGCaptionBarEditor);
  RegisterComponentEditor(TPGCaptionBarComponent, TPGCaptionBarComponentEditor);
  RegisterPropertyEditor(TypeInfo(Boolean), TPGCaptionBar, 'Designer', TPGDesignerFormOptionsPropertyEditor);
end;

end.
