unit bigmem;

interface

uses
  Winprocs, wintypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, StdCtrls, Buttons, bigmemo, Mask, JWEdit, FileView;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N2: TMenuItem;
    SelectAll1: TMenuItem;
    CapitaliseText1: TMenuItem;
    Properties1: TMenuItem;
    HideSelection1: TMenuItem;
    OEMConvert1: TMenuItem;
    TabStop1: TMenuItem;
    Panel1: TPanel;
    Help1: TMenuItem;
    About1: TMenuItem;
    BigMemo1: TBigMemo;
    Panel2: TPanel;
    ModifiedStatus: TPanel;
    InsertStatus: TPanel;
    WrapModes: TRadioGroup;
    Font1: TMenuItem;
    FontDialog1: TFontDialog;
    BitBtn1: TBitBtn;
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure CapitaliseText1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure HideSelection1Click(Sender: TObject);
    procedure OEMConvert1Click(Sender: TObject);
    procedure TabStop1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BigMemo1StateChange(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure WrapModesClick(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FileName:String;
  end;

var
  Form1: TForm1;

implementation

uses about;

{$R *.DFM}

procedure TForm1.New1Click(Sender: TObject);
begin
     Bigmemo1.Clear
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
     If OpenDialog1.Execute Then
     Begin
          FileName := OpenDialog1.FileName;
          BigMemo1.Lines.LoadFromFile(FileName);
          BigMemo1.Modified := false
     End
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     Close
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
     BigMemo1.CutToClipboard
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
     BigMemo1.CopyToClipBoard
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
     BigMemo1.PasteFromClipBoard
end;

procedure TForm1.SelectAll1Click(Sender: TObject);
begin
     BigMemo1.SelectAll
end;

procedure TForm1.CapitaliseText1Click(Sender: TObject);
begin
     BigMemo1.Capitalise
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     HideSelection1.Checked := BigMemo1.HideSelection;
     OEMConvert1.Checked := BigMemo1.OEMConvert;
     TabStop1.Checked := BigMemo1.TabStop;
     WrapModes.ItemIndex := ord(BigMemo1.WrapMode);
     BigMemo1StateChange(nil)
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
     FontDialog1.Font := BigMemo1.Font;
     If FontDialog1.Execute Then
        BigMemo1.Font := FontDialog1.FOnt
end;

procedure TForm1.HideSelection1Click(Sender: TObject);
begin
     With HideSelection1 Do
     Begin
          Checked := not Checked;
          BigMemo1.HideSelection := checked
     End
end;

procedure TForm1.OEMConvert1Click(Sender: TObject);
begin
     With OEMConvert1 Do
     Begin
          Checked := not Checked;
          BigMemo1.OEMConvert := checked
     End
end;

procedure TForm1.TabStop1Click(Sender: TObject);
begin
     With TabStop1 Do
     Begin
          Checked := not Checked;
          BigMemo1.TabStop := checked;
          BigMemo1.WantTabs := checked
     End

end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     close
end;

procedure TForm1.BigMemo1StateChange(Sender: TObject);
begin
     With BigMemo1 Do
     Begin
          If Modified Then
             ModifiedStatus.Caption := 'Modified'
          Else
             ModifiedStatus.Caption := '';
          If vsInsertOn in State Then
             InsertStatus.Caption := 'Insert'
          Else
             InsertStatus.Caption := 'Overwrite';
          Cut1.Enabled := vsSelection in BigMemo1.State;
          Copy1.Enabled := vsSelection in BigMemo1.State;
          Paste1.Enabled := vsPasteAvailable in BigMemo1.State;
          SelectAll1.Enabled := not (vsEmpty in BigMemo1.State);
          CapitaliseText1.Enabled := not (vsEmpty in BigMemo1.State);
          Save1.Enabled := BigMemo1.Modified;
     End
end;

procedure TForm1.About1Click(Sender: TObject);

begin
     AboutBox.showmodal
end;

procedure TForm1.WrapModesClick(Sender: TObject);

var I, Code: integer;
    S: string;

begin
     BigMemo1.WrapMode := TWrapModes(WrapModes.ItemIndex);
     If BigMemo1.WrapMode = opAbsoluteWrap Then
     Begin
       Repeat
          S := InputBox('Absolute Wrap Mode','Enter Max Line Length',
                   Format('%d',[BigMemo1.MaxLineLength]));
          val(S,I,Code);
       Until Code = 0;
       BigMemo1.MaxLineLength := I
     End;
     ActiveControl := BigMemo1
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
     If SaveDialog1.Execute Then
         BigMemo1.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.Save1Click(Sender: TObject);

var NewFileName: string;

begin
     If Length(FileName) = 0 Then
        SaveAs1Click(Sender)
     Else
     Begin
         NewFileName := ChangeFileExt(FileName,'.$$$');
         BigMemo1.Lines.SaveToFile(NewFileName);
         DeleteFile(FileName);
         RenameFile(NewFileName,FileName);
         BigMemo1.Modified := false
     End
end;

end.
