unit Gotoline;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TGotoDialog = class(TForm)
    Options: TRadioGroup;
    GotoBookmarkList: TComboBox;
    Label1: TLabel;
    OKBtn: TBitBtn;
    GotoBtn: TBitBtn;
    BitBtn1: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure GotoBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure GotoBookmarkListClick(Sender: TObject);
    procedure GotoBookmarkListDblClick(Sender: TObject);
    procedure GotoBookmarkListChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GotoDialog: TGotoDialog;

implementation

uses bkmkdlg, sysutils, Main, Childwin;

{$R *.DFM}

procedure TGotoDialog.FormShow(Sender: TObject);
Begin
     OKBtn.Kind := bkOK

end;

procedure TGotoDialog.GotoBtnClick(Sender: TObject);

  function GetNumber(Value: string): longint;
    Var Code: integer;
  Begin
     Val(Value,Result,Code);
     If Code <> 0 Then
        raise Exception.Create('A number must be entered here')
  End;

begin
   With GotoBookmarkList Do
     With MainForm.ActiveMDIChild As TMDIChild Do
     Case Options.ItemIndex Of
     0: {Page Number}
        FileEditor1.PageNumber := GetNumber(Text);
     1: {Line Number}
        FileEditor1.EffectiveLineNumber := GetNumber(Text);
     2: {Bookmark}
     If ItemIndex >=0 Then
        TBookmark(Items.Objects[ItemIndex]).GotoBookmark;
     End;
     OKBtn.Kind := bkClose
end;

procedure TGotoDialog.FormActivate(Sender: TObject);

Var S: String;
    Number: longint;
    I: integer;

begin
     If AddBookmarkDlg.BookmarkList.Items.Count > 0 Then
     Begin
          GotoBookmarkList.Items := AddBookmarkDlg.BookmarkList.Items;
          Options.ItemIndex := 2;
          GotoBookmarkList.ItemIndex := AddBookmarkDlg.Bookmark;
     End
     Else
     Begin

         GotoBookmarkList.clear;
         If Options.ItemIndex = 2 Then Options.ItemIndex := 0;
         With MainForm.ActiveMDIChild As TMDIChild Do
         Case Options.ItemIndex Of
         0:         Number := FileEditor1.PageNumber;
         1:         Number := FileEditor1.LineNumber + 1;
         End;
         Str(Number,S);
         GotoBookmarkList.Text := S;
     End;
end;

procedure TGotoDialog.OKBtnClick(Sender: TObject);
begin
     Close;
     If OKBtn.Kind = bkOK Then
        GotoBtnClick(Sender)
end;

procedure TGotoDialog.BitBtn1Click(Sender: TObject);
begin
     Close
end;

procedure TGotoDialog.GotoBookmarkListClick(Sender: TObject);
begin
    If GotoBookmarkList.Items.Count > 0 Then
       options.ItemIndex := 2
end;

procedure TGotoDialog.GotoBookmarkListDblClick(Sender: TObject);
begin
     GotoBtnClick(Sender);
     Close
end;

procedure TGotoDialog.GotoBookmarkListChange(Sender: TObject);
begin
     With GotoBookmarkList Do
     If (Length(Text) > 0) And (Text[1] in ['0'..'9']) Then
     Begin
        If (Options.ItemIndex = 2) Then Options.ItemIndex := 0
     End
     Else
        Options.ItemIndex := 2
end;


end.
