unit Main;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,IniFiles,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Spin, Grids,
  HWCtrl, HwPort95;

type
  TMainForm = class(TForm)
    GroupBox2: TGroupBox;
    B_Read: TButton;
    B_ReadAll: TButton;
    B_Write: TButton;
    B_WriteAll: TButton;
    BitBtn3: TBitBtn;
    GroupBox3: TGroupBox;
    Label12: TLabel;
    E_Addr: TEdit;
    B_SetMemory: TButton;
    B_ReadMemory: TButton;
    B_Open: TButton;
    GRead: TStringGrid;
    MemoHex: TStringGrid;
    GWrite: TStringGrid;
    HWCtrl: TVicHW_95;
    procedure B_OpenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure GReadSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure B_WriteClick(Sender: TObject);
    procedure B_WriteAllClick(Sender: TObject);
    procedure B_ReadClick(Sender: TObject);
    procedure B_ReadAllClick(Sender: TObject);
    procedure B_SetMemoryClick(Sender: TObject);
    procedure B_ReadMemoryClick(Sender: TObject);
    procedure E_AddrChange(Sender: TObject);
  end;

const MaxPorts = 16;

var
  MainForm: TMainForm;
  F_Mess  : dWord;
  PortWSel,PortRSel:Word;
  ValWSel:Byte;
  NomWSel,NomRSel:Byte;
  PhysAddr : dWord;
  TestString : array[0..255]of Char;
  TestVar : LongInt;
type SingleData = array[1..16] of Byte;
     SegData    = array[1..16] of SingleData;
     tPointPhys =^SegData;

var  PointPhys  : tPointPhys;

implementation

{$R *.DFM}

procedure ShowButtons;
begin
  with MainForm,HwCtrl do
  begin
   if ActiveHW then B_Open.caption:='Close(unload VxD)'
               else B_Open.caption:='Open(load VxD)';
   B_Write.Enabled:=ActiveHW;
   B_Read.Enabled:=ActiveHW;
   B_WriteAll.Enabled:=ActiveHW;
   B_ReadAll.Enabled:=ActiveHW;
   B_ReadMemory.Enabled:=ActiveHW and (PointPhys<>NIL);
  end;
end;

procedure TMainForm.B_OpenClick(Sender: TObject);
begin
  if HwCtrl.ActiveHW then HwCtrl.CloseDriver
  else begin
         HwCtrl.OpenDriver;
         if not HwCtrl.ActiveHW then
         begin
           MessageBeep(0);
           Application.MessageBox('Virtual driver "HWPORT95.VXD" not found...',
                      ' Warning! ',mb_OK or mb_ICONHAND);
         end;
         B_SetMemory.Enabled:=HwCtrl.ActiveHW;
       end;
  ShowButtons;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  HwCtrl.CloseDriver;
  ShowButtons;
end;

procedure TMainForm.FormActivate(Sender: TObject);
var MyIniFile : TIniFile;
    i         : Word;
begin
 MyInifile:=TIniFile.Create('HW_test.ini');

 with MyIniFile do
 begin
  PhysAddr:=ReadInteger('misc','ADDR',$F8000);
  E_Addr.text:=IntToHex(PhysAddr,8);
  for i:=1 to MaxPorts do
  begin
    with GWrite do
    begin
      Cells[0,i]:=IntToStr(i);
      Cells[1,0]:='PORT'; Cells[2,0]:='VAL';
      Cells[1,i]:=ReadString('PortW','Port'+IntToStr(i),'');
      Cells[2,i]:=ReadString('Values','Val'+IntToStr(i),'');
    end;
    with GRead do
    begin
      Cells[0,i]:=IntToStr(i);
      Cells[1,0]:='PORT'; Cells[2,0]:='VAL';
      Cells[1,i]:=ReadString('PortR','Port'+IntToStr(i),'');
    end;
  end;
 end;
 MyIniFile.Free;
 with MemoHex do
 begin
   Cells[0,0]:='  ADDR';
   Cells[1,0]:='             HEX';
   Cells[2,0]:='     ASCII';
 end;
 ShowButtons;
end;

procedure TMainForm.BitBtn3Click(Sender: TObject);
var MyIniFile : TIniFile;
    i         : Word;
begin
 MyInifile:=TIniFile.Create('HW_test.ini');
 with MyIniFile  do
 begin
  WriteInteger('misc','ADDR',PhysAddr);
  for i:=1 to MaxPorts do
  begin
    with GWrite do
    begin
      WriteString('PortW','Port'+IntToStr(i),Cells[1,i]);
      WriteString('Values','Val'+IntToStr(i),Cells[2,i]);
    end;
    with GRead do
    begin
      WriteString('PortR','Port'+IntToStr(i),Cells[1,i]);
    end;
  end;
 end;
 MyIniFile.Free;
 Close;
end;

function HexToInt(s:String):dWord;
const hexch:array[0..15] of Char='0123456789ABCDEF';
var i,j : Byte;
    r,n,k:dWord;
    ch : Char;
begin
  k:=1; r:=0;
  for i:=Length(s) downto 1 do
  begin
    ch:=s[i]; n:=0;
    for j:=0 to 15 do if UpperCase(ch)=hexch[j] then n:=j;
    r:=r+n*k; if i>1 then k:=k*16;
  end;
  Result:=r;
end;

procedure TMainForm.GReadSelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);
begin
  with GRead do
  begin
    PortRSel:=HexToInt(Cells[1,Row]); NomRSel:=Row;
  end;
end;

procedure TMainForm.B_WriteClick(Sender: TObject);
begin
 with GWrite,HwCtrl do
 begin
   PortWSel:=HexToInt(Cells[1,Row]);    Cells[1,Row]:=IntToHex(PortWSel,4);
   ValWSel:=HexToInt(Cells[2,Row]);     Cells[2,Row]:=IntToHex(ValWSel,2);
   NomWSel:=Row;
   if (PortWSel=0) then begin MessageBeep(0); Exit; end;
   Port[PortWSel]:=ValWSel;
 end;
end;
procedure TMainForm.B_WriteAllClick(Sender: TObject);
var i,v : Byte;
    P   : Word;
begin
 with GWrite,HwCtrl do
 begin
   for i:=1 to MaxPorts do
   begin
     P:=HexToInt(Cells[1,i]); Cells[1,i]:=IntToHex(P,4);
     if p>0 then
     begin
       V:=HexToInt(Cells[2,i]); Cells[2,i]:=IntToHex(v,2);
       Port[P]:=V;
     end;
   end;
 end;
end;

procedure TMainForm.B_ReadClick(Sender: TObject);
begin
 with GRead,HwCtrl do
 begin
   PortRSel:=HexToInt(Cells[1,Row]); Cells[1,Row]:=IntToHex(PortRSel,4);
   NomRSel:=Row;
   if (PortRSel=0) then begin MessageBeep(0); Exit; end;
   Cells[2,Row]:=IntToHex(Port[PortRSel],2);
 end;
end;

procedure TMainForm.B_ReadAllClick(Sender: TObject);
var i   : Byte;
    P   : Word;
begin
 with GRead,HwCtrl do
 begin
   for i:=1 to MaxPorts do
   begin
     P:=HexToInt(Cells[1,i]); Cells[1,i]:=IntToHex(P,4);
     if p>0 then
     begin
       Cells[2,i]:=IntToHex(Port[P],2);
     end;
   end;
 end;
end;

procedure TMainForm.B_SetMemoryClick(Sender: TObject);
begin
  PhysAddr:=HexToInt(E_Addr.text); E_Addr.Text:=IntToHex(PhysAddr,8);
  with HwCtrl do  PointPhys:=SetPointerToPhysicalAddress(PhysAddr,256);
  B_SetMemory.Enabled:=FALSE;
  ShowButtons;
end;

procedure TMainForm.B_ReadMemoryClick(Sender: TObject);
var CurrAddr,i,j : dWord;
    s            : String;
    b            : Byte;
    ch           : Char;
begin
  if PointPhys<>NIL then
  begin
    CurrAddr:=PhysAddr;
    for i:=1 to 16 do
    begin
      s:=IntToHex(CurrAddr,8); MemoHex.Cells[0,i]:=s; s:='';
      for j:=1 to 16 do s:=s+IntToHex(PointPhys^[i][j],2);
      MemoHex.Cells[1,i]:=s; s:='';
      for j:=1 to 16 do
      begin
        b:=PointPhys^[i][j];
        if b>=$20 then ch:=Char(b) else ch:='.';  s:=s+ch;
      end;
      MemoHex.Cells[2,i]:=s;
      CurrAddr:=CurrAddr+16;
    end;

  end;

end;

procedure TMainForm.E_AddrChange(Sender: TObject);
begin
  B_SetMemory.Enabled:=HwCtrl.ActiveHW;;
end;

initialization

  NomWSel:=0; NomRSel:=0; PointPhys:=NIL;

end.
