// Test program for Sets by Hubert Chan
// Feb 8, 1997

// SETELEMENT should be set to unsigned char
#include "Sets.HPP"
#include <StdIO.H>

#define Test(x) (x ? "is\0" : "is not\0")

void PrintSet(Set &Set1);

void main() {
	SETELEMENT Aarray[3] = { 1,2,3 };
	Set A(3,Aarray);
	SETELEMENT Barray[3] = { 2,3,4 };
	Set B(3,Barray);
	SETELEMENT Carray[2] = { 2,3 };
	Set C(2,Carray);
	Set Tmp;
	printf("****************************************\n");
	printf("* Test program for Sets by Hubert Chan *\n");
	printf("* Last modified: Feb 8, 1997           *\n");
	printf("****************************************\n\n");
	printf("A = "); PrintSet(A);
	printf("B = "); PrintSet(B);
	printf("C = "); PrintSet(C);
	Tmp = A + B;
	printf("A U B = "); PrintSet(Tmp);
	Tmp = A * B;
	printf("A ^ B = "); PrintSet(Tmp);
	Tmp = A - B;
	printf("A - B = "); PrintSet(Tmp);
	Tmp = ~A;
	printf("~A = "); PrintSet(Tmp);
	printf("2 %s in A\n", Test(A>=2));
	printf("5 %s in A\n", Test(A>=5));
	printf("C %s a subset of A\n", Test(C<=A));
	printf("C %s a proper subset of A\n", Test(C<A));
	printf("C %s equal to A\n", Test(C==A));
	printf("C %s not equal to A\n", Test(C!=A));
	printf("A %s a subset of A\n", Test(A<=A));
	printf("A %s a proper subset of A\n", Test(A<A));
	printf("A %s equal to A\n", Test(A==A));
	printf("A %s not equal to A\n", Test(A!=A));
	printf("A %s a superset of C\n", Test(A>=C));
	printf("A %s a proper superset of C\n", Test(A>C));
}

void PrintSet(Set &Set1) {
  SETELEMENT counter;
	int NotFirst = 0;
	printf("{ ");
	for(counter = MINELEMENT; counter < (MINELEMENT + NUMELEMENTS); counter++)
		if (Set1 >= counter)
			if (NotFirst)
				printf(",%d",counter);
			else {
				printf("%d",counter);
				NotFirst = -1;
			}
	printf(" }\n");
} // I might add this to the Set class to output with 'cout', once I figure out
  // how
