/*
------------------------
Test Quicklist routines
------------------------
*/

parse arg TEMPFILE

if (TEMPFILE = '') then
   TEMPFILE = "quicklst.txt"

say "Trying to load/register Internet Adventurer REXX API"
if RxFuncQuery("IARX_Register") <> 0 then do
   rc = RxFuncAdd("IARX_Register","IA_UTILS","IARX_Register")
   if rc <> 0 then do
      say "-------------------------------------"
      say "Error loading Internet Adventurer API"
      say "-------------------------------------"
      exit(1)
   end
end

rc = IARX_Register();
if rc then do
   say "-------------------------------------"
   say "Error loading Internet Adventurer API"
   say "-------------------------------------"
   exit(1)
end

say "Opening database"
ptr = IARX_QOpenDatabase();
if length(ptr) > 0 then do
   say "-------------------------------------"
   say "Opening database gave this:" ptr
   say "-------------------------------------"
   exit(1)
end

say "Database opened - exporting to" TEMPFILE

'@echo off'
'del' TEMPFILE '1>NUL 1>NUL'

rc = lineout(TEMPFILE,,1)

signal on novalue name handlenovalue
signal on error   name handleerror
signal on syntax  name handleerror

call show_tree 0 0

say "Closing database"
rc = IARX_QCloseDatabase()

rc = lineout(TEMPFILE)

say "Exporting completed - look in" TEMPFILE
exit(0)

show_tree: procedure expose TEMPFILE
   arg id level

   rc = IARX_QMakeTree("t", id);
   if rc = 0 then do
      do i = 1 to t.items by 1
         str = copies(' ', level) || "Title:" '"' || t.i.title || '"'
         rc = lineout(TEMPFILE, str)

         if t.i.type = 1 then do
            rc = lineout(TEMPFILE, copies(' ', level) || "URL  :" '"' || t.i.url || '"') 

            if datatype(t.i.nick, "Number") = 1 then
               rc = lineout(TEMPFILE, copies(' ', level) || 'Nick : ""')
            else
               rc = lineout(TEMPFILE, copies(' ', level) || "Nick :" '"' || t.i.nick || '"')
         end
         else do
            call show_tree t.i.id level+1
         end
      end
   end

   drop t
   return

/*
-------------
Handle errors
-------------
Upon entry to this function, the contents of the variables are:
rc   - Error code
sigl - Line number, error occured in.

Now we just display the error code and text followed by the
source-line with the problem
*/

handleerror:

say "REXX Error" rc "in line" sigl ":" errortext(rc);
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;

/*
------------------------------
Handle variables without value
------------------------------
*/
handlenovalue:

say "REXX Error, trying to reference variable with no value in line" sigl;
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;
