/*
   IMPNETSC.CMD - Import Netscape bookmarks into Internet Adventurer, based on
                  work by Arnaldo H. Viegas de Lima <arnaldo@riosc.ibm.com>
*/

Parse arg BMFile
/*                                                                            */
/*- Initialize environment ---------------------------------------------------*/
/*                                                                            */
if RxFuncQuery('SysCreateObject') 
  then call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
if RxFuncQuery('SysSearchPath') 
  then call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath'

say "Trying to load/register Internet Adventurer REXX API"
if RxFuncQuery("IARX_Register") <> 0 then do
   rc = RxFuncAdd("IARX_Register","IA_UTILS","IARX_Register")
   if rc <> 0 then do
      say "-------------------------------------"
      say "Error loading Internet Adventurer API"
      say "-------------------------------------"
      exit(1)
   end
end

rc = IARX_Register();
if rc then do
   say "-------------------------------------"
   say "Error loading Internet Adventurer API"
   say "-------------------------------------"
   exit(1)
end

say "Opening database"
ptr = IARX_QOpenDatabase();
if length(ptr) > 0 then do
   say "-------------------------------------"
   say "Opening database gave this:" ptr
   say "-------------------------------------"
   exit(1)
end

say "Database opened"

BootDrive=BootDrive()
parse upper source . . MyName .
WorkDrive=filespec('DRIVE',MyName)
WorkDir=filespec('PATH',MyName)
WorkDir=WorkDrive||left(WorkDir,length(WorkDir)-1)
/*                                                                            */
/*- Define and validate BookMark file name -----------------------------------*/
/*                                                                            */
if BMFile=''
  then do
    NSDir=SysSearchPath('PATH','NETSCAPE.EXE')
    BMFile=filespec('drive',NSDir)||filespec('path',NSDir)||'BOOKMARK.HTM'
  end
if stream(BMFile,'C','QUERY EXISTS')=''
  then do 
    say 
    say 'Bookmarks file '''BMFile''' not found.'
    exit 4
  end

/* */
q.id = 0
q.parent = 0
q.children = 0
q.type = 0
q.title = "Imported from Netscape Navigator"
q.nick = ""
q.url = ""

rc = IARX_QCreate("q")
if rc <> 0 then do
   say "Unable to create group - aborting..."
   rc = IARX_QCloseDatabase()
   exit 11
end


/*                                                                            */
/*- Add all subfolders and URLs ----------------------------------------------*/
/*                                                                            */
say
say 'Processing bookmarks file '''BMFile''''
say
NextName='Navigator QuickList Entries'
NextLocation=q.id
Level=1
FldCnt = 0;
Location.Level = 1

do while lines(BMFile)
  Line=strip(linein(BMFile))
  Lead=left(Line,6)
  select 
    when left(Lead,4)='<DL>' 
      then do
        Level=Level+1
        Name.Level=NextName
        Location.Level=NextLocation
      end
    when left(Lead,5)='</DL>' then Level=Level-1
    when Lead='<DT><H'
      then do 
        parse var Line . '">'FolderName '</H3>' 
        FldCnt=FldCnt+1
        NextLocation=q.id
        NextName=FolderName
        q.id = 0
        q.parent = Location.Level
        q.children = 0
        q.type = 0
        q.title = FolderName
        q.nick = ""
        q.url = ""
        rc = IARX_QCreate("q")
      end  
    when Lead='<DT><A'
      then do
        parse var Line . 'HREF="' EntryURL '"' . '>' EntryName '</A>'
        q.id = 0
        q.parent = Location.Level
        q.children = 0
        q.type = 1
        q.title = EntryName
        q.nick = ""
        q.url = EntryURL
        rc = IARX_QCreate("q")

      end 
    otherwise 
  end  
end
call stream BMFile, 'c', 'close' 

say "Import completed."
exit
/*-----------------------------------------------------------------------------+
| BootDrive: returns an educated guess about the boot drive.                   |
+-----------------------------------------------------------------------------*/
BootDrive:
  EnvPath=value('PATH',,'OS2ENVIRONMENT')
  BootPos=pos(':\OS2',translate(EnvPath))
  if (BootPos\=0) 
    then return substr(EnvPath,BootPos-1,2)
    else do
      say 
      say 'Environment variable PATH is invalid. \OS2 is not present.'
      exit 8
    end 
