/* REXX installation script for Slip Dialer */

/*call SysLoadFuncs */
call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
call RxFuncAdd 'SysCurPos', 'RexxUtil', 'SysCurPos'
call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
call RxFuncAdd 'SysTextScreenRead', 'RexxUtil', 'SysTextScreenRead'


call SysCls
say ""
say "****************************************************************"
say "                      HOMERUN Installation"
say "****************************************************************"
say ""

rc = stream('homerun.exe','c','query exists')
if rc='' then
do
  say " Sorry, homerun.exe not found.  Must not be wrong directory.  Terminating."
  exit
end

instdir=""

curdir = directory()
if curdir='A:\' | curdir='B:\' then
do
   flopdir=directory()
   instdir='C'
   say ' Press enter to Install HOMERUN on drive 'instdir' or enter alternative'
   say ' drive such as D, E etc (type [exit] to cancel) >C'
   pos=SysCurPos(6, 49)
   do forever
      key = SysGetKey('ECHO')
      if key='0D'x then leave
   end
   answer=SysTextScreenRead(6,49,1)
   say " "
   if answer='exit' | answer='EXIT' then exit
   if answer<>'' then
   do
      parse upper var answer answer
      count=length(answer)
      if count<>1 then
      do
         count=count-1
         end=substr(answer,count,1)
         if end=":" then instdir=answer''"\"
         if end="\" then instdir=answer
      end
      if count=1 then instdir=answer''":\"
      check=directory(instdir)
      if check<>instdir then
      do
         say " Cannot find drive "answer
         say " Cancelling installation"
         exit
      end
      if check=instdir then
      do
          instd=instdir''"HOMERUN"
      end
   end

   say ""
   say " Homerun installation drive is "instdir
   say ""
   say " Continue with installation? Answer Y or N >Y"
   pos=SysCurPos(10, 44)
   pull answer .
   if answer<>"" & answer<>"Y" & answer<>"yes" then
   do
      say ""
      say " Answer was not Y, installation cancelled"
      enddir=directory(flopdir)
      exit
   end
   check=directory(instd)
   newdir=directory(instdir)
   if check<>instd then 'MD homerun'
   'copy A:\*.* 'instd
   newdir=directory(flopdir)
   newdir=newdir'runtime\'
   newdir'unzip 'newdir'vrobj.zip -d 'instd
   newdir=instd
end

if curdir<>'A:\' & curdir<>'B:\' then
do
   instd=curdir
   newdir=instd
   say ""
   say " Homerun installation directory is "instd
   say ""
   say " Continue with installation? Answer Y or N >Y"
   pos=SysCurPos(8, 44)
   pull answer .
   if answer<>"" & answer<>"Y" & answer<>"yes" then
   do
      say ""
      say " Answer was not Y, installation cancelled"
      exit
   end
end

call SysIni instd'\schedule.ini', inetlink, PROG, instd

filename = stream(instd'\homerun.exe','c','query exists')
if filename \= '' then
do
  title = "Homerun"
  classname = 'WPProgram'
  location = '<WP_DESKTOP>'
  setup = 'EXENAME='filename';STARTUPDIR='newdir
  if existed = '' then setup = setup';PARAMETERS=%*'
  call SysCreateObject classname,title,location,setup,u
end

/*call SysCls */

say ""
say ""
say "----------------------------------------------------------------"
say " Homerun Scheduler "
say " Written by Geoff Brown - All rights reserved "
say "----------------------------------------------------------------"
say ""
say " Homerun icon successfully created on the desktop..."
say ""
say " Start Homerun by double-clicking on the program object."
say ""
say "****************************************************************"
say " This program is  distributed as Shareware! You MUST register"
say " this product if you  continue  to  use it. Please  see the help"
say " directory for registration details."
say "****************************************************************"
say ""

exit
