
Area : Jason's Netmail

Date : Jun 10 '95, 22:29                                                   pvt 
From : hamish@cloud.apana.org.au                                 1:203/2
To   : Jason Fesler                                           1:203/7707
Subj : Waffle munging etc                                                    


@MSGID: mid__4881CF31@cloud.apana.org.au c2140001
@PID GIGO+ sn 1 at gigo vsn 0.99.950303
A while back, you asked about getting my Waffle munging source in Pascal ..

Saturday May 27 1995 18:05, Hamish Moffatt wrote:

 HM>> Or if anyone's interested, I have pascal code available ...
 HM>> (implemented from those Waffle docs you're obviously not
 HM>> fond of Jason :-)

 > Cute :-)   If you get the chance, any possibility of emailing them?
 > A lot of people are Pascal lovers (I'm just a closet Pascal lover), and
 > would find that source to be useful..

I've just dressed it up (like written comments, rewrote lots of it in more 
mathematical ways, for nicety reasons). I wrote it QUITE a few years ago, so 
documenting it has been quite an exercise. Working out why it was calculating 
the bitmask on the last five characters of the filename BACKWARDs, etc. Seems 
to work, tested it on the Waffle manual's examples and some actual filenames 
from my log. And I've learnt a fair bit about programming in those few years 
(was 16 then :-)

It's still complicated enough, but certainly no worse than the Waffle manual, 
which is where I wrote it from. And if you're writing internet-type software 
like your GIGO or my interRA, that's not for the faint of heart anyway :-)

As to closet Pascal lovers, I'm a bit of a closet Ada lover, though I haven't 
yet found the need to implement it in Ada. Would be much like the Pascal 
source though.. If you ever get asked for munge source in Ada just drop me a 
line :-)

Here's the source. (Not a unit or program, but rather more just an include 
file. End user should package up as appropriate. Includes free power 
function! Unfortunately Pascal has no ** operator).


{ Munge converts a unix-type filename found in a UUCP C or X file,
  of the form D.ozoneB7n72, into a DOS filename, using the same
  algorithm used in Waffle, FX UUCICO etc. From the description
  in the Waffle documentation:

  For conversion, the prefix is moved to the end of the filename,
  and the system name is stripped off. An extra byte is added to
  prevent collisions due to DOS's handling (or lack thereof) of
  mixed case filenames.

      D.ozoneBC0312   ->   /SPOOL/OZONE/0BC0312.D
      X.ozoneBC0312   ->   /SPOOL/OZONE/0XC0212.X

  You will notice a leading "0" before the filename. This is a
  bitmask of the alphabetic case of the remaining characters.

  In this example below, the bitmasks are "4" and "6" respectively:

      D.ozoneB7n72    ->   /SPOOL/OZONE/4S7N72.D
      X.ozoneX7pt0    ->   /SPOOL/OZONE/6X7PT0.X

  To construct the bitmask, give all lowercase characters a value
  of 1 and all uppercase or numeric value 0; do not include the
  hostname when forming the bitmap. Also use only the last five
  characters when constructing the bitmask. When taken together, the
  the numeric value of the bitmask is the value of the leading byte.
  If this exceeds 9, use the letters A through Z as necessary.

  This pascal implementation is public domain.
  Written by Hamish Moffatt, hamish@rising.com.au,
  released June 11, 1995.

}

{ Power raises a byte i to the jth power
  Parameters: two bytes, returns a longint
  This is required when calculating the bit mask.
}

Function power(i, j : byte) : longint;
var
  k    : byte;     { Counter }
  temp : longint;  { Working power }

begin
  temp := 1;

  { Multiple power by i, j times }
  for k := 1 to j do
    temp := temp * i;

  power := temp;

end;

{ Munge does the actual filename munging.
   Parameters:
   filename      : filename to convert;
   remote_system : name of remote system (one word UUCP name,
                   eg cloud, rather than cloud.apana.org.au)
}

function munge(filename, remote_system : string) : string;

var
  filetype : char;
  bitmask  : byte;
  counter  : byte;
  lastfive : string;

const

  { Table of characters used when converting the calculated bitmask
    back into ASCII. This could be done a bit more mathematically,
    for those so inclined (or those feeling the need for excessive speed). }

  mungetab : array[0..35] of char = ('0', '1', '2', '3', '4', '5', '6', '7',
       '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
       'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z');

begin

  { Only the first seven characters of the system name are ever used
    in filenames, so we must remove anything left over. }

  delete(remote_system, 8, length(remote_system) - 7);

  { The file type (generally C, D or X) is not used in munging, but
    should be passed back to the calling routine. Hence we store
    it away and remove it from the working filename. }

  filetype := filename[1];
  delete(filename, 1, 2);

  { If the remote system name is found at the start of the filename,
    remove it; it is not used in the calculation. }

  if pos(remote_system, filename) = 1 then
    delete(filename, 1, length(remote_system));

  { Only the last five characters of the filename are used in
    the bitmask calculation, and they are needed in reverse order }

  lastfive := copy(filename, length(filename) - 5, 5);

  { For each character in the filename, add 2^(position-1) if the character
    is lower case. If not lower case, do nothing. This calculates the
    actual bitmask. }

  bitmask := 0;

  for counter := 1 to 5 do
    if lastfive[counter] in ['a'..'z'] then
      bitmask := bitmask + power(2, 5-counter);

  { "5-counter" is because the last character of the filename
    contributes the least significant bit in the bitmask. }


  { Concatenate the final filename; first the bitmask, which is
    looked up in the table above for ASCII conversion; then
    the five remaining characters of the original filename,
    then a period and the filetype. }

  munge := concat(mungetab[bitmask], filename, '.', filetype);

end;



--- Email headers follow ---
Apparently-to: jfesler@gigo.com
X-Delivered-From: Unknown_IP_Address_203.12.22.20
X-Received-By OS/2 SMTP Daemon v0.1/gigo
Received: gigo.com Sun Jun 11 12:31:48 1995
Received: from cloud.UUCP (Ucloud@localhost) by connexus.apana.org.au
(8.6.9/8.6.9) with UUCP id FAA05522 for gigo.com!jfesler; Mon, 12 Jun 1995
05:06:38 +1000
Received: by cloud.apana.org.au (0.55/interRA)
        via UUCP; Sun, 11 Jun 1995 16:29:00 +1100
        for jfesler@gigo.com
To: jfesler@gigo.com
Subject: Waffle munging etc
From: hamish@cloud.apana.org.au (Hamish Moffatt)
Message-Id: <4881CF31@cloud.apana.org.au>
Date: Sun, 11 Jun 1995 16:29:00 +1100
Organization: Cloud Nine BBS, Melbourne, Australia


--- GIGO+ sn 1 at gigo vsn 0.99.950303
VIA GIGO 1:203/2, Sun Jun 11 1995  at 20:32 
