/* virtslip.cmd */
/*
   Version:     1.0a
   Date:        Feb 16, 1996
   By:          Jack Snodgrass - jack@cyberloans.com
*/

/***********************************************************************************************\
| First of all... this program will run the SLIP.EXE when run with no arguments. The slip.exe   |
| will call this program ( with arguments ) once for each virtual interface you are setting up  |
| as long as you create a ETC\virt.slp file as documented in the next section.                  |
\***********************************************************************************************/

/***********************************************************************************************\
| Also... once this program is run and everything completes, you should be able to ping your    |
| virtual IP Address from both your system and any other system on your network. If you can't   |
| ping each IP Address locally, something is probably really wrong. If you can't ping each IP   |
| address from another machine, the routing ( or ethernet hardware address ) is probably        |
| incorrect. You may want to try running IPTRACE and IPFORMAT to see what is going on.          |
\***********************************************************************************************/

/***********************************************************************************************\
| Lastly... if you use SLIP to connect to your ISP, then try running this program first, and    |
| start with SL1. Once this program exits, run SLIP again using SL0.                            |
\***********************************************************************************************/

/***********************************************************************************************\
| This program will set up the necessary routing to configure your OS/2 box with multiple IP    |
| addresses. It uses SLIP interfaces to accomplish this. To use this program, it needs to be    |
| placed in the \tcpip\bin directory. Also, your ETC directory needs to have a file called      |
| virt.slp that contains the following  5 lines for each IP Address you want to answer to.      |

interface sl0 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.2 -a 00:00:B4:65:D3:9A"
}

| where sl0 is sl0 to sl9  ( you may support up to 10 virtual IP Addresses this way )           |
|       device is your COM port you want to use. I use a SIO Virtual Com port, but I think that |
|              a real COM port will work too.                                                   |
|       attachcmd is the name of this program. This HAS to be in the \tcpip\bin directory.      |
|       attachparms needs to be double quoted. The '-ip' parm is required. This tells what IP   |
|              address you are going to use. The '-a' part is not required, but may be needed   |
|              if the network does not know to route your virtual IP Addresses to your box. I   |
|              don't know if this will work for a PPP or SLIP only system. You may HAVE to have |
|              your network route all of your virtual IP Addresses to your box. The data on the |
|              '-a' parm is your ethernet hardware address. You can do a 'netstat -n' to get    |
|              this info. The format xx:xx:xx:xx:xx:xx is required if you use this. Lastly. you |
|              can also use a '-k' parm ( this should only be used on the LAST interface, in the|
|              LAST posistion ) to specify how to kill the SLIP.EXE. The SLIP.EXE does not need |
|              to remain running after this is setup. If you don't specify anything here, you   |
|              will need to manually CTRL-C out of the SLIP.EXE to kill slip.                   |
|                                                                                               |
| A complete, 10 interface example would be:                                                    |

interface sl0 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.2 -a 00:00:B4:65:D3:9A"
}
interface sl1 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.3 -a 00:00:B4:65:D3:9A"
}
interface sl2 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.4 -a 00:00:B4:65:D3:9A"
}
interface sl3 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.5 -a 00:00:B4:65:D3:9A"
}
interface sl4 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.6 -a 00:00:B4:65:D3:9A"
}
interface sl5 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.7 -a 00:00:B4:65:D3:9A"
}
interface sl6 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.8 -a 00:00:B4:65:D3:9A"
}
interface sl7 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.9 -a 00:00:B4:65:D3:9A"
}
interface sl8 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.10 -a 00:00:B4:65:D3:9A"
}
interface sl9 {
 device=COM1,
 attachcmd=virtslip,
 attachparms="-ip 199.54.174.11 -a 00:00:B4:65:D3:9A -k go kill slip"
     or
 attachparms="-ip 199.54.174.11 -a 00:00:B4:65:D3:9A -k slipkill"
}

|                                                                                               |
\***********************************************************************************************/

parse arg slip , inargs
parse var inargs '-a' my_hwaddr .
parse var inargs '-ip' slip_ip .
parse var inargs '-k' killslip

if slip_ip = '' then do
   'slip -f virt.slp'
   exit
end

portid = substr(slip, 3, 1);
say 'Adding Virtual Slip port' slip || '.'
/* '@ECHO OFF' */
'ifconfig' slip slip_ip
/* '131.131.131.'|| portid + 1 */
'route add' slip_ip '127.0.0.1 0'
if my_hwaddr \= "" then
   'arp -s' slip_ip  my_hwaddr 'pub'

if killslip \= "" then
   killslip
exit

