/*
 * WORKLab System Solutions, Krebber, 1996
 *
 * installation & setup of LOGOART
 *
 * usage:   install [<drive>] [<target_directory>]
 *
 * The installation procedure does the following :
 *  1) copies all source files in the installation disk to the
 *     indicated target-directory
 *  2) generates the target-directory if not already there (if
 *     already there files with same names will be replaced..)
 *  3) creates WPS folder and objects for sample art-files and
 *     executable.
 *
 *  ===> to install to the current directory enter
 *  ===>    install . .
 *
 *  NOTE: this procedure does no modifications to the config.sys.
 *        The user.ini file is updated to hold information about
 *        "art"-type files.
 *
 *        Also notice that the installation disk must be named "LOGOART".
 *       
 *        If you have downloaded LARTB30.ZIP from a mailbox, then
 *        please unzip the file *once* and copy the files to a diskette before
 *        proceeding with the installation.
 *
 */

version     = "LARTB30"
version_short = " B30"
bin_pack    = "ARTB307.ZIP"
clip_pack   = "CLIPART.ZIP"
bitmap_pack   = "BITMAP.ZIP"

hyellow  ='[1;33m[1A'
hwhite   ='[1;37m[1A'
nline    = "0D0A"x                                        /* new line */

/*----------------------------------------------------------------------*/
/* start of code                                                        */
/*----------------------------------------------------------------------*/

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

say nline hyellow
say "LOGOART Installation (V."||version||")"nline
parse arg source target
say hwhite
call notes

if source = "-h" then call usage;

/*----------------------------------------------------------------------*/
/* resolve source and target                                            */
/*----------------------------------------------------------------------*/
if source= "" then do
   source = "A:"
   target = "C:\"||version;
end  
if target = "" then target = "C:\"||version;  
if source="." then source = directory();
if target="." then target = directory();

say "Installing from ["||source ||"] to ["||target||"]."
say "Target will be created if needed. Continue ? (Y/N)";
pull cont
if cont \= 'Y' then call abort;

/*----------------------------------------------------------------------*/
/* create target directory and copy files                               */
/*----------------------------------------------------------------------*/

/* check source */
if source="a:" | source="b:" then do
name = right(SysDriveInfo(source), 15)
say name
   if strip(name, B, " ") \="LOGOART" then do
      say "drive not ready or not LOGOART Installation-Disk in drive".
      call abort;
   end
end

/* check target and copy files */
"@echo off"
if target \= source then do
   rc = SysMkDir(target);
   if rc > 0 & rc \=5 then do
      say "could not create" target;
      call abort;
   end  /* Do */

   if rc = 5 then do
      say target "already exists. Overwrite files ? (Y/N)";
      pull cont;
      if cont \= 'Y' then call abort;
   end /* do */

   say "copying files ..";
   "copy " source||"\*" target;
end
source=source||"\"

/* make directory for cliparts */
call directory target 
rc = SysMkDir("CLIPART");
rc = SysMkDir("BITMAP");

"move" clip_pack "clipart"
"move" bitmap_pack "bitmap"
"@echo on"

say "unzip in progress..";
/* BIN */
"unzip" bin_pack
"del" bin_pack
/* CLIPART */
call directory target||"\clipart" 
"..\unzip" clip_pack
"del" clip_pack
/* BITMAP */
call directory target||"\bitmap" 
"..\unzip" bitmap_pack
"del" bitmap_pack

call directory target 

/* make WPS objects */
call makefldr version_short no_wait

/*----------------------------------------------------------------------*/
/* create program objects on WPS-Desktop                                 */
/*----------------------------------------------------------------------*/

say hyellow
say "*** LOGOART installation ended. ***";
say hwhite
exit;


notes:
n.0=""
n.1="The installation procedure does the following :"
n.2=" 1) copies all source files in the installation disk to the"
n.3="    indicated target-directory"
n.4=" 2) generates the target-directory if not already there (if"
n.5="    already there files with same names will be replaced..)"
n.6=" 3) creates WPS folder and objects for sample art-files and"
n.7="    executable."
n.8=""
n.9=" NOTE: this procedure does not modify the config.sys."
n.10="       The user.ini file is updated to hold information about"
n.11="       "art"-type files."
n.12=""
n.13="       If you have downloaded LARTB307 from a mailbox, then"
n.14="       please unzip it *once* and copy the files to a diskette before"
n.15="       proceeding with the installation."
n.16="       Also notice that the installation disk must be named "LOGOART"."
n.17=""
n.18="===> to install to the current directory enter"
n.19="===>    install . ."
n.20=""
n.21="Press enter to continue"

do i=0 to 21
   say n.i;
end 
pull
return;

/*----------------------------------------------------------------------*/
/* abort                                                                */
/*----------------------------------------------------------------------*/
abort:
say hyellow
say "*** LOGOART installation aborted. ***"
say hwhite

/*----------------------------------------------------------------------*/
/* usage                                                                */
/*----------------------------------------------------------------------*/
usage:
u.0 = ""
u.1 = "usage:  install [<source-drive>] [<target_path>]";
u.2 = "";
u.3 = "The installation disk must be named 'LOGOART' ";

do i=0 to 3
   say u.i;
end /* do */
exit;

