/*
 * Salsa, copyright (C) Irisa/Inria 1996
 *
 * $Id: salsa_types.h,v 1.5 1996/12/18 16:20:38 muller Exp muller $
 *
 * $Log: salsa_types.h,v $
 * Revision 1.5  1996/12/18 16:20:38  muller
 * - support for seperate VTable definition per classe
 * - support for guarding Monitors related calls to optimize single thread case
 *
 * Revision 1.4  1996/12/05 09:56:43  muller
 * specific struct for string constants
 *
 * Revision 1.3  1996/12/02 14:13:50  muller
 * Support for div by 0 and null pointers added
 *
 * Revision 1.2  1996/09/18 10:46:04  muller
 * babe -> salsa, preliminary TEMPO support
 *
 * Revision 1.1  1996/09/11 19:26:03  bellard
 * Initial revision
 *
 *
 */

#ifdef __GNUC__
#define COMPILER_ARRAY_MIN_SIZE 0
#else
/* Suif does not like array with a null length */
#define COMPILER_ARRAY_MIN_SIZE 1
#endif

/* header for any object */
typedef struct ObjectHeader {
  struct _VTable *vtable;     /* cache for the method table */
  int size;                   /* total size of the object. this field will be
			         replaced by a mutex index and by some flags for
				 the GC */
} ObjectHeader;


typedef struct Object {
  ObjectHeader __header;
  char data[COMPILER_ARRAY_MIN_SIZE];
} Object;

#ifndef NULL
#define NULL ((void *)0)
#endif

/* an item stored on the stack of the Virtual Machine */
typedef union _StackItem {
  TREF r;
  TINT i;
  TLONG l;
  TFLOAT f;
  TDOUBLE d;
} StackItem;

/* an exception environment */
typedef struct _ExceptionEnv {
  struct _ExceptionEnv *ret_exception_env;  /* pointer to the previous
					       environment */
  jmp_buf jbuf;
} ExceptionEnv;

#define GET_CLASS(r) (r->__header.vtable->class)

/* structure for a class */
typedef struct Class {
  ObjectHeader		__header;

  /* the following fields are extracted from the .class file */

  char *name;          /* name of the class */
  int access_flags;    /* access flags */
  
  char *super_name;    /* name of the superclass */

  union _ClassConstant	*constant_pool;   /* entries of the constant pool */

  char                  *constant_tags;   /* type of each entry of the 
					     constant pool */ 
  int                   constant_count;   /* number of entries */

  struct ClassMethod *methods;           /* methods of the class */
  int methods_count;                     /* # methods */

  struct _ClassField *fields;            /* idem fields */
  int fields_count;

  struct _ClassInterface *interfaces;    /* idem interfaces */
  int interfaces_count;
  
  /* the following fields are initialized when the class is resolved */

  struct Class *super;       /* superclass */

  int fields_offset;         /* offset of the end of dynamic fields (in bytes) */
  int fields_align_max;      /* alignement of the object structure (in bytes) */
  int instance_size;         /* size of an instance of the class (in bytes) */

  void *static_fields;     /* pointer to the static data */
  int static_fields_size;  /* size (in bytes) */

  struct _VTable *vtable;             /* virtual method table */
  int virtual_methods_count;          /* size of the vtable */
  
  struct Class *array_of_class;    /* If the class is an array of refs,
					 this is the class of the refs, 
					 NULL otherwise */
  char array_data_size;                /* size in bytes of each element of 
					  the array */
  char array_header_size;              /* the size of the header of the array */

  int interface_id;                  /* the interface unique identifier */

  TREF class_loader;  /* class loader , NULL if none */

  struct Class *class_pool_next; /* next class in class_pool */

  struct Class *resolve_next;    /* next class to be resolved */
  int resolved;                  /* non nul if the class has been resolved */

  /* what are the subclasses of this class : these fields should be removed 
     from the class structure because they are only used in salsa2c */
  struct Class *sub_first;
  struct Class *sub_next;
} Class;

/* field structure */

typedef struct _ClassField {
  char *name;
  char *sig;
  int access_flags;
  
  /* the following fields are initialized when the class is resolved */
  int offset;

  /* the class to which the field belongs */
  Class *class;
  
  /* reference to a constant value in the constant pool */
  union _ClassConstant *value;

} ClassField;


/* method structure */

typedef struct ClassMethod {
  char *name;
  char *sig;
  int access_flags;

  /* the following fields are initialized when the class is resolved */

  /* offset in vtable */
  int offset;

  /* the class to which the method belongs */
  Class *class;

  /* the native code calls this method */
  void *native;

  /* the VM calls this function to execute the method */
  union _StackItem *(*native_stub)(struct ClassMethod *m,union _StackItem *vars); 
  
  /* the stub for calling a virtual method in bytecode from the C code */
  void *native_stubc;
  int args_size;  /* total number of arguments, in StackItem unit */
  int vars_size;  /* in StackItem unit */

  /* Non initialized fields in C code generated by salsa2c */
  unsigned char *code;   /* vm code */
  int code_size;   /* in bytes */
  int stack_size; /* in StackItem unit */

  struct _MethodException *exceptions;
  int exceptions_count;

  struct BytecodeInfo *bytecode_info;

} ClassMethod;

/* Information related to the bytecode. TODO: most of the fields in ClassMethod
   should be put here. ClassMethod should only contain information independent
   of the implementation of the method */

typedef struct BytecodeInfo {

  /* line numbers */
  int line_number_table_length;
  struct LineNumberTable *line_number_table;

  /* local variable table */
  int local_variable_table_length;
  struct LocalVariableTable *local_variable_table;

} BytecodeInfo;

/* debug info */
typedef struct LineNumberTable {
  int start_pc;
  int line_number;
} LineNumberTable;

typedef struct LocalVariableTable {
  int start_pc;
  int end_pc;
  char *name;
  char *sig;
  int offset;
} LocalVariableTable;


/* exception structure */

typedef struct _MethodException {
  int start_pc;
  int end_pc;
  int handler_pc;
  int class_index;
} MethodException;

typedef struct _ClassInterface {
  char *name;       /* name of the interface */

  /* runtime data */
  Class *class;  /* corresponding class */
} ClassInterface;


/* table of methods. We also need to know the class */
#define MK_VTable(t1)                                                 \
  typedef struct _VTable{                                              \
    struct Class *class;             /* the class of the object */     \
    struct ClassMethod **vtable_vm;  /* the method table for the vm */ \
    void ***itable;                  /* the interface method table */  \
    void *native[t1];                /* the virtual method table */    \
  } VTable

#ifdef SALSALIBS
  MK_VTable(0);    /* Def for compiling librairies */
#endif
  
/*
 * arrays 
 */

typedef struct HArray {
  ObjectHeader __header;
  int length;
} HArray;

#define MK_ARRAY(t1,t2)				\
typedef struct ArrayOf ## t2 {			\
  ObjectHeader __header;			\
  int length;					\
  t1 data[COMPILER_ARRAY_MIN_SIZE];			\
} ArrayOf ## t2

 MK_ARRAY(TBYTE,Byte);
 MK_ARRAY(TSHORT,Short);
 MK_ARRAY(TCHAR,Char);
 MK_ARRAY(TINT,Integer);
 MK_ARRAY(TLONG,Long);
 MK_ARRAY(TFLOAT,Float);
 MK_ARRAY(TDOUBLE,Double);
 MK_ARRAY(TREF,Object);


/* TODO : make it simpler  */
#define TYPES_MAX 11

#define T_BOOL   4
#define T_CHAR   5
#define T_FLOAT  6
#define T_DOUBLE 7
#define T_BYTE   8
#define T_SHORT  9
#define T_INT    10
#define T_LONG   11
#define T_REF    12

typedef struct {
  char *name;
  Class *class;
} ArrayTypeInfo;

extern ArrayTypeInfo array_type_info[];
extern int type_size[];
extern int type_bsize[];
extern int type_balign[];

/* predefined basic classes */

#define CLASSNAME_OBJECT "java/lang/Object"
#define CLASSNAME_STRING "java/lang/String"
#define CLASSNAME_THREAD "java/lang/Thread"
#define CLASSNAME_CLASS  "java/lang/Class"

extern Class *ClassClass;
extern Class *ClassObject;
extern Class *ClassString;

/* access flags */

#define	ACC_PUBLIC		0x0001
#define	ACC_PRIVATE		0x0002
#define	ACC_PROTECTED		0x0004
#define	ACC_STATIC		0x0008
#define	ACC_FINAL		0x0010
#define	ACC_SYNCHRONIZED	0x0020
#define	ACC_VOLATILE		0x0040
#define	ACC_TRANSIENT		0x0080
#define	ACC_NATIVE		0x0100
#define	ACC_INTERFACE		0x0200
#define	ACC_ABSTRACT		0x0400

/* non standard flags. TODO: the compiled flag should be used when mixing
   native and interpreted classes */
#define ACC_COMPILED            0x0800
#define ACC_EXPLORED            0x1000

/*
 * Constant pool definitions
 */

#define	CONSTANT_Class			7
#define	CONSTANT_Fieldref		9
#define	CONSTANT_Methodref		10
#define	CONSTANT_InterfaceMethodref	11
#define	CONSTANT_String			8
#define	CONSTANT_Integer		3
#define	CONSTANT_Float			4
#define	CONSTANT_Long			5
#define	CONSTANT_Double			6
#define	CONSTANT_NameAndType		12
#define	CONSTANT_Utf8			1
#define	CONSTANT_Unicode		2

#define	CONSTANT_Unknown		0
#define	CONSTANT_Chararray		128

#define CONSTANT_String_res             127  /* a resolved string */
#define CONSTANT_Class_res              126  /* a resolved class */
#define CONSTANT_Methodref_res          125  /* a resolved method */

/* an entry of the constant pool */
typedef union _ClassConstant {
  TLONG c_long;
  struct {
    int low;
    int high;
  } mk_long;
  TDOUBLE c_double;
  TINT c_int;
  TFLOAT c_float;
  char *c_utf8;
  struct String *c_string;
  Class *c_class;
  ClassMethod *c_method;
  struct {
    int class_index;
    int nt_index;
  } c_ref;
  struct {
    int name_index;
    int sig_index;
  } c_nt;
} ClassConstant;

typedef struct _ClassConstantString {
  struct String *c_string;
  char dummy[sizeof(ClassConstant)-sizeof(struct String *)];
} ClassConstantString;

/* a java string */
typedef struct String {
  ObjectHeader __header;
  ArrayOfChar *value;
  TINT offset;
  TINT count;
} String;

/* a java exception */
typedef struct Throwable {
 ObjectHeader __header;
 Object * backtrace;
 String * detailMessage;
} Throwable;

/* This is horrible. TODO: find a better solution */
#define Hjava_lang_Class  Class
#define Hjava_lang_Object Object
#define Hjava_lang_String String


/* Unicode.c */

int Utf8toUnicodeLength(char *src);
int Utf8toUnicode(TCHAR *dest,char *src);

int UnicodetoUtf8Length(TCHAR *src,int len);
int UnicodetoUtf8(char *dest,int dest_len,TCHAR *src,int len);

/* ClassHandler.c */

#define CLASSHASH_SIZE 512

extern int interface_id_count;

Class* lookupClass(Class *class_for_loader,char *c);
void resolveClass(Class *c);

void setClassInitFunc(void (*init_func)(ClassMethod *));
void setSystemNativeClasses(Class **resolve_tab,void **init_tab);

void initSystemClasses(void);

/* ClassLoader.c */

#define JAVAMAGIC       0xCafeBabe
#define MAJOR_VERSION   45
#define MINOR_VERSION   3

extern int load_debug_info;

Class *defineClass(unsigned char *class_buf, int class_size);
Class *defineClassArray(char *name);

/* SystemClassLoader.c */

void initSystemClassLoader(void);
Class *findSystemClass(char* cname);

#ifndef TEMPO
void errorClass(char *format,...);
#endif


/* Memory.c */

void *allocMemory(int size);
void freeMemory(void *p);
TREF newObject(Class *class);
Class *newClass(void);
TREF newArray(Class *class,int length);
void *reallocMemory(char *p, int size);


/* Exception.c */

void initExceptions(void);

#ifndef __GNUC__
#define  __attribute__(x)
#endif
/* Attribute is supported only by GCC */
void throwException(TREF r) __attribute__ ((noreturn));
void throwArithmeticException()  __attribute__ ((noreturn));
void throwNullPointerException()  __attribute__ ((noreturn));
  
void Force_code();
  
extern TREF ClassFormatError;
extern TREF LinkageError;
extern TREF NoClassDefFoundError;
extern TREF NoSuchFieldError;
extern TREF NoSuchMethodError;
extern TREF OutOfMemoryError;
extern TREF UnsatisfiedLinkError;
extern TREF VirtualMachineError;
extern TREF ClassCircularityError;
extern TREF IncompatibleClassChangeError;

extern TREF NegativeArraySizeException;
extern TREF ClassCastException;
extern TREF IllegalMonitorStateException;
extern TREF NullPointerException;
extern TREF ArithmeticException;
extern TREF ArrayIndexOutOfBoundsException;
extern TREF ArrayStoreException;

/* Native.c */

int findNativeMethod(char *native_stub_name, ClassMethod *m);
void initLibraryLoader(void);

/* vm.c */

#ifndef TEMPO
StackItem do_execute_java_method_vararg(void *env,TREF obj,
				    char *method_name,char *method_sig,
				    ClassMethod *m,int is_static,
				    va_list ap);
#endif

StackItem *execVM_Profile(ClassMethod *m,StackItem *vars);
StackItem *execVM_WithExceptions(ClassMethod *m,StackItem *vars);
StackItem *execVM_Synchronized(ClassMethod *m,StackItem *vars);
StackItem *execVM(ClassMethod *m,StackItem *vars);

extern int allow_bytecode_quick;
extern int use_profiler;
extern int init_system_classes_done;
void printProfile(void);
void initProfile(void);

/* ClassUtils.c */

int getSigTypeInt(char *sig);
int getSigType(char *sig);
char *getNextSig(char *sig);
int getArgsSize(char *sig);

int hasByteCode(ClassMethod *m);

Class *findClassOfArrayOfObject(Class *class,Class *c);
ClassMethod *findClassMethod(Class *c,char *name,char *sig);
ClassMethod *findMethod(Class *class,char *name,char *sig);

ClassConstant *findConstant1(Class *class,int c);
ClassConstant *findConstant(Class *class,int c,int type);
Class *findClassIndex(Class *class,int d);
ClassMethod *findClassMethodIndex(Class *class,int d);
ClassField *findClassFieldIndex(Class *class,int d);
ClassMethod *findInterfaceMethodIndex(Class *class,int d);
String *findClassStringIndex(Class *class,int d);

void genCIdent(char *str,char *ident);
void genMethodName(char *str,ClassMethod *m);

/* misc */

int InstanceOf(Class *c,Class *class);
extern void (*_MonitorEnter)(TREF obj);
extern void (*_MonitorExit)(TREF obj);
void MonitorEnterNULL(TREF obj);
void MonitorExitNULL(TREF obj);

int enterBabeVM(Class *native_class,
		void (*entry_point)(int,char **),
		int argc,char **argv,
		void (*exception_handler)(TREF obj));


#define IDENT_SIZE_MAX 512

Class *getFirstClass(void);
Class *getNextClass(void);
