/*
 * Salsa, copyright (C) Irisa/Inria 1996
 *
 * $Id: salsa_support.h,v 1.5 1996/12/18 16:22:37 muller Exp $
 *
 * $Log: salsa_support.h,v $
 * Revision 1.5  1996/12/18 16:22:37  muller
 * - support for guarding Monitors related calls to optimize single thread case
 * - bug corrected in HUGE_VAL definition for SCC/TEMPO
 *
 * Revision 1.4  1996/12/05 09:55:36  muller
 * Floats operations are now macros
 *
 * Revision 1.3  1996/12/02 14:12:56  muller
 * Support for div by 0 and null pointers added
 *
 * Revision 1.2  1996/09/18 10:45:11  muller
 * Float functions are defined as inline
 *
 * Revision 1.1  1996/09/11 19:21:26  bellard
 * Initial revision
 *
 *
 */

#include <math.h>

/* In Support.c */
extern int WarningUnresolved;
extern int WarningUnimplemented;

int javaStringLength(Hjava_lang_String *str);
Hjava_lang_String *makeJavaString(char *s, int len);
Hjava_lang_String *makeJavaStringFromUtf8(char *s);
char *javaString2CString(Hjava_lang_String *str, char *s, int len);

void ClassDotName2ClassName(char *buf,char *name);

#ifndef TEMPO
/* Pb with nb variable d'arguments */
StackItem do_execute_java_method(void *env,TREF obj,
			     char *method_name,char *method_sig,
			     ClassMethod *m,int is_static,...);

StackItem execute_java_static_method(void *env,Class *class,
				 char *name,char *sig,...);

TREF execute_java_constructor(void *env,
			      char *class_name,Class *class,char *sig,...);
#endif

#ifdef __GNUC__
/* Attribute is supported only by GCC */

void SignalError(void *env,char *class_name,char *format) 
     __attribute__ ((noreturn));

void buildException_vararg(char *class_name,char *format,va_list ap) 
     __attribute__ ((noreturn));

void buildException(char *class_name,char *format,...)
     __attribute__ ((noreturn));

void errorInternal(char *format,...)
     __attribute__ ((noreturn));

void errorNotImplemented(char *str)
     __attribute__ ((noreturn));
#else
void SignalError(void *env,char *class_name,char *format);

#ifndef TEMPO
void buildException(char *class_name,char *format,...);

void errorInternal(char *format,...);
#endif TEMPO

void errorNotImplemented(char *str);
#endif __GNUC__

extern ExceptionEnv *exception_env;
extern TREF exception_obj;

#ifndef TEMPO
TREF newMultiArray(Class *class,int dims,...);
#endif

/* We assume glibc floating point constants are used for NaN and
 +/-infinity.  TODO: make it work for all architectures */

#ifdef __SCC__
/* don't define this now. Cross compiler dependent definition */
extern double NAN;
extern double HUGE_VAL;
#else

#ifndef NAN
#define NAN (0.0/0.0)
#endif

#ifndef HUGE_VAL
#define HUGE_VAL (1.0/0.0)
#endif
#endif __SCC__

/* some floating point instructions */
#define vmFREM(a,b) (a-rint(a/b)*b)

#define vmDREM( a, b) (a-rint(a/b)*b)

#define vmLCMP( a, b) ((a<b) ? -1 : ((a==b) ? 0 : 1))

#define vmFCMPL( a, b) ((a<b) ? -1 : ((a==b) ? 0 : 1))

#define vmFCMPG( a, b) ((a>b) ? 1 : ((a==b) ? 0 : -1))

#define vmDCMPL( a, b) ((a<b) ? -1 : ((a==b) ? 0 : 1))

#define vmDCMPG( a, b) ((a>b) ? 1 : ((a==b) ? 0 : -1))

/* exceptions */

/* This macro is used to enter in an exception region. It adds the
 * ExceptionEnv structure 'ee' to the exception stack. When an exception
 * is thrown, we check whether it is an instance of 'class'. If it is
 * the case, we pop 'levels' ExceptionEnv from the stack, and jump to the
 * label 'label' which corresponds to the exception handler. If the exception
 * is not an instance of 'class', we pop the current ExceptionEnv and jump
 * to the previous ExceptionEnv handler.
 *
 * There is a bug in GCC 2.7.2 -O2 which sometime does not generate
 * the else part following the setjmp in the ExceptionEnter macro.
 * The call to the null Force_code procedure permits the generation of the
 * desired code.
 */

#define ExceptionEnter(ee,class,levels,label)		\
{							\
  int i;						\
  if ( setjmp(ee.jbuf) != 0 ) {				\
    if (exception_obj != NULL && 			\
	InstanceOf(GET_CLASS(exception_obj),class)) {	\
      for(i=0;i<levels;i++) ExceptionExit();		\
      goto label;					\
    } else {						\
      exception_env=exception_env->ret_exception_env;	\
      longjmp(exception_env->jbuf,1);			\
    }							\
  } else {						\
    ee.ret_exception_env=exception_env;			\
    exception_env=&ee;					\
    Force_code();                                       \
  }							\
}


/* We pop an ExceptionEnv from the exception stack */

#define ExceptionExit()					\
{							\
 exception_env=exception_env->ret_exception_env;	\
}

/* Macros for monitors */
#define MonitorEnter(x)                                 \
{                                                       \
  (*_MonitorEnter)(x);                                     \
}

#define MonitorExit(x)                                  \
{                                                       \
  (*_MonitorExit)(x);                                     \
}


