/*
 * Salsa, copyright (C) Irisa/Inria 1996
 *
 * $Id: salsa.h,v 1.3 1996/12/02 14:11:47 muller Exp $
 *
 * $Log: salsa.h,v $
 * Revision 1.3  1996/12/02 14:11:47  muller
 * Support for div by 0 and null pointers added
 *
 * Revision 1.2  1996/09/18 10:43:39  muller
 * babe -> salsa
 *
 * Revision 1.1  1996/09/11 19:19:36  muller
 * Initial revision
 *
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <setjmp.h>
#include <signal.h>

#ifndef __GNUC__
/* Attribute is supported only by GCC */
#define __attribute__(f)
#endif

#include <config.h>
#include <salsa_types.h>
#include <salsa_support.h>
#include "bytecode.h"

/* debugging */

void initDebug(void);
void endDebug(void);

#ifndef TEMPO
void ddprintf(char *format,...);

#ifdef DEBUGL

#define dlprintf(level,format, args...)				\
{								\
  if (DEBUGL>=level) { 						\
    ddprintf("In '%s': " format "\n",__FUNCTION__, ##args);	\
  }								\
}

#else 

#define dlprintf(level,format, args...)

#endif

#ifdef DEBUG

#define dprintf(format, args...)  \
  ddprintf("In '%s': " format "\n",__FUNCTION__, ##args);

#else

#define dprintf(format, args...)

#endif

#endif TEMPO
