@echo off
cls
echo.
echo        *************************************************************
echo        *                                                           *
echo        *              This batch file will install                 *
echo        *                                                           *
echo        *       a new Ferrari Cockpit (SVGA) by Rebrica Saso        *
echo        *                  new wheels by ???                        *
echo        *              GP2JAM by 2.0 Trevor Kellaway                *
echo        *   the advertisments from the 1996 saison v2.0 by  ???     *
echo        *                         and                               *
echo        *         PIETER'S GRANDPRIX 2 1996 CARSET v4.1             *
echo        *            by PK Arnall, Pieter van Dieren                *
echo        *                                                           * 
echo        *            This batch will change some files !            *
echo        *    If you don't want to continue now, press CTRL-BREAK.   *
echo        *                                                           *
echo        *                                                           *
echo        *************************************************************
echo.
echo.
pause
cls

rem Checking if the files are in the right directory --------------------

if not exist ..\gp2.exe goto wrong_dir

rem Moving GP2JAM -------------------------------------------------------

echo.
echo *** Copy GPJAM 2.0 to gp2\gamejams ***
echo.

copy gp2jam.exe   ..\gamejams
copy 32rtm.exe    ..\gamejams
copy dpmi32vm.ovl ..\gamejams
copy gp2edexp.exe ..\gamejams

Pause

rem Patching and updating GP2 -------------------------------------------

echo.
echo *** Patching and updating GP2 ***
echo.

gp2edexp 1996.gpe ..

Pause

rem Creating new wheels -------------------------------------------------

echo.
echo *** Updating new wheels ***
echo.

GP2JAM -y -bftyre1.BMP -j..\gamejams\b1ftr.JAM
GP2JAM -y -brtyre1.BMP -j..\gamejams\b1rtr.JAM
GP2JAM -y -bftyre2.BMP -j..\gamejams\b2ftr.JAM
GP2JAM -y -brtyre2.BMP -j..\gamejams\b2rtr.JAM
 
Pause

rem Creating a new cockpit ----------------------------------------------

echo.
echo *** Updating the new cockpit (SVGA) ***
echo.

copy cpithi.pcx ..\bitmaps\cpithi.pcx

Pause

rem  Installing new advertisements --------------------------------------

echo.
echo *** Updating main advertisements ***
echo.
gp2jam -y -badverts1.bmp -j..\gamejams\adverts1.jam
gp2jam -y -badverts2.bmp -j..\gamejams\adverts2.jam
echo.
echo.
echo *** Updating advertisements of ADELAIDE, AUSTRALIA
echo.
gp2jam -y -badl_ad1.bmp -j..\gamejams\adljams\adl_ad1.jam ***
echo.
echo.
echo *** Updating advertisements of BARCELONA, SPAIN ***
echo.
gp2jam -y -bbar1.bmp -j..\gamejams\barjams\bar1.jam
gp2jam -y -bbar2.bmp -j..\gamejams\barjams\bar2.jam
gp2jam -y -bbar_ad1.bmp -j..\gamejams\barjams\bar_ad1.jam
echo.
echo.
echo *** Updating advertisements of INTERLAGOS, BRAZIL ***
echo.
gp2jam -y -bbrz2.bmp -j..\gamejams\brzjams\brz2.jam
gp2jam -y -bbrz10.bmp -j..\gamejams\brzjams\brz10.jam
gp2jam -y -bbrz_ad1.bmp -j..\gamejams\brzjams\brz_ad1.jam
echo.
echo.
echo *** Updating advertisements of HOCKENHEIM, GERMANY ***
echo.
gp2jam -y -bhoc_ad1.bmp -j..\gamejams\hocjams\hoc_ad1.jam
echo.
echo.
echo *** Updating advertisements of HUNGARORING, HUNGARY ***
echo.
gp2jam -y -bhungary1.bmp -j..\gamejams\hunjams\hungary1.jam
gp2jam -y -bhun_ad1.bmp -j..\gamejams\hunjams\hun_ad1.jam
echo.
echo.
echo *** Updating advertisements of JEREZ, EUROPE ***
echo.
gp2jam -y -bjez_ad1.bmp -j..\gamejams\jezjams\jez_ad1.jam
echo.
echo.
echo *** Updating advertisements of MAGNY-COURS, FRANCE ***
echo.
gp2jam -y -bmag1.bmp -j..\gamejams\magjams\mag1.jam
gp2jam -y -bmag3.bmp -j..\gamejams\magjams\mag3.jam
gp2jam -y -bmag10.bmp -j..\gamejams\magjams\mag10.jam
gp2jam -y -bmag_ad1.bmp -j..\gamejams\magjams\mag_ad1.jam
echo.
echo.
echo *** Updating advertisements of MONTE-CARLO, MONACO ***
echo.
gp2jam -y -bmco2.bmp -j..\gamejams\mcojams\mco2.jam
gp2jam -y -bmco_ad1.bmp -j..\gamejams\mcojams\mco_ad1.jam
echo.
echo.
echo *** Updating advertisements of MONTREAL, CANADA ***
echo.
gp2jam -y -bmtl2.bmp -j..\gamejams\mtljams\mtl2.jam
gp2jam -y -bmtl_ad1.bmp -j..\gamejams\mtljams\mtl_ad1.jam
echo.
echo.
echo *** Updating advertisements of MONZA, ITALY ***
echo.
gp2jam -y -bmza1.bmp -j..\gamejams\mzajams\mza1.jam
gp2jam -y -bmza2.bmp -j..\gamejams\mzajams\mza2.jam
gp2jam -y -bmza3.bmp -j..\gamejams\mzajams\mza3.jam
gp2jam -y -bmza4.bmp -j..\gamejams\mzajams\mza4.jam
gp2jam -y -bmza_ad1.bmp -j..\gamejams\mzajams\mza_ad1.jam
gp2jam -y -bmza_ad2.bmp -j..\gamejams\mzajams\mza_ad2.jam
echo.
echo.
echo *** Updating advertisements of AIDA, PACIFIC ***
echo.
gp2jam -y -bpac2.bmp -j..\gamejams\pacjams\pac2.jam
gp2jam -y -bpac_ad1.bmp -j..\gamejams\pacjams\pac_ad1.jam
echo.
echo.
echo *** Updating advertisements of ESTORIL, PORTUGAL ***
echo.
gp2jam -y -bpor1.bmp -j..\gamejams\porjams\por1.jam
gp2jam -y -bpor_ad1.bmp -j..\gamejams\porjams\por_ad1.jam
echo.
echo.
echo *** Updating advertisements of IMOLA, SAN MARINO ***
echo.
gp2jam -y -bsan0.bmp -j..\gamejams\sanjams\san0.jam
gp2jam -y -bsan1.bmp -j..\gamejams\sanjams\san1.jam
gp2jam -y -bsan_ad1.bmp -j..\gamejams\sanjams\san_ad1.jam
gp2jam -y -bsan_ad2.bmp -j..\gamejams\sanjams\san_ad2.jam
echo.
echo.
echo *** Updating advertisements of SILVERSTONE, ENGLAND ***
echo.
gp2jam -y -bsilver2.bmp -j..\gamejams\siljams\silver2.jam
gp2jam -y -bsilver5.bmp -j..\gamejams\siljams\silver5.jam
gp2jam -y -bsilver6.bmp -j..\gamejams\siljams\silver6.jam
gp2jam -y -bsilver9.bmp -j..\gamejams\siljams\silver9.jam
gp2jam -y -bsil_ad1.bmp -j..\gamejams\siljams\sil_ad1.jam
echo.
echo.
echo *** Updating advertisements of SPA-FRANCORCHAMPS, BELGIUM ***
echo.
gp2jam -y -bspa2.bmp -j..\gamejams\spajams\spa2.jam
gp2jam -y -bspa_ad1.bmp -j..\gamejams\spajams\spa_ad1.jam
echo.
echo.
echo *** Updating advertisements of SUZUKA, JAPAN ***
echo.
gp2jam -y -bsuz_ad1.bmp -j..\gamejams\suzjams\suz_ad1.jam
echo.
goto ready

:wrong_dir
echo.
echo        *************************************************************
echo        *                                                           *
echo        *    You did not copy the files to the right directory!     *
echo        *    Make sure the files are in the GP2/1996 directory.     *
echo        *                                                           *
echo        *      Read README.TXT how to install the 1996 carset.      *
echo        *                                                           *
echo        *************************************************************
echo.
goto end

:ready
cls
echo.
echo.
echo.
echo        *************************************************************
echo        All updates have been installed. Now you can start the game
echo        and have fun with your new wheels, the svga-cockpit and the
echo        advertisements. You must use textures on trackside objects 
echo        and verges to be able to see these advertisements.
echo        *************************************************************
echo.
echo.
echo.
echo        *************************************************************
echo        *                                                           *
echo        *                 All files are now installed!              *
echo        *                                                           *
echo        *                                                           *
echo        * Remember: You will probably have to change some things    *
echo        *           within the game again.                          *
echo        *           (E.g. controller setup, graphics options etc.)  *
echo        *                                                           *
echo        *                                                           *
echo        *                    Have a great race!                     *
echo        *                                                           *
echo        *************************************************************
echo.
:end